/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.util;

import com.bokesoft.yes.common.util.DateUtil;
import com.bokesoft.yes.common.util.StringUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class TypeConvertor {
    public static final Object toJavaType(int targetType, Object value) {
        switch (targetType) {
            case 1: {
                return TypeConvertor.toInteger(value);
            }
            case 2: {
                return TypeConvertor.toString(value);
            }
            case 3: {
                return TypeConvertor.toDate(value);
            }
            case 4: {
                return TypeConvertor.toBigDecimal(value);
            }
            case 5: {
                return value;
            }
            case 6: {
                return TypeConvertor.toBoolean(value);
            }
            case 7: {
                return TypeConvertor.toLong(value);
            }
        }
        return null;
    }

    public static final Object toDataType(int targetDataType, Object value) {
        switch (targetDataType) {
            case 1001: {
                return TypeConvertor.toInteger(value);
            }
            case 1002: 
            case 1011: 
            case 1012: {
                return TypeConvertor.toString(value);
            }
            case 1003: 
            case 1004: {
                return TypeConvertor.toDate(value);
            }
            case 1005: 
            case 1006: 
            case 1007: {
                return TypeConvertor.toBigDecimal(value);
            }
            case 1008: {
                return value;
            }
            case 1009: {
                return TypeConvertor.toBoolean(value);
            }
            case 1010: {
                return TypeConvertor.toLong(value);
            }
        }
        return value;
    }

    public static final String toString(Object value) {
        String stringValue = "";
        if (value != null) {
            if (value instanceof Clob) {
                try {
                    stringValue = TypeConvertor.ClobToString((Clob)value);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            } else {
                stringValue = value.toString();
            }
        }
        return stringValue;
    }

    /*
     * Exception decompiling
     */
    public static String ClobToString(Clob clob) throws IOException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final Integer toInteger(Object value) {
        Integer integerValue = null;
        if (value == null) {
            integerValue = 0;
        } else if (value instanceof Integer) {
            integerValue = (Integer)value;
        } else if (value instanceof Long) {
            integerValue = ((Long)value).intValue();
        } else if (value instanceof BigDecimal) {
            integerValue = ((BigDecimal)value).intValue();
        } else if (value instanceof String) {
            String stringCache = (String)value;
            integerValue = stringCache.isEmpty() || stringCache.equalsIgnoreCase("false") ? Integer.valueOf(0) : (stringCache.equalsIgnoreCase("true") ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt((String)value)));
        } else if (value instanceof Boolean) {
            integerValue = (Boolean)value != false ? 1 : 0;
        } else if (value instanceof Double) {
            Double d = (Double)value;
            integerValue = d.intValue();
        } else if (value instanceof Number) {
            integerValue = ((Number)value).intValue();
        }
        return integerValue;
    }

    public static final Long toLong(Object value) {
        Long longValue = null;
        if (value == null) {
            longValue = 0L;
        } else if (value instanceof Long) {
            longValue = (Long)value;
        } else if (value instanceof Integer) {
            longValue = ((Integer)value).longValue();
        } else if (value instanceof BigDecimal) {
            longValue = ((BigDecimal)value).longValue();
        } else if (value instanceof String) {
            if (((String)value).length() == 0) {
                return 0L;
            }
            longValue = Long.parseLong((String)value);
        } else if (value instanceof Boolean) {
            longValue = (Boolean)value != false ? 1L : 0L;
        } else if (value instanceof Double) {
            Double d = (Double)value;
            longValue = d.longValue();
        } else if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        return longValue;
    }

    @Deprecated
    public static final Float toFloat(Object value) {
        Float floatValue = null;
        if (value == null) {
            floatValue = Float.valueOf(0.0f);
        } else if (value instanceof Integer) {
            floatValue = Float.valueOf(((Integer)value).floatValue());
        } else if (value instanceof Long) {
            floatValue = Float.valueOf(((Long)value).floatValue());
        } else if (value instanceof BigDecimal) {
            floatValue = Float.valueOf(((BigDecimal)value).floatValue());
        } else if (value instanceof String) {
            floatValue = ((String)value).length() == 0 ? Float.valueOf(0.0f) : Float.valueOf(Float.parseFloat((String)value));
        } else if (value instanceof Boolean) {
            floatValue = Float.valueOf((Boolean)value != false ? 1.0f : 0.0f);
        } else if (value instanceof Number) {
            floatValue = Float.valueOf(((Number)value).floatValue());
        }
        return floatValue;
    }

    @Deprecated
    public static final Double toDouble(Object value) {
        Double doubleValue = null;
        if (value == null) {
            doubleValue = 0.0;
        } else if (value instanceof Integer) {
            doubleValue = ((Integer)value).doubleValue();
        } else if (value instanceof Long) {
            doubleValue = ((Long)value).doubleValue();
        } else if (value instanceof BigDecimal) {
            doubleValue = ((BigDecimal)value).doubleValue();
        } else if (value instanceof String) {
            doubleValue = ((String)value).length() == 0 ? Double.valueOf(0.0) : Double.valueOf(Double.parseDouble((String)value));
        } else if (value instanceof Number) {
            doubleValue = ((Number)value).doubleValue();
        }
        return doubleValue;
    }

    public static final BigDecimal toBigDecimal(Object value) {
        return TypeConvertor.toBigDecimal(value, null);
    }

    public static final BigDecimal toBigDecimal(Object value, Integer scale) {
        return TypeConvertor.toBigDecimal(value, scale, null);
    }

    public static final BigDecimal toBigDecimal(Object value, Integer scale, Integer roundingMode) {
        BigDecimal decimalValue = null;
        if (value == null) {
            decimalValue = BigDecimal.ZERO;
        } else if (value instanceof BigDecimal) {
            decimalValue = (BigDecimal)value;
        } else if (value instanceof Integer) {
            decimalValue = new BigDecimal((Integer)value);
        } else if (value instanceof Long) {
            decimalValue = new BigDecimal((Long)value);
        } else if (value instanceof Float) {
            decimalValue = new BigDecimal(Float.toString(((Float)value).floatValue()));
        } else if (value instanceof Double) {
            decimalValue = new BigDecimal(Double.toString((Double)value));
        } else if (value instanceof String) {
            String str = value.toString();
            decimalValue = str.isEmpty() ? BigDecimal.ZERO : new BigDecimal(str);
        } else if (value instanceof Boolean) {
            BigDecimal bigDecimal = decimalValue = (Boolean)value != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (decimalValue != null && scale != null) {
            decimalValue = roundingMode != null ? decimalValue.setScale((int)scale, roundingMode) : decimalValue.setScale((int)scale, 4);
        }
        return decimalValue;
    }

    public static final Boolean toBoolean(Object value) {
        Boolean booleanValue = false;
        if (value != null) {
            if (value instanceof Boolean) {
                booleanValue = (Boolean)value;
            } else if (value instanceof Integer) {
                booleanValue = !((Integer)value).equals(0);
            } else if (value instanceof Long) {
                booleanValue = !((Long)value).equals(0L);
            } else if (value instanceof BigDecimal) {
                BigDecimal decimal = (BigDecimal)value;
                booleanValue = decimal.compareTo(BigDecimal.ZERO) != 0;
            } else if (value instanceof String) {
                booleanValue = ((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("1") ? Boolean.valueOf(true) : (((String)value).equalsIgnoreCase("false") || ((String)value).equalsIgnoreCase("0") ? Boolean.valueOf(false) : Boolean.valueOf(value.toString().length() != 0));
            }
        }
        return booleanValue;
    }

    public static final Date toDate(Object value) {
        Date dateValue;
        block17: {
            dateValue = null;
            if (value != null) {
                if (value instanceof Date) {
                    dateValue = (Date)value;
                } else if (value instanceof java.sql.Date) {
                    dateValue = (Date)value;
                } else if (value instanceof Long) {
                    dateValue = new Date((Long)value);
                } else if (value instanceof String) {
                    try {
                        if (StringUtil.isNumeric(value)) {
                            dateValue = new Date(TypeConvertor.toLong(value));
                            break block17;
                        }
                        dateValue = DateUtil.getDate((String)value, null);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                } else if (value instanceof Time) {
                    dateValue = new Date(((Time)value).getTime());
                } else if (value instanceof Timestamp) {
                    dateValue = new Date(((Timestamp)value).getTime());
                } else if (value instanceof LocalDateTime) {
                    dateValue = Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
                }
            }
        }
        return dateValue;
    }

    public static Integer[] toIntegerArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            Object[] t = (Object[])value;
            Integer[] v = new Integer[t.length];
            for (int i = 0; i < t.length; ++i) {
                v[i] = TypeConvertor.toInteger(t[i]);
            }
            return v;
        }
        if (value instanceof Integer[]) {
            return (Integer[])value;
        }
        if (value instanceof Integer) {
            Integer[] v = new Integer[]{(Integer)value};
            return v;
        }
        return null;
    }

    public static Long[] toLongArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Object[]) {
            Object[] t = (Object[])value;
            Long[] v = new Long[t.length];
            for (int i = 0; i < t.length; ++i) {
                v[i] = TypeConvertor.toLong(t[i]);
            }
            return v;
        }
        if (value instanceof Long[]) {
            return (Long[])value;
        }
        if (value instanceof Long) {
            Long[] v = new Long[]{(Long)value};
            return v;
        }
        return null;
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.getClass() == o2.getClass() && o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (o1 instanceof Long || o2 instanceof Long) {
            return TypeConvertor.toLong(o1).compareTo(TypeConvertor.toLong(o2));
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return TypeConvertor.toBigDecimal(o1).compareTo(TypeConvertor.toBigDecimal(o2));
        }
        if (o1 instanceof Integer || o2 instanceof Integer) {
            return TypeConvertor.toInteger(o1).compareTo(TypeConvertor.toInteger(o2));
        }
        if (o1 instanceof Boolean || o2 instanceof Boolean) {
            return TypeConvertor.toBoolean(o1).compareTo(TypeConvertor.toBoolean(o2));
        }
        if (o1 instanceof Date || o2 instanceof Date) {
            return TypeConvertor.toDate(o1).compareTo(TypeConvertor.toDate(o2));
        }
        return TypeConvertor.toString(o1).compareTo(TypeConvertor.toString(o2));
    }
}

