/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.util;

import com.bokesoft.yes.common.util.StringUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class FileUtil {
    public static String inputStream2String(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = -1;
        while ((i = is.read()) != -1) {
            baos.write(i);
        }
        String content = new String(baos.toByteArray());
        return content;
    }

    public static String File2String(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.isFile() && file.exists()) {
            String sXml = FileUtil.File2String(file, "UTF-8");
            return sXml;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String File2String(File srcFile, String encoding) throws IOException {
        String content = null;
        byte[] bytes = null;
        FileInputStream fin = null;
        if (srcFile == null || !srcFile.exists()) {
            return content;
        }
        try {
            bytes = new byte[(int)srcFile.length()];
            if (srcFile.canRead()) {
                fin = new FileInputStream(srcFile);
                fin.read(bytes);
                content = encoding == null ? new String(bytes) : new String(bytes, encoding);
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return content;
    }

    public static byte[] File2byte(String filePath) {
        File file = new File(filePath);
        return FileUtil.File2byte(file);
    }

    public static byte[] File2byte(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return FileUtil.File2byte(in);
    }

    public static byte[] File2byte(InputStream in) {
        byte[] result = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            byte[] buffer = new byte[1024];
            baos = new ByteArrayOutputStream();
            while ((len = in.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            result = baos.toByteArray();
            if (baos != null) {
                baos.close();
            }
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bytes2File(byte[] bytes, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        try {
            File dir = new File(filePath);
            if (dir.isDirectory() && !dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(filePath + "\\" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void createFoldIfNotExist(String foldPath) {
        File fp = new File(foldPath);
        if (!fp.exists()) {
            fp.mkdirs();
        }
    }

    public static String removeSlant(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        if (path.endsWith("\\")) {
            path = path.substring(0, path.lastIndexOf("\\"));
        } else if (path.endsWith("/")) {
            path = path.substring(0, path.lastIndexOf("/"));
        }
        return path;
    }

    public static String getFileName(String path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        int index = path.lastIndexOf("\\");
        if (index == -1) {
            index = path.lastIndexOf("/");
        }
        return index != -1 ? path.substring(index + 1) : path;
    }

    public static String getSuffixName(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    public static String getPrefixName(String fileName) {
        return fileName.substring(0, fileName.lastIndexOf("."));
    }

    public static void copyJars(File source, File dest, boolean delete) throws IOException {
        if (!(source != null && dest != null && source.exists() && dest.exists() && source.isDirectory() && dest.isDirectory())) {
            return;
        }
        if (delete) {
            FileUtils.cleanDirectory((File)dest);
        }
        FileUtils.copyDirectory((File)source, (File)dest, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
    }

    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/") || path.indexOf(":") > 0;
    }

    public static String getRelativePath(String realPath, String sPrefix) {
        if (FileUtil.isAbsolutePath(realPath)) {
            return StringUtil.replaceAll(realPath, sPrefix, "");
        }
        return realPath;
    }
}

