/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.ui;

import com.bokesoft.yigo.common.ui.AbstractRuntimeUIConfig;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONRuntimeUIConfig
extends AbstractRuntimeUIConfig {
    private static final String K_ROOT = "__root__";
    private static final String K_KEY = "key";
    private static final String K_VISIBLE = "visible";
    private static final String K_COLUMNS = "columns";
    private static final String K_CAPTION = "caption";

    public JSONRuntimeUIConfig() {
        super(K_ROOT);
    }

    private JSONRuntimeUIConfig(String key) {
        super(key);
    }

    public void initByJSONObject(JSONObject jsonConfig) {
        if (jsonConfig == null) {
            return;
        }
        String key = null;
        JSONObject compConfig = null;
        Iterator it = jsonConfig.keys();
        while (it.hasNext()) {
            key = (String)it.next();
            compConfig = (JSONObject)jsonConfig.get(key);
            if (this.isVisiable(compConfig)) {
                this.addVisibleField(key);
                this.initColumns(key, compConfig);
            }
            if (!compConfig.has(K_CAPTION)) continue;
            this.setUIValue(key, compConfig.getString(K_CAPTION));
        }
    }

    private void initColumns(String gridKey, JSONObject columnsConfig) {
        if (columnsConfig.has(K_COLUMNS)) {
            String columnKey = null;
            JSONObject columnJSON = null;
            JSONArray jsonColumns = columnsConfig.getJSONArray(K_COLUMNS);
            for (int n = 0; n < jsonColumns.length(); ++n) {
                columnJSON = (JSONObject)jsonColumns.get(n);
                if (!this.isVisiable(columnJSON) || !columnJSON.has(K_KEY)) continue;
                columnKey = (String)columnJSON.get(K_KEY);
                this.addVisibleField(gridKey, columnKey);
                this.initColumns(gridKey, columnJSON);
            }
        }
    }

    private boolean isVisiable(JSONObject compConfig) {
        return compConfig.has(K_VISIBLE) && compConfig.getBoolean(K_VISIBLE);
    }

    @Override
    protected AbstractRuntimeUIConfig createChildContainer(String containerKey) {
        return new JSONRuntimeUIConfig(containerKey);
    }
}

