/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractRuntimeUIConfig {
    private String key = null;
    protected List<String> visibleFields = null;
    protected HashMap<String, String> mapUIValues = new HashMap();
    private HashMap<String, AbstractRuntimeUIConfig> mapGridConfig = new HashMap();

    public AbstractRuntimeUIConfig(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setUIValue(String key, String uiValue) {
        this.mapUIValues.put(key, uiValue);
    }

    public String getUIValue(String key) {
        return this.mapUIValues.get(key);
    }

    private List<String> ensureVisibleFields() {
        if (this.visibleFields == null) {
            this.visibleFields = new ArrayList<String>();
        }
        return this.visibleFields;
    }

    public void addVisibleField(String fieldKey) {
        this.ensureVisibleFields().add(fieldKey);
    }

    public void addVisibleField(String gridKey, String fieldKey) {
        if (!this.mapGridConfig.containsKey(gridKey)) {
            this.mapGridConfig.put(gridKey, this.createChildContainer(gridKey));
        }
        AbstractRuntimeUIConfig containerConfig = this.mapGridConfig.get(gridKey);
        containerConfig.addVisibleField(fieldKey);
    }

    public boolean isVisibleField(String fieldKey) {
        if (this.visibleFields == null) {
            return false;
        }
        return this.visibleFields.contains(fieldKey);
    }

    public boolean isVisibleField(String gridKey, String fieldKey) {
        AbstractRuntimeUIConfig gridUIConfig = this.mapGridConfig.get(gridKey);
        if (gridUIConfig != null) {
            return gridUIConfig.isVisibleField(fieldKey);
        }
        return false;
    }

    protected abstract AbstractRuntimeUIConfig createChildContainer(String var1);
}

