/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.struct.syspara;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yigo.common.struct.syspara.ParaGroup;
import com.bokesoft.yigo.common.struct.syspara.ParaItem;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class ParaTable {
    private StringHashMap<ParaGroup> groupMap = new StringHashMap();

    public void put(String key, ParaGroup group) {
        this.groupMap.put(key, group);
    }

    public ParaGroup get(String key) {
        return (ParaGroup)this.groupMap.get(key);
    }

    public String getPara(String group, String key) {
        ParaGroup g = (ParaGroup)this.groupMap.get(group);
        if (g == null) {
            return null;
        }
        ParaItem item = g.get(key);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject jsonObj = new JSONObject();
        Iterator it = this.groupMap.entrySet().iterator();
        Map.Entry entry = null;
        while (it.hasNext()) {
            entry = it.next();
            ParaGroup group = (ParaGroup)entry.getValue();
            jsonObj.put((String)entry.getKey(), (Object)group.toJSON());
        }
        return jsonObj;
    }

    public void fromJSON(JSONObject jsonObj) throws Throwable {
        Iterator it = jsonObj.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            JSONObject obj = jsonObj.getJSONObject(key);
            ParaGroup group = new ParaGroup();
            group.fromJSON(obj);
            this.groupMap.put(key, group);
        }
    }
}

