/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.struct;

import com.bokesoft.yes.common.util.BaseTypeUtil;
import com.bokesoft.yigo.common.json.JSONSerializable;
import com.bokesoft.yigo.common.struct.PairItem;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class PairItemList
implements JSONSerializable {
    private ArrayList<PairItem> itemArray = new ArrayList();

    public void add(PairItem item) {
        this.itemArray.add(item);
    }

    public void add(Object value, String caption) {
        this.itemArray.add(new PairItem(value, caption));
    }

    public int size() {
        return this.itemArray.size();
    }

    public PairItem get(int index) {
        return this.itemArray.get(index);
    }

    public Object getValue(int index) {
        return this.itemArray.get(index).getValue();
    }

    public String getCaption(int index) {
        return this.itemArray.get(index).getCaption();
    }

    public Iterator<PairItem> iterator() {
        return this.itemArray.iterator();
    }

    @Override
    public JSONObject toJSON() throws Throwable {
        JSONObject json = new JSONObject();
        if (this.itemArray != null && !this.itemArray.isEmpty()) {
            JSONArray jsonItems = new JSONArray();
            int size = this.itemArray.size();
            for (int i = 0; i < size; ++i) {
                PairItem item = this.itemArray.get(i);
                int type = BaseTypeUtil.getType(item.getValue());
                JSONObject jsonItem = new JSONObject();
                jsonItem.put("value", item.getValue());
                jsonItem.put("caption", (Object)item.getCaption());
                jsonItem.put("type", type);
                jsonItems.put((Object)jsonItem);
            }
            json.put("items", (Object)jsonItems);
        }
        return json;
    }

    @Override
    public void fromJSON(JSONObject jsonObj) throws Throwable {
        JSONArray jsonItems = (JSONArray)jsonObj.opt("items");
        if (jsonItems != null) {
            this.itemArray = new ArrayList();
            int size = jsonItems.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonItem = jsonItems.getJSONObject(i);
                PairItem item = new PairItem();
                Object value = jsonItem.get("value");
                String caption = jsonItem.getString("caption");
                String typeString = jsonItem.optString("type");
                if (typeString != null && !typeString.isEmpty()) {
                    int type = Integer.parseInt(typeString);
                    value = TypeConvertor.toJavaType(type, value);
                }
                item.setValue(value);
                item.setCaption(caption);
                this.itemArray.add(item);
            }
        }
    }
}

