/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.struct;

import java.util.ArrayList;
import java.util.List;

public class CustomTreeItem<T> {
    private T data = null;
    private CustomTreeItem<T> parent = null;
    private ArrayList<CustomTreeItem<T>> children = null;

    public CustomTreeItem(T data) {
        this.data = data;
    }

    public T getData() {
        return this.data;
    }

    public void setParent(CustomTreeItem<T> parent) {
        this.parent = parent;
    }

    public CustomTreeItem<T> getParent() {
        return this.parent;
    }

    public void addChild(CustomTreeItem<T> item) {
        this.ensureChildren().add(item);
        item.setParent(this);
    }

    public ArrayList<CustomTreeItem<T>> getChildren() {
        return this.ensureChildren();
    }

    private ArrayList<CustomTreeItem<T>> ensureChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public int getLeafCount() {
        if (this.children == null) {
            return 1;
        }
        int total = 0;
        for (CustomTreeItem<T> item : this.children) {
            total += item.getLeafCount();
        }
        return total;
    }

    public List<CustomTreeItem<T>> getAllLeafs() {
        ArrayList<CustomTreeItem<T>> list = new ArrayList<CustomTreeItem<T>>();
        this.loadAllLeaf(list);
        return list;
    }

    private void loadAllLeaf(List<CustomTreeItem<T>> list) {
        if (this.children == null) {
            list.add(this);
            return;
        }
        for (CustomTreeItem<T> item : this.children) {
            super.loadAllLeaf(list);
        }
    }
}

