/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.rule;

import com.bokesoft.yes.common.i18n.StringTable;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.rule.IStringRule;
import com.bokesoft.yigo.common.rule.RegularRule;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PasswordRuleChecker {
    private static final String Node_RegularRule = "RegularRule";
    private static final String Node_InterfaceRule = "InterfaceRule";
    private static final String Node_LoginRule = "LoginRule";
    private static final String Attr_ErrorDes = "ErrorDes";
    private static final String Attr_Class = "Class";
    private static final String Attr_IsReserve = "IsReserve";
    private static final String I18N = "i18n";
    private List<IStringRule> ruleList = null;
    private List<IStringRule> loginRuleList = null;
    private static PasswordRuleChecker instance = null;

    private PasswordRuleChecker(String sRules) throws Throwable {
        this.init(sRules);
    }

    public static synchronized PasswordRuleChecker getInstance(String sRules, boolean forceUpdate) throws Throwable {
        if (instance == null || forceUpdate) {
            instance = new PasswordRuleChecker(sRules);
        }
        return instance;
    }

    private void init(String sRules) throws Throwable {
        if (StringUtil.isBlankOrNull(sRules)) {
            return;
        }
        this.ruleList = new Vector<IStringRule>();
        this.loginRuleList = new Vector<IStringRule>();
        Document doc = DomHelper.createDocument(sRules);
        this.load(doc);
    }

    public void check(String s, String locale, Object context) throws Throwable {
        if (this.ruleList == null) {
            return;
        }
        for (IStringRule checker : this.ruleList) {
            if (checker.check(s, context)) continue;
            throw new Throwable(checker.getErrorDesc(locale));
        }
    }

    public void checkLoginRule(String s, String locale, Object context) throws Throwable {
        if (this.loginRuleList == null) {
            return;
        }
        for (IStringRule checker : this.loginRuleList) {
            if (checker.check(s, context)) continue;
            throw new Throwable(checker.getErrorDesc(locale));
        }
    }

    public String getRuleDes(String locale) {
        if (this.ruleList == null) {
            return "";
        }
        int index = 1;
        StringBuilder sb = new StringBuilder();
        sb.append(StringTable.getString(null, "", "PassWordCheckRule"));
        sb.append("\n");
        for (IStringRule checker : this.ruleList) {
            sb.append(index).append(".").append(checker.getErrorDesc(locale)).append("\n");
            ++index;
        }
        return sb.toString();
    }

    private void load(Document doc) throws Throwable {
        Element root = doc.getDocumentElement();
        NodeList list = root.getChildNodes();
        for (int n = 0; n < list.getLength(); ++n) {
            Node node = list.item(n);
            if (!(node instanceof Element)) continue;
            Element elem = (Element)node;
            String tagName = elem.getTagName();
            if (Node_RegularRule.equalsIgnoreCase(tagName)) {
                this.addRegularRule(DomHelper.readCDATAContent(elem).intern(), elem.getAttribute(Attr_ErrorDes).intern(), elem.getAttribute(Attr_IsReserve).intern(), this.ruleList, elem);
                continue;
            }
            if (Node_InterfaceRule.equalsIgnoreCase(tagName)) {
                this.addInterfaceRule(elem.getAttribute(Attr_Class).intern(), this.ruleList);
                continue;
            }
            if (!Node_LoginRule.equalsIgnoreCase(tagName)) continue;
            if (!StringUtil.isBlankOrNull(elem.getAttribute(Attr_Class))) {
                this.addInterfaceRule(elem.getAttribute(Attr_Class).intern(), this.loginRuleList);
                continue;
            }
            this.addRegularRule(DomHelper.readCDATAContent(elem).intern(), elem.getAttribute(Attr_ErrorDes).intern(), elem.getAttribute(Attr_IsReserve).intern(), this.loginRuleList, elem);
        }
    }

    private void addRegularRule(String regularRule, String errorDes, String sReserve, List<IStringRule> list, Element rule) {
        RegularRule regular = new RegularRule(regularRule, errorDes, TypeConvertor.toBoolean(sReserve));
        Element i18n = DomHelper.getElement(rule, I18N);
        if (i18n != null) {
            NodeList nodes = i18n.getChildNodes();
            for (int n = 0; n < nodes.getLength(); ++n) {
                Element elem = (Element)nodes.item(n);
                regular.putString(elem.getTagName().intern(), elem.getTextContent().intern());
            }
        }
        list.add(regular);
    }

    private void addInterfaceRule(String InterfaceRule, List<IStringRule> list) throws Throwable {
        if (!StringUtil.isBlankOrNull(InterfaceRule)) {
            Class<?> providerClass = Class.forName(InterfaceRule);
            IStringRule checker = (IStringRule)providerClass.newInstance();
            list.add(checker);
        }
    }
}

