/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.i18n;

import com.bokesoft.yes.i18n.IStringMap;
import com.bokesoft.yes.i18n.StringTableReader;
import com.bokesoft.yigo.common.i18n.DefaultLocale;
import com.bokesoft.yigo.common.i18n.ILocale;
import java.util.HashMap;

public class LocaleStringTable {
    private static final String defaultDevLocal = "zh-CN";
    private Class<?> resClass = null;
    private HashMap<String, IStringMap> localeMap = null;

    public LocaleStringTable(Class<?> resClass) {
        this.resClass = resClass;
        this.localeMap = new HashMap();
    }

    public String getString(ILocale locale, String group, String key) {
        IStringMap map;
        if (locale == null) {
            locale = DefaultLocale.getDefaultLocale();
        }
        String text = null;
        String lang = locale.getLocale();
        if (lang == null || lang.isEmpty()) {
            lang = defaultDevLocal;
        }
        if ((map = this.localeMap.get(lang)) == null) {
            map = StringTableReader.load(this.resClass, lang + "-strings.xml");
            this.localeMap.put(lang, map);
        }
        if ((text = map.getString(group, key)) == null) {
            map = this.localeMap.get(defaultDevLocal);
            if (map == null) {
                map = StringTableReader.load(this.resClass, "zh-CN-strings.xml");
                this.localeMap.put(defaultDevLocal, map);
            }
            text = map.getString(group, key);
        }
        return text;
    }
}

