/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.i18n;

import com.bokesoft.yigo.common.i18n.ILocale;
import java.util.Locale;

public class DefaultLocale
implements ILocale {
    private String lang;
    private String country;
    private String locale;
    private static ILocale defaultLocale = null;

    public DefaultLocale() {
        Locale l = Locale.getDefault();
        this.lang = l.getLanguage();
        this.country = l.getCountry();
        this.locale = this.lang + "-" + this.country;
    }

    public DefaultLocale(String lang, String country) {
        this.lang = lang;
        this.country = country;
        this.locale = lang + "-" + country;
        Locale.setDefault(new Locale(lang, country));
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    public static void setDefaultLocale(ILocale locale) {
        defaultLocale = locale;
    }

    public static ILocale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = new DefaultLocale();
        }
        return defaultLocale;
    }
}

