/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.dom;

import com.bokesoft.yigo.common.dom.IDomSAXReaderListener;
import com.bokesoft.yigo.common.dom.StopSAXException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DomSAXReader
extends DefaultHandler {
    private IDomSAXReaderListener listener = null;
    private String resource = null;
    private Object parent = null;

    private static SAXParserFactory getSAXParserFactory() {
        return SAXParserFactoryHolder.factory;
    }

    public DomSAXReader(Object parent, IDomSAXReaderListener listener) {
        this.parent = parent;
        this.listener = listener;
    }

    public void start(InputStream in, String resource) throws Exception {
        this.resource = resource;
        SAXParserFactory factory = DomSAXReader.getSAXParserFactory();
        SAXParser saxParser = factory.newSAXParser();
        try {
            saxParser.parse(in, (DefaultHandler)this);
        }
        catch (StopSAXException stopSAXException) {
            // empty catch block
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.listener.startElement(this.parent, this.resource, uri, localName, qName, attributes);
        if (this.listener.stopParse(true, qName)) {
            throw new StopSAXException();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.listener.endElement(uri, localName, qName);
        if (this.listener.stopParse(false, qName)) {
            throw new StopSAXException();
        }
    }

    private static class SAXParserFactoryHolder {
        private static final SAXParserFactory factory = SAXParserFactory.newInstance();

        private SAXParserFactoryHolder() {
        }
    }
}

