/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class DomHelper {
    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        return DocumentBuilderFactoryHolder.factory;
    }

    private static TransformerFactory getTransformerFactory() {
        return TransformerFactoryHolder.factory;
    }

    public static List<Element> getChildList(Element parent) {
        ArrayList<Element> nodeList = new ArrayList<Element>();
        NodeList childNodes = parent.getChildNodes();
        if (childNodes != null) {
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element)) continue;
                nodeList.add((Element)node);
            }
        }
        return nodeList;
    }

    public static List<Element> getChildList(Element parent, String tagName) {
        ArrayList<Element> nodeList = new ArrayList<Element>();
        NodeList childNodes = parent.getChildNodes();
        if (childNodes != null) {
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element) || !node.getNodeName().equalsIgnoreCase(tagName)) continue;
                nodeList.add((Element)node);
            }
        }
        return nodeList;
    }

    public static Element getElement(Element parent, String tagName) {
        Element result = null;
        NodeList childNodes = parent.getChildNodes();
        if (childNodes != null) {
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                Node node = childNodes.item(i);
                if (!(node instanceof Element) || !node.getNodeName().equalsIgnoreCase(tagName)) continue;
                result = (Element)node;
                break;
            }
        }
        return result;
    }

    public static int readAttr(Element element, String name, int defaultValue) {
        if (!element.hasAttribute(name)) {
            return defaultValue;
        }
        String textValue = element.getAttribute(name);
        if (textValue == null || textValue.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(textValue);
    }

    public static long readAttr(Element element, String name, long defaultValue) {
        if (!element.hasAttribute(name)) {
            return defaultValue;
        }
        String textValue = element.getAttribute(name);
        if (textValue == null || textValue.length() == 0) {
            return defaultValue;
        }
        return Long.parseLong(textValue);
    }

    public static String readAttr(Element element, String name, String defaultValue) {
        if (!element.hasAttribute(name)) {
            return defaultValue;
        }
        return element.getAttribute(name).intern();
    }

    public static String readAttr(Attributes attributes, String name, String defaultValue) {
        String value = null;
        String txtValue = attributes.getValue(name).intern();
        value = txtValue == null || txtValue.length() == 0 ? defaultValue : txtValue;
        return value;
    }

    public static int readAttr(Attributes attributes, String name, int defaultValue) {
        int value = -1;
        String textValue = attributes.getValue(name);
        value = textValue == null || textValue.length() == 0 ? defaultValue : Integer.parseInt(textValue);
        return value;
    }

    public static boolean readAttr(Element element, String name, boolean defaultValue) {
        if (!element.hasAttribute(name)) {
            return defaultValue;
        }
        String textValue = element.getAttribute(name);
        if (textValue == null || textValue.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(textValue);
    }

    public static Boolean readBool(Element element, String name, Boolean defaultValue) {
        if (!element.hasAttribute(name)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(element.getAttribute(name));
    }

    public static Integer readInt(Element element, String name, Integer defaultValue) {
        if (!element.hasAttribute(name)) {
            return defaultValue;
        }
        String textValue = element.getAttribute(name);
        if (textValue == null || textValue.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(textValue);
    }

    public static void writeAttr(Element element, String name, String value, String defaultValue) {
        boolean same = false;
        if (defaultValue == null) {
            if (value == null) {
                same = true;
            }
        } else if (defaultValue.equalsIgnoreCase(value)) {
            same = true;
        }
        if (!same) {
            element.setAttribute(name, value);
        } else {
            element.removeAttribute(name);
        }
    }

    public static void writeAttr(Element element, String name, int value, int defaultValue) {
        if (value != defaultValue) {
            String textValue = Integer.toString(value);
            element.setAttribute(name, textValue);
        } else {
            element.removeAttribute(name);
        }
    }

    public static void writeAttrCaseSensitive(Element element, String name, String value, String defaultValue) {
        boolean same = false;
        if (defaultValue == null) {
            if (value == null) {
                same = true;
            }
        } else if (defaultValue.equals(value)) {
            same = true;
        }
        if (!same) {
            element.setAttribute(name, value);
        } else {
            element.removeAttribute(name);
        }
    }

    public static void removeAttr(Element element, String name) {
        element.removeAttribute(name);
    }

    public static boolean readAttr(Attributes attributes, String name, boolean defaultValue) {
        boolean value = false;
        String textValue = attributes.getValue(name);
        value = textValue == null || textValue.length() == 0 ? defaultValue : Boolean.parseBoolean(textValue);
        return value;
    }

    public static void writeAttr(Element element, String name, Boolean value, Boolean defaultValue) {
        if (value == null) {
            element.removeAttribute(name);
        } else if (defaultValue == value) {
            element.removeAttribute(name);
        } else {
            element.setAttribute(name, Boolean.toString(value));
        }
    }

    public static String readCDATAContent(Element element) {
        NodeList childList = element.getChildNodes();
        int len = childList.getLength();
        if (len == 0) {
            return element.getTextContent().intern();
        }
        Node tempNode = null;
        for (int i = 0; i < len; ++i) {
            tempNode = childList.item(i);
            if (4 != tempNode.getNodeType()) continue;
            return tempNode.getNodeValue().intern();
        }
        return element.getTextContent().intern();
    }

    public static String readCDATAContent(Element element, String defaultValue) {
        NodeList childList = element.getChildNodes();
        int len = childList.getLength();
        if (len == 0) {
            return defaultValue;
        }
        Node tempNode = null;
        for (int i = 0; i < len; ++i) {
            tempNode = childList.item(i);
            if (4 != tempNode.getNodeType()) continue;
            return tempNode.getNodeValue().intern();
        }
        return defaultValue;
    }

    public static void writeCDATAContent(Document doc, Element element, String content) {
        CDATASection data = doc.createCDATASection(content);
        element.appendChild(data);
    }

    public static Document createDocument() throws Exception {
        Document document = null;
        DocumentBuilderFactory factory = DomHelper.getDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.newDocument();
        return document;
    }

    public static Document createDocument(InputStream in) throws Exception {
        Document document = null;
        DocumentBuilderFactory factory = DomHelper.getDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        document = builder.parse(in);
        return document;
    }

    public static void writeDocument(Document document, OutputStream out) throws Exception {
        OutputStreamWriter outwriter = new OutputStreamWriter(out, "utf-8");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outwriter);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("encoding", "utf-8");
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        xformer.transform(source, result);
    }

    public static byte[] toBytes(Document document) throws Exception {
        byte[] bytes = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DomHelper.writeDocument(document, out);
        bytes = out.toByteArray();
        out.close();
        return bytes;
    }

    public static String toString(Document document) throws Exception {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(writer);
        Transformer xformer = DomHelper.getTransformerFactory().newTransformer();
        xformer.setOutputProperty("encoding", "UTF-8");
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        xformer.transform(source, result);
        String xmlString = writer.toString();
        writer.close();
        return xmlString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document createDocument(String xml) throws Exception {
        Document document = null;
        DocumentBuilderFactory factory = DomHelper.getDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        byte[] data = xml.getBytes("utf-8");
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            document = builder.parse(in);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocumentFromFile(String filePath) throws Exception {
        File f = new File(filePath);
        if (!f.exists()) {
            return null;
        }
        Document doc = null;
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(f);
            if (inputStream != null) {
                doc = DomHelper.createDocument(inputStream);
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocumentToFile(Document document, String path) throws Exception {
        byte[] bytes = DomHelper.toBytes(document);
        try (FileOutputStream out = null;){
            out = new FileOutputStream(path);
            out.write(bytes);
        }
    }

    public static String readXml(String filePath) throws Exception {
        Document doc = DomHelper.readDocumentFromFile(filePath);
        return DomHelper.toString(doc);
    }

    public static String toString(Node n) {
        String name = n.getNodeName();
        short type = n.getNodeType();
        if (4 == type) {
            return "<![CDATA[" + n.getNodeValue() + "]]>";
        }
        if (name.startsWith("#")) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(name);
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                sb.append(' ').append(attr.getNodeName()).append("=\"").append(attr.getNodeValue()).append("\"");
            }
        }
        String textContent = null;
        NodeList children = n.getChildNodes();
        if (children.getLength() == 0) {
            textContent = n.getTextContent();
            if (textContent != null && !"".equals(textContent)) {
                sb.append(textContent).append("</").append(name).append('>');
            } else {
                sb.append("/>");
            }
        } else {
            sb.append('>');
            boolean hasValidChildren = false;
            for (int i = 0; i < children.getLength(); ++i) {
                String childToString = DomHelper.toString(children.item(i));
                if ("".equals(childToString)) continue;
                sb.append(childToString);
                hasValidChildren = true;
            }
            if (!hasValidChildren && (textContent = n.getTextContent()) != null) {
                sb.append(textContent);
            }
            sb.append("</").append(name).append('>');
        }
        return sb.toString();
    }

    private static class TransformerFactoryHolder {
        private static final TransformerFactory factory = TransformerFactory.newInstance();

        private TransformerFactoryHolder() {
        }
    }

    private static class DocumentBuilderFactoryHolder {
        private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

        private DocumentBuilderFactoryHolder() {
        }
    }
}

