/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.def;

public class PlatformType {
    public static final int PC = 1;
    public static final String STR_PC = "PC";
    public static final int Android = 2;
    public static final String STR_Android = "Android";
    public static final int IOS = 4;
    public static final String STR_IOS = "IOS";
    public static final int H5 = 8;
    public static final String STR_H5 = "H5";
    public static final int Mobile = 6;
    public static final String STR_Mobile = "Mobile";
    public static final int All = 15;
    public static final String STR_All = "All";

    public static int parseValue(String s) {
        int type = -1;
        if (STR_All.equalsIgnoreCase(s)) {
            type = 15;
        } else if (STR_Mobile.equalsIgnoreCase(s)) {
            type = 6;
        } else if (STR_PC.equalsIgnoreCase(s)) {
            type = 1;
        } else if (STR_Android.equalsIgnoreCase(s)) {
            type = 2;
        } else if (STR_IOS.equalsIgnoreCase(s)) {
            type = 4;
        } else if (STR_H5.equalsIgnoreCase(s)) {
            type = 8;
        }
        return type;
    }

    public String toValueString(int type) {
        String s = "";
        switch (type) {
            case 15: {
                s = STR_All;
                break;
            }
            case 6: {
                s = STR_Mobile;
                break;
            }
            case 1: {
                s = STR_PC;
                break;
            }
            case 2: {
                s = STR_Android;
                break;
            }
            case 4: {
                s = STR_IOS;
                break;
            }
            case 8: {
                s = STR_H5;
            }
        }
        return s;
    }

    public static int parse(String s) {
        if (s == null || s.isEmpty()) {
            return -1;
        }
        int type = 0;
        for (String t : s.split("\\|")) {
            type |= PlatformType.parseValue(t);
        }
        return type;
    }

    public static String toString(int type) {
        String s = "";
        if ((type & 0xF) == 15) {
            s = s + "|" + STR_All;
        } else {
            if ((type & 1) == 1) {
                s = s + "|" + STR_PC;
            }
            if ((type & 6) == 6) {
                s = s + "|" + STR_Mobile;
            } else {
                if ((type & 2) == 2) {
                    s = s + "|" + STR_Android;
                }
                if ((type & 4) == 4) {
                    s = s + "|" + STR_IOS;
                }
            }
            if ((type & 8) == 8) {
                s = s + "|" + STR_H5;
            }
        }
        if (!s.isEmpty()) {
            s = s.substring(1);
        }
        return s;
    }
}

