/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.def;

public class LocationType {
    public static final int TOP = 1;
    public static final String STR_TOP = "top";
    public static final int BOTTOM = 2;
    public static final String STR_BOTTOM = "bottom";
    public static final int LEFT = 4;
    public static final String STR_LEFT = "left";
    public static final int RIGHT = 8;
    public static final String STR_RIGHT = "right";
    public static final int CENTER = 16;
    public static final String STR_CENTER = "center";
    public static final String SEPARATOR = "|";

    public static int parse(String s) {
        int direction = 0;
        for (String locStr : s.split("\\|")) {
            if (STR_TOP.equalsIgnoreCase(locStr)) {
                direction |= 1;
                continue;
            }
            if (STR_BOTTOM.equalsIgnoreCase(locStr)) {
                direction |= 2;
                continue;
            }
            if (STR_LEFT.equalsIgnoreCase(locStr)) {
                direction |= 4;
                continue;
            }
            if (STR_RIGHT.equalsIgnoreCase(locStr)) {
                direction |= 8;
                continue;
            }
            if (!STR_CENTER.equalsIgnoreCase(locStr)) continue;
            direction |= 0x10;
        }
        return direction;
    }

    public static String toString(int direction) {
        StringBuilder s = new StringBuilder();
        if ((direction & 1) != 0) {
            s.append(SEPARATOR);
            s.append(STR_TOP);
        }
        if ((direction & 2) != 0) {
            s.append(SEPARATOR);
            s.append(STR_BOTTOM);
        }
        if ((direction & 4) != 0) {
            s.append(SEPARATOR);
            s.append(STR_LEFT);
        }
        if ((direction & 8) != 0) {
            s.append(SEPARATOR);
            s.append(STR_RIGHT);
        }
        if ((direction & 0x10) != 0) {
            s.append(SEPARATOR);
            s.append(STR_CENTER);
        }
        if (s.length() > 0) {
            s.deleteCharAt(0);
        }
        return s.toString();
    }
}

