/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.common.def;

import java.io.Serializable;

public class DefSize
implements Serializable {
    public static final int Fix = 0;
    public static final String STR_Fix = "px";
    public static final int Ratio = 1;
    public static final String STR_Ratio = "%";
    public static final int Pref = 2;
    public static final String STR_Pref = "pref";
    public static final int Unit = 3;
    public static final String STR_Unit = "unit";
    public static final int Inherit = 4;
    public static final String STR_Inherit = "inherit";
    public static final int Dp = 5;
    public static final String STR_Dp = "dp";
    public static final int Auto = 6;
    public static final String STR_Auto = "auto";
    private int sizeType = -1;
    private int size = 0;
    private boolean visible = true;

    public DefSize(int sizeType, int size) {
        this.sizeType = sizeType;
        this.size = size;
    }

    public int getSizeType() {
        return this.sizeType;
    }

    public int getSize() {
        return this.size;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public static final DefSize parse(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        int sizeType = -1;
        int size = 0;
        if (STR_Pref.equalsIgnoreCase(s)) {
            sizeType = 2;
        } else if (STR_Inherit.equalsIgnoreCase(s)) {
            sizeType = 4;
        } else if (STR_Auto.equalsIgnoreCase(s)) {
            sizeType = 6;
        } else {
            int index = s.lastIndexOf(STR_Fix);
            if (index > 0) {
                sizeType = 0;
            } else {
                index = s.lastIndexOf(STR_Unit);
                if (index > 0) {
                    sizeType = 3;
                } else {
                    index = s.lastIndexOf(STR_Ratio);
                    if (index > 0) {
                        sizeType = 1;
                    } else {
                        index = s.lastIndexOf(STR_Dp);
                        sizeType = 5;
                    }
                }
            }
            size = Integer.parseInt(s.substring(0, index));
        }
        return new DefSize(sizeType, size);
    }

    public String toString() {
        String s = "";
        switch (this.sizeType) {
            case 2: {
                s = STR_Pref;
                break;
            }
            case 4: {
                s = STR_Inherit;
                break;
            }
            case 0: {
                s = this.size + STR_Fix;
                break;
            }
            case 3: {
                s = this.size + STR_Unit;
                break;
            }
            case 1: {
                s = this.size + STR_Ratio;
                break;
            }
            case 5: {
                s = this.size + STR_Dp;
                break;
            }
            case 6: {
                s = STR_Auto;
            }
        }
        return s;
    }

    public static final String toString(DefSize size) {
        return size == null ? "" : size.toString();
    }

    public DefSize clone() {
        DefSize d = new DefSize(this.sizeType, this.size);
        return d;
    }

    public double toFixSize() {
        double fixSize = 0.0;
        switch (this.sizeType) {
            case 0: {
                fixSize = this.size;
            }
        }
        return fixSize;
    }
}

