/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.i18n;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.i18n.IStringMap;
import com.bokesoft.yes.i18n.StringSection;
import com.bokesoft.yigo.common.dom.DomHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlStringMapImpl
implements IStringMap,
Serializable {
    public static final String TAG_NAME = "StringTable";
    private HashMap<String, StringSection> tableMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(InputStream in) {
        try {
            Document document = DomHelper.createDocument(in);
            Element rootElement = document.getDocumentElement();
            NodeList childNodes = rootElement.getChildNodes();
            int size = childNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                Element childElement = (Element)childNode;
                StringSection table = this.tableMap.get(childElement.getTagName());
                if (table == null) {
                    table = new StringSection();
                    this.tableMap.put(childElement.getTagName(), table);
                }
                NodeList sectionChildNodes = childElement.getChildNodes();
                int s_size = sectionChildNodes.getLength();
                for (int j = 0; j < s_size; ++j) {
                    Node sectionChildNode = sectionChildNodes.item(j);
                    if (!(sectionChildNode instanceof Element)) continue;
                    Element sectionChildElement = (Element)sectionChildNode;
                    NodeList childSectionChildNodes = sectionChildElement.getChildNodes();
                    String key = null;
                    String value = null;
                    String name = sectionChildElement.getTagName();
                    if (childSectionChildNodes.getLength() == 7) {
                        int child_size = childSectionChildNodes.getLength();
                        for (int k = 0; k < child_size; ++k) {
                            Element childSectionChildElement;
                            String content;
                            Node childSectionChildNode = childSectionChildNodes.item(k);
                            if (childSectionChildNode instanceof Element && !StringUtil.isBlankOrNull(content = (childSectionChildElement = (Element)childSectionChildNode).getTextContent())) {
                                if ("Key".equals(childSectionChildElement.getTagName())) {
                                    key = content;
                                }
                                if ("Value".equals(childSectionChildElement.getTagName())) {
                                    value = content;
                                }
                            }
                            if (key == null || value == null) continue;
                            table.putString((name + key).intern(), value);
                        }
                        continue;
                    }
                    String content = sectionChildElement.getTextContent();
                    if (StringUtil.isBlankOrNull(content)) continue;
                    if ("Strings".equals(childElement.getTagName())) {
                        table.putString(name + sectionChildElement.getAttributes().getNamedItem("Key").getNodeValue(), content.trim());
                        continue;
                    }
                    table.putString(name.intern(), content.trim());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getString(String section, String key) {
        StringSection tmp = this.tableMap.get(section);
        return tmp == null ? null : tmp.getString(key);
    }

    @Override
    public StringSection getSection(String section) {
        return this.tableMap.get(section);
    }

    @Override
    public void putSection(String key, StringSection section) {
        this.tableMap.put(key, section);
    }

    @Override
    public void removeSection(String section) {
        this.tableMap.remove(section);
    }

    @Override
    public int size() {
        return this.tableMap.size();
    }

    @Override
    public HashMap<String, StringSection> getTableMap() {
        return this.tableMap;
    }

    public Document save() {
        Document document = null;
        try {
            document = DomHelper.createDocument();
            Element rootElement = document.createElement(TAG_NAME);
            Set<Map.Entry<String, StringSection>> set = this.tableMap.entrySet();
            Iterator<Map.Entry<String, StringSection>> it = set.iterator();
            Map.Entry<String, StringSection> entry = null;
            while (it.hasNext()) {
                entry = it.next();
                String key = entry.getKey();
                StringSection section = entry.getValue();
                Element sectionElement = document.createElement(key);
                Set<Map.Entry<String, String>> set1 = section.getStringMap().entrySet();
                Iterator<Map.Entry<String, String>> it1 = set1.iterator();
                Map.Entry<String, String> entry1 = null;
                while (it1.hasNext()) {
                    entry1 = it1.next();
                    String key1 = entry1.getKey();
                    String value = entry1.getValue();
                    Element child = document.createElement(key1);
                    child.appendChild(document.createTextNode(value));
                    sectionElement.appendChild(child);
                }
                rootElement.appendChild(sectionElement);
            }
            document.appendChild(rootElement);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    @Override
    public JSONObject toJSON() throws Throwable {
        Iterator<String> sectionIt = this.tableMap.keySet().iterator();
        JSONObject o = new JSONObject();
        while (sectionIt.hasNext()) {
            String sectionKey = sectionIt.next();
            JSONArray array = new JSONArray();
            StringSection section = this.tableMap.get(sectionKey);
            for (String key : section.getStringMap().keySet()) {
                String value = section.getString(key);
                JSONObject obj = new JSONObject();
                obj.put(key, (Object)value);
                array.put((Object)obj);
            }
            o.put(sectionKey, (Object)array);
        }
        return o;
    }

    @Override
    public void fromJSON(JSONObject o) throws Throwable {
        Iterator keys = o.keys();
        while (keys.hasNext()) {
            String sectionKey = (String)keys.next();
            JSONArray array = o.optJSONArray(sectionKey);
            StringSection section = new StringSection();
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                JSONObject obj = array.optJSONObject(i);
                String key = (String)obj.keySet().iterator().next();
                String value = obj.optString(key);
                section.putString(key, value);
            }
            this.tableMap.put(sectionKey, section);
        }
    }
}

