/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.util;

import com.bokesoft.yes.common.util.GenericTypeValidator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;

public class StringUtil {
    public static final String EMPTY_STRING = "";
    public static final String OneBlank_STRING = "  ";

    public static String replaceAll(String template, String placeholder, String replacement) {
        if (template == null) {
            return EMPTY_STRING;
        }
        int loc = template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        return new StringBuffer(template.substring(0, loc)).append(replacement).append(StringUtil.replaceAll(template.substring(loc + placeholder.length()), placeholder, replacement)).toString();
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof BigDecimal || obj instanceof Integer || obj instanceof Double || obj instanceof Long) {
            return true;
        }
        return StringUtil.isNum(obj.toString());
    }

    public static boolean isNum(String obj) {
        if (obj == null || obj.isEmpty()) {
            return false;
        }
        char[] cs = obj.toCharArray();
        boolean b = StringUtil.isNum(cs, obj.length());
        return b;
    }

    static boolean isNum(char[] in, int len) {
        int offset = 0;
        if (in[offset] == '-') {
            ++offset;
            --len;
        } else if (in[offset] == '+') {
            ++offset;
            --len;
        }
        boolean dot = false;
        while (len > 0) {
            char c = in[offset];
            if (c == '.') {
                if (dot) {
                    return false;
                }
                dot = true;
            } else if (!Character.isDigit(c)) {
                return false;
            }
            ++offset;
            --len;
        }
        return true;
    }

    public static void main(String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("123");
        list.add("-123");
        list.add("+123");
        list.add("123a");
        list.add("123.");
        list.add(".123.");
        list.add(".12");
        list.add("12.3.123123");
        list.add("123.123123123123123123");
        for (String s : list) {
            System.out.print(s);
            System.out.print("\t" + StringUtil.isNum(s));
            try {
                new BigDecimal(s);
                System.out.println("\ttrue");
            }
            catch (Throwable e) {
                System.out.println("\tfalse");
            }
        }
    }

    public static String join(String seperator, String[] strings) {
        int length = strings.length;
        if (length == 0) {
            return EMPTY_STRING;
        }
        StringBuffer buf = new StringBuffer(length * strings[0].length()).append(strings[0]);
        for (int i = 1; i < length; ++i) {
            buf.append(seperator).append(strings[i]);
        }
        return buf.toString();
    }

    public static String join(String seperator, Iterator<?> objects) {
        if (objects == null) {
            return null;
        }
        if (!objects.hasNext()) {
            return EMPTY_STRING;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(objects.next());
        while (objects.hasNext()) {
            buf.append(seperator).append(objects.next());
        }
        return buf.toString();
    }

    public static String join(Object[] arrO, String str) {
        String sReturn = EMPTY_STRING;
        if (arrO == null) {
            return null;
        }
        for (Object s : arrO) {
            sReturn = sReturn + s.toString() + str;
        }
        if (sReturn.length() != 0) {
            sReturn = sReturn.substring(0, sReturn.length() - str.length());
        }
        return sReturn;
    }

    public static String join(int[] ints, String str) {
        String sReturn = EMPTY_STRING;
        for (int i : ints) {
            sReturn = sReturn + i + str;
        }
        if (sReturn.length() != 0) {
            sReturn = sReturn.substring(0, sReturn.length() - str.length());
        }
        return sReturn;
    }

    public static String[] split(String list, String seperators) {
        return StringUtil.split(list, seperators, false);
    }

    public static String[] split(String list, String seperators, boolean include) {
        list = list == null ? EMPTY_STRING : list;
        StringTokenizer tokens = new StringTokenizer(list, seperators, include);
        String[] result = new String[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            result[i++] = tokens.nextToken();
        }
        return result;
    }

    public static boolean isDate(Object obj) {
        if (obj == null) {
            return false;
        }
        return StringUtil.isDate(obj.toString());
    }

    static boolean isDate(String str) {
        Date result = GenericTypeValidator.formatDate(str, null);
        return result != null;
    }

    public static boolean isBlankOrNull(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        return OneBlank_STRING.equals(str);
    }

    public static boolean isBlankOrNull(Object o) {
        if (o == null || o.toString().length() == 0) {
            return true;
        }
        return OneBlank_STRING.equals(o.toString());
    }

    public static boolean isBlankOrStrNull(Object o) {
        String str = String.valueOf(o);
        if (str == null || str.length() == 0 || str.equalsIgnoreCase("null")) {
            return true;
        }
        return OneBlank_STRING.equals(str);
    }

    public static boolean isBlankOrStrNull(String str) {
        if (str == null || str.length() == 0 || str.equalsIgnoreCase("null")) {
            return true;
        }
        return OneBlank_STRING.equals(str);
    }

    public static boolean instr(String s, String find, String seperator) {
        return (seperator + s + seperator).toUpperCase().indexOf((seperator + find + seperator).toUpperCase()) >= 0;
    }

    public static String mid(String str, int i, int len) {
        if (str == null) {
            return null;
        }
        if (i + len > str.length()) {
            return str.substring(i, str.length());
        }
        return str.substring(i, i + len);
    }

    public static String mid(String str, int i) {
        return StringUtil.mid(str, i, str.length());
    }

    public static String left(String str, int i) {
        String string = str = str == null ? EMPTY_STRING : str;
        if (i > str.length()) {
            i = str.length();
        }
        return str.substring(0, i);
    }

    public static String right(String str, int i) {
        String string = str = str == null ? EMPTY_STRING : str;
        if (i > str.length()) {
            i = str.length();
        }
        return str.substring(str.length() - i);
    }

    public static String strcat(Object ... args) {
        StringBuffer sb = new StringBuffer();
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static boolean isEmptyStr(String str) {
        if (str == null) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (StringUtil.isBlank(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean isString(String source, String str, int bg) {
        if (source == null || str == null || source.length() - bg < str.length()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (source.charAt(bg + i) == str.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

