/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class NumericUtil {
    private static String[] chineseDigits = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static String UNIT = "\u5706";

    public static String getAmountInWords(BigDecimal amount) {
        return NumericUtil.getAmountInWords(amount, UNIT);
    }

    public static String getAmountInWords(BigDecimal amount, String unit) {
        if (amount.abs().compareTo(new BigDecimal(1.0E15)) > 0) {
            throw new RuntimeException("\u53c2\u6570\u503c\u8d85\u51fa\u5141\u8bb8\u8303\u56f4 (-999999999999999.99 \uff5e 999999999999999.99)\uff01");
        }
        if (unit == "") {
            unit = UNIT;
        }
        boolean negative = false;
        if (amount.signum() < 0) {
            negative = true;
            amount = amount.negate();
        }
        long temp = amount.movePointRight(2).setScale(0, 4).longValue();
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        temp /= 10L;
        int[] parts = new int[20];
        int numParts = 0;
        int i = 0;
        while (temp != 0L) {
            int part;
            parts[i] = part = (int)(temp % 10000L);
            ++numParts;
            temp /= 10000L;
            ++i;
        }
        boolean beforeWanIsZero = true;
        String chineseStr = "";
        for (int i2 = 0; i2 < numParts; ++i2) {
            String partChinese = NumericUtil.partTranslate(parts[i2]);
            if (i2 % 2 == 0) {
                beforeWanIsZero = "".equals(partChinese);
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    chineseStr = parts[i2 - 1] == 0 || parts[i2 - 1] >= 1000 ? "\u4ebf" + chineseStr : "\u4ebf\u96f6" + chineseStr;
                } else if ("".equals(partChinese) && !beforeWanIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                } else {
                    if (parts[i2 - 1] > 0 && parts[i2 - 1] < 1000) {
                        chineseStr = "\u96f6" + chineseStr;
                    } else if (parts[i2 - 1] < 1000 && parts[i2 - 1] != 0) {
                        chineseStr = "\u96f6" + chineseStr;
                    }
                    if (!"".equals(partChinese)) {
                        chineseStr = "\u4e07" + chineseStr;
                    }
                }
            }
            chineseStr = partChinese + chineseStr;
        }
        chineseStr = chineseStr.length() > 0 ? chineseStr + unit : chineseStr + "\u96f6" + unit;
        chineseStr = numFen == 0 && numJiao == 0 ? chineseStr + "\u6574" : (numFen == 0 ? chineseStr + chineseDigits[numJiao] + "\u89d2" : (numJiao == 0 ? chineseStr + "\u96f6" + chineseDigits[numFen] + "\u5206" : chineseStr + chineseDigits[numJiao] + "\u89d2" + chineseDigits[numFen] + "\u5206"));
        if (negative) {
            chineseStr = "\u8d1f" + chineseStr;
        }
        return chineseStr;
    }

    private static String partTranslate(int amountPart) {
        if (amountPart < 0 || amountPart > 10000) {
            throw new IllegalArgumentException("\u53c2\u6570\u5fc5\u987b\u662f\u5927\u4e8e\u7b49\u4e8e 0\uff0c\u5c0f\u4e8e 10000 \u7684\u6574\u6570\uff01");
        }
        String[] units = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
        int temp = amountPart;
        String amountStr = new Integer(amountPart).toString();
        int amountStrLength = amountStr.length();
        boolean lastIsZero = true;
        String chineseStr = "";
        for (int i = 0; i < amountStrLength && temp != 0; temp /= 10, ++i) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr = "\u96f6" + chineseStr;
                }
                lastIsZero = true;
                continue;
            }
            chineseStr = chineseDigits[digit] + units[i] + chineseStr;
            lastIsZero = false;
        }
        return chineseStr;
    }

    public static RoundingMode roundMode(int roundMode) {
        switch (roundMode) {
            case 4: {
                return RoundingMode.HALF_UP;
            }
            case 0: {
                return RoundingMode.UP;
            }
            case 1: {
                return RoundingMode.DOWN;
            }
            case 2: {
                return RoundingMode.CEILING;
            }
            case 3: {
                return RoundingMode.FLOOR;
            }
        }
        return RoundingMode.HALF_UP;
    }
}

