/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.util;

import com.bokesoft.yes.common.util.DateUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class GenericTypeValidator
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static Byte formatByte(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Byte(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Byte formatByte(String value, Locale locale) {
        Byte result = null;
        if (value != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance(Locale.getDefault());
            formatter.setParseIntegerOnly(true);
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value.length() && num.doubleValue() >= -128.0 && num.doubleValue() <= 127.0) {
                result = new Byte(num.byteValue());
            }
        }
        return result;
    }

    public static Short formatShort(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Short(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Short formatShort(String value, Locale locale) {
        Short result = null;
        if (value != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance(Locale.getDefault());
            formatter.setParseIntegerOnly(true);
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value.length() && num.doubleValue() >= -32768.0 && num.doubleValue() <= 32767.0) {
                result = new Short(num.shortValue());
            }
        }
        return result;
    }

    public static Integer formatInt(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Double.valueOf(value).intValue();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer formatInt(String value, Locale locale) {
        Integer result = null;
        if (value != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance(Locale.getDefault());
            formatter.setParseIntegerOnly(true);
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value.length() && num.doubleValue() >= -2.147483648E9 && num.doubleValue() <= 2.147483647E9) {
                result = num.intValue();
            }
        }
        return result;
    }

    public static Long formatLong(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Long(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long formatLong(String value, Locale locale) {
        Long result = null;
        if (value != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance(Locale.getDefault());
            formatter.setParseIntegerOnly(true);
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value.length() && num.doubleValue() >= -9.223372036854776E18 && num.doubleValue() <= 9.223372036854776E18) {
                result = new Long(num.longValue());
            }
        }
        return result;
    }

    public static Float formatFloat(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new Float(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Float formatFloat(String value, Locale locale) {
        Float result = null;
        if (value != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance(Locale.getDefault());
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value.length() && num.doubleValue() >= -3.4028234663852886E38 && num.doubleValue() <= 3.4028234663852886E38) {
                result = new Float(num.floatValue());
            }
        }
        return result;
    }

    public static Double formatDouble(String value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String && ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value))) {
            return null;
        }
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double formatDouble(String value, Locale locale) {
        Double result = null;
        if (value != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance(Locale.getDefault());
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value.length() && num.doubleValue() >= -1.7976931348623157E308 && num.doubleValue() <= Double.MAX_VALUE) {
                result = new Double(num.doubleValue());
            }
        }
        return result;
    }

    public static Date formatDate(String value, Locale locale) {
        Date date = null;
        if (value == null) {
            return null;
        }
        try {
            DateFormat formatter = null;
            formatter = locale != null ? DateFormat.getDateInstance(3, locale) : DateFormat.getDateInstance(3, Locale.getDefault());
            formatter.setLenient(false);
            date = formatter.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Date formatDate(String value, String datePattern, boolean strict) {
        Date date = null;
        if (value == null || datePattern == null || datePattern.length() == 0) {
            return null;
        }
        try {
            SimpleDateFormat formatter = DateUtil.getDateFormat(datePattern);
            formatter.setLenient(false);
            date = formatter.parse(value);
            if (strict && datePattern.length() != value.length()) {
                date = null;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }
}

