/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.util;

import com.bokesoft.yes.common.util.DebugUtil;
import com.bokesoft.yes.common.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtil {
    private static long millisecondsPerDay = 86400000L;

    public static Integer FMonthToLMonth(Integer lFMonth) {
        return lFMonth / 100 * 12 + lFMonth % 100 - 1;
    }

    public static Integer LMonthToFMonth(int lLMonth) {
        return lLMonth / 12 * 100 + lLMonth % 12 + 1;
    }

    public static Integer[] getMonthBetween(Integer lMinMonth, Integer lMaxMonth) {
        Integer lLMinMonth = DateUtil.FMonthToLMonth(lMinMonth);
        Integer lLMaxMonth = DateUtil.FMonthToLMonth(lMaxMonth);
        Integer[] lTempArray = new Integer[lLMaxMonth - lLMinMonth + 1];
        for (int lLoop = lLMinMonth.intValue(); lLoop <= lLMaxMonth; ++lLoop) {
            lTempArray[lLoop - lLMinMonth.intValue()] = DateUtil.LMonthToFMonth(lLoop);
        }
        return lTempArray;
    }

    public static Date dateAdd(String interval, int number, Date date) {
        Calendar start = Calendar.getInstance();
        start.setTime(date);
        int field = 0;
        if (interval.equalsIgnoreCase("d") || interval.equalsIgnoreCase("dd")) {
            field = 5;
        } else if (interval.equalsIgnoreCase("s")) {
            field = 13;
        } else if (interval.equalsIgnoreCase("n")) {
            field = 12;
        } else if (interval.equalsIgnoreCase("h")) {
            field = 10;
        } else if (interval.equalsIgnoreCase("w")) {
            field = 7;
        } else if (interval.equalsIgnoreCase("ww")) {
            field = 3;
        } else if (interval.equalsIgnoreCase("y")) {
            field = 6;
        } else if (interval.equalsIgnoreCase("m") || interval.equalsIgnoreCase("mm")) {
            field = 2;
        } else if (interval.equalsIgnoreCase("yyyy")) {
            field = 1;
        } else if (interval.equalsIgnoreCase("q")) {
            field = 2;
            number *= 3;
        } else {
            DebugUtil.debug("dateAdd" + interval + "not impl");
        }
        start.add(field, number);
        return start.getTime();
    }

    public static Date dateAdd(Date date, int days) {
        Date result = date;
        long time = date.getTime();
        result.setTime(time += millisecondsPerDay * (long)days);
        return result;
    }

    private static Date getDateParse(String string, String format) throws Throwable {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (format == null || format.length() == 0) {
            format = string.length() < 17 ? "yyyy-MM-dd" : "yyyy-MM-dd HH:mm:ss";
        }
        if (string.endsWith("Z")) {
            string = StringUtil.replaceAll(string.substring(0, string.length() - 1), "T", " ");
            SimpleDateFormat simpleFormat = new SimpleDateFormat(format);
            simpleFormat.setLenient(false);
            Date d = simpleFormat.parse(string);
            return DateUtil.dateAdd(d, 1);
        }
        if (string.contains("CST")) {
            SimpleDateFormat simpleFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            return simpleFormat.parse(string);
        }
        SimpleDateFormat simpleFormat = new SimpleDateFormat(format);
        simpleFormat.setLenient(false);
        return simpleFormat.parse(string);
    }

    public static Date getDate(String string, String format) throws Throwable {
        return DateUtil.getDateParse(string, format);
    }

    public static String getDateFormatText(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date == null ? new Date() : date);
    }

    public static SimpleDateFormat getDateFormat(String format) {
        return new SimpleDateFormat(format);
    }

    public static Date getDate(Date d, int hour, int min, int sec) {
        return DateUtil.getDate(d, hour, min, sec, 0);
    }

    public static Date getDate(Date d, int hour, int min, int sec, int ms) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.set(11, hour);
        c.set(12, min);
        c.set(13, sec);
        c.set(14, ms);
        return c.getTime();
    }

    public static Date getDate(String value) throws Throwable {
        Date d = null;
        if (value == null || value.isEmpty()) {
            return d;
        }
        if (value.startsWith("'") && value.endsWith("'") && value.length() > 1) {
            value = value.substring(1, value.length() - 2);
        }
        if (value.length() == 10) {
            d = DateUtil.getDateParse(value, "yyyy-MM-dd");
        } else if (value.length() > 10) {
            if (value.length() < 17) {
                if (value.length() == 14) {
                    d = DateUtil.getDateParse(value, "yyyyMMddHHmmss");
                } else {
                    value = value.substring(0, 10);
                    d = DateUtil.getDateParse(value, "yyyy-MM-dd");
                }
            } else {
                d = value.indexOf(" ") == 3 ? DateUtil.getDateParse(value, "EEE MMM dd HH:mm:ss zzz yyyy") : DateUtil.getDateParse(value, "yyyy-MM-dd HH:mm:ss");
            }
        } else if (value.length() == 7 && value.lastIndexOf("-") == 4) {
            d = DateUtil.getDateParse(value, "yyyy-MM");
        } else if (value.length() == 8) {
            d = DateUtil.getDateParse(value, "yyyyMMdd");
        } else if (value.length() == 6) {
            d = DateUtil.getDateParse(value, "yyyyMM");
        } else if (value.length() == 4) {
            d = DateUtil.getDateParse(value, "yyyy");
        }
        return d;
    }

    public static Date getFirstDateInMonth(int year, int month) {
        Calendar cale = Calendar.getInstance();
        cale.clear();
        cale.set(1, year);
        cale.set(2, month - 1);
        cale.set(5, cale.getActualMinimum(5));
        return cale.getTime();
    }

    public static Date getFirstDateInYear(int year) {
        Calendar cale = Calendar.getInstance();
        cale.clear();
        cale.set(1, year);
        cale.set(2, 0);
        cale.set(5, cale.getActualMinimum(5));
        return cale.getTime();
    }

    public static Date getLastDateInMonth(int year, int month) {
        Calendar cale = Calendar.getInstance();
        cale.clear();
        cale.set(1, year);
        cale.set(2, month - 1);
        cale.set(5, cale.getActualMaximum(5));
        return cale.getTime();
    }

    public static int getWeekDay(Date date) throws Throwable {
        Calendar cale = Calendar.getInstance();
        cale.setTime(date);
        int weekDay = cale.get(7);
        return weekDay;
    }
}

