/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.util;

import com.bokesoft.yes.common.util.DBTypeUtil;
import java.math.BigDecimal;

public class DataCalculateUtil {
    public static Object subtract(Object a, int aDataType, Object b, int bDataType) {
        BigDecimal da = DataCalculateUtil.parseBigDecimal(a, aDataType);
        BigDecimal db = DataCalculateUtil.parseBigDecimal(b, bDataType);
        da = da.subtract(db);
        return DataCalculateUtil.parseObject(da, aDataType);
    }

    public static Object add(Object a, int aDataType, Object b, int bDataType) {
        BigDecimal da = DataCalculateUtil.parseBigDecimal(a, aDataType);
        BigDecimal db = DataCalculateUtil.parseBigDecimal(b, bDataType);
        da = da.add(db);
        return DataCalculateUtil.parseObject(da, aDataType);
    }

    public static int compareTo(Object a, int aDataType, Object b, int bDataType) {
        BigDecimal da = DataCalculateUtil.parseBigDecimal(a, aDataType);
        BigDecimal db = DataCalculateUtil.parseBigDecimal(b, bDataType);
        return da.compareTo(db);
    }

    public static int compareTo(BigDecimal da, Object b, int bDataType) {
        BigDecimal db = DataCalculateUtil.parseBigDecimal(b, bDataType);
        return da.compareTo(db);
    }

    public static int compareToZero(Object a, int aDataType) {
        BigDecimal da = DataCalculateUtil.parseBigDecimal(a, aDataType);
        return da.compareTo(BigDecimal.ZERO);
    }

    public static boolean equalsValue(Object a, int aDataType, Object b, int bDataType) {
        BigDecimal da = DataCalculateUtil.parseBigDecimal(a, aDataType);
        BigDecimal db = DataCalculateUtil.parseBigDecimal(b, bDataType);
        return da.equals(db);
    }

    private static BigDecimal parseBigDecimal(Object value, int dataType) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        int javaDataType = DBTypeUtil.dataType2JavaDataType(dataType);
        switch (javaDataType) {
            case 1: {
                return new BigDecimal((Integer)value);
            }
            case 4: {
                return (BigDecimal)value;
            }
            case 7: {
                return new BigDecimal((Long)value);
            }
        }
        return null;
    }

    private static Object parseObject(BigDecimal value, int dataType) {
        int javaDataType = DBTypeUtil.dataType2JavaDataType(dataType);
        switch (javaDataType) {
            case 1: {
                return value.intValue();
            }
            case 4: {
                return value;
            }
            case 7: {
                return value.longValue();
            }
        }
        return null;
    }
}

