/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.util;

import com.bokesoft.yes.common.util.Base64Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.Cipher;

public class CertificateUtils {
    public static final String KEY_STORE = "JKS";
    public static final String X509 = "X.509";
    private static final int CACHE_SIZE = 2048;
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static PrivateKey getPrivateKey(String keyStorePath, String alias, String password) throws Exception {
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        return privateKey;
    }

    public static KeyStore getKeyStore(String keyStorePath, String password) throws Exception {
        FileInputStream in = new FileInputStream(keyStorePath);
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE);
        keyStore.load(in, password.toCharArray());
        in.close();
        return keyStore;
    }

    private static PublicKey getPublicKey(String certificatePath) throws Exception {
        Certificate certificate = CertificateUtils.getCertificate(certificatePath);
        PublicKey publicKey = certificate.getPublicKey();
        return publicKey;
    }

    private static Certificate getCertificate(String certificatePath) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance(X509);
        FileInputStream in = new FileInputStream(certificatePath);
        Certificate certificate = certificateFactory.generateCertificate(in);
        in.close();
        return certificate;
    }

    private static Certificate getCertificate(String keyStorePath, String alias, String password) throws Exception {
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        Certificate certificate = keyStore.getCertificate(alias);
        return certificate;
    }

    public static byte[] encryptByPrivateKey(byte[] data, String keyStorePath, String alias, String password) throws Exception {
        PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStorePath, alias, password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] encryptFileByPrivateKey(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] data = CertificateUtils.fileToByte(filePath);
        return CertificateUtils.encryptByPrivateKey(data, keyStorePath, alias, password);
    }

    public static void encryptFileByPrivateKey(String srcFilePath, String destFilePath, String keyStorePath, String alias, String password) throws Exception {
        PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStorePath, alias, password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(1, privateKey);
        File srcFile = new File(srcFilePath);
        FileInputStream in = new FileInputStream(srcFile);
        File destFile = new File(destFilePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        destFile.createNewFile();
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] data = new byte[117];
        while (in.read(data) != -1) {
            byte[] encryptedData = cipher.doFinal(data);
            ((OutputStream)out).write(encryptedData, 0, encryptedData.length);
            out.flush();
        }
        ((OutputStream)out).close();
        in.close();
    }

    public static String encryptFileToBase64ByPrivateKey(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] encryptedData = CertificateUtils.encryptFileByPrivateKey(filePath, keyStorePath, alias, password);
        return Base64Utils.encode(encryptedData);
    }

    public static byte[] decryptByPrivateKey(byte[] encryptedData, String keyStorePath, String alias, String password) throws Exception {
        PrivateKey privateKey = CertificateUtils.getPrivateKey(keyStorePath, alias, password);
        Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
        cipher.init(2, privateKey);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static byte[] encryptByPublicKey(byte[] data, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateUtils.getPublicKey(certificatePath);
        byte[] encryptedData = CertificateUtils.encryptByPublicKey(data, publicKey);
        return encryptedData;
    }

    public static byte[] encryptByPublicKey(byte[] data, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(1, publicKey);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static byte[] encryptByPublicKey(byte[] data, byte[] filedata) throws Exception {
        CertificateFactory certFac = CertificateFactory.getInstance(X509);
        ByteArrayInputStream is = new ByteArrayInputStream(filedata);
        Certificate cert = certFac.generateCertificate(is);
        PublicKey publicKey = cert.getPublicKey();
        return CertificateUtils.encryptByPublicKey(data, publicKey);
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateUtils.getPublicKey(certificatePath);
        byte[] decryptedData = CertificateUtils.decryptByPublicKey(encryptedData, publicKey);
        return decryptedData;
    }

    public static byte[] decryptByPublicKey(byte[] encryptedData, byte[] filedata) throws Exception {
        CertificateFactory certFac = CertificateFactory.getInstance(X509);
        ByteArrayInputStream is = new ByteArrayInputStream(filedata);
        Certificate cert = certFac.generateCertificate(is);
        PublicKey publicKey = cert.getPublicKey();
        return CertificateUtils.decryptByPublicKey(encryptedData, publicKey);
    }

    private static byte[] decryptByPublicKey(byte[] encryptedData, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static void decryptFileByPublicKey(String srcFilePath, String destFilePath, String certificatePath) throws Exception {
        PublicKey publicKey = CertificateUtils.getPublicKey(certificatePath);
        Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
        cipher.init(2, publicKey);
        File srcFile = new File(srcFilePath);
        FileInputStream in = new FileInputStream(srcFile);
        File destFile = new File(destFilePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        destFile.createNewFile();
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] data = new byte[128];
        while (in.read(data) != -1) {
            byte[] decryptedData = cipher.doFinal(data);
            ((OutputStream)out).write(decryptedData, 0, decryptedData.length);
            out.flush();
        }
        ((OutputStream)out).close();
        in.close();
    }

    public static byte[] sign(byte[] data, String keyStorePath, String alias, String password) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(keyStorePath, alias, password);
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initSign(privateKey);
        signature.update(data);
        return signature.sign();
    }

    public static String signToBase64(byte[] data, String keyStorePath, String alias, String password) throws Exception {
        return Base64Utils.encode(CertificateUtils.sign(data, keyStorePath, alias, password));
    }

    public static String signFileToBase64WithEncrypt(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] encryptedData = CertificateUtils.encryptFileByPrivateKey(filePath, keyStorePath, alias, password);
        return CertificateUtils.signToBase64(encryptedData, keyStorePath, alias, password);
    }

    @Deprecated
    public static byte[] signFile(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] sign = new byte[]{};
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(keyStorePath, alias, password);
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initSign(privateKey);
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            FileChannel fileChannel = in.getChannel();
            MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            signature.update(byteBuffer);
            fileChannel.close();
            in.close();
            sign = signature.sign();
        }
        return sign;
    }

    public static byte[] generateFileSign(String filePath, String keyStorePath, String alias, String password) throws Exception {
        byte[] sign = new byte[]{};
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(keyStorePath, alias, password);
        KeyStore keyStore = CertificateUtils.getKeyStore(keyStorePath, password);
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, password.toCharArray());
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initSign(privateKey);
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            byte[] cache = new byte[2048];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                signature.update(cache, 0, nRead);
            }
            in.close();
            sign = signature.sign();
        }
        return sign;
    }

    public static String signFileToBase64(String filePath, String keyStorePath, String alias, String password) throws Exception {
        return Base64Utils.encode(CertificateUtils.generateFileSign(filePath, keyStorePath, alias, password));
    }

    public static boolean verifySign(byte[] data, String sign, String certificatePath) throws Exception {
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(certificatePath);
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(publicKey);
        signature.update(data);
        return signature.verify(Base64Utils.decode(sign));
    }

    @Deprecated
    public static boolean verifyFileSign(String filePath, String sign, String certificatePath) throws Exception {
        boolean result = false;
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(certificatePath);
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(publicKey);
        File file = new File(filePath);
        if (file.exists()) {
            byte[] decodedSign = Base64Utils.decode(sign);
            FileInputStream in = new FileInputStream(file);
            FileChannel fileChannel = in.getChannel();
            MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
            signature.update(byteBuffer);
            in.close();
            result = signature.verify(decodedSign);
        }
        return result;
    }

    public static boolean validateFileSign(String filePath, String sign, String certificatePath) throws Exception {
        boolean result = false;
        X509Certificate x509Certificate = (X509Certificate)CertificateUtils.getCertificate(certificatePath);
        PublicKey publicKey = x509Certificate.getPublicKey();
        Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
        signature.initVerify(publicKey);
        File file = new File(filePath);
        if (file.exists()) {
            byte[] decodedSign = Base64Utils.decode(sign);
            FileInputStream in = new FileInputStream(file);
            byte[] cache = new byte[2048];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                signature.update(cache, 0, nRead);
            }
            in.close();
            result = signature.verify(decodedSign);
        }
        return result;
    }

    public static boolean verifyBase64Sign(String base64String, String sign, String certificatePath) throws Exception {
        byte[] data = Base64Utils.decode(base64String);
        return CertificateUtils.verifySign(data, sign, certificatePath);
    }

    public static boolean verifyBase64SignWithDecrypt(String base64String, String sign, String certificatePath) throws Exception {
        byte[] encryptedData = Base64Utils.decode(base64String);
        byte[] data = CertificateUtils.decryptByPublicKey(encryptedData, certificatePath);
        return CertificateUtils.verifySign(data, sign, certificatePath);
    }

    public static boolean verifyFileSignWithDecrypt(String encryptedFilePath, String sign, String certificatePath) throws Exception {
        byte[] encryptedData = CertificateUtils.fileToByte(encryptedFilePath);
        byte[] data = CertificateUtils.decryptByPublicKey(encryptedData, certificatePath);
        return CertificateUtils.verifySign(data, sign, certificatePath);
    }

    public static boolean verifyCertificate(Certificate certificate) {
        return CertificateUtils.verifyCertificate(new Date(), certificate);
    }

    public static boolean verifyCertificate(Date date, Certificate certificate) {
        boolean isValid = true;
        try {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            x509Certificate.checkValidity(date);
        }
        catch (Exception e) {
            isValid = false;
        }
        return isValid;
    }

    public static boolean verifyCertificate(Date date, String certificatePath) {
        try {
            Certificate certificate = CertificateUtils.getCertificate(certificatePath);
            return CertificateUtils.verifyCertificate(certificate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean verifyCertificate(Date date, String keyStorePath, String alias, String password) {
        try {
            Certificate certificate = CertificateUtils.getCertificate(keyStorePath, alias, password);
            return CertificateUtils.verifyCertificate(certificate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean verifyCertificate(String keyStorePath, String alias, String password) {
        return CertificateUtils.verifyCertificate(new Date(), keyStorePath, alias, password);
    }

    public static boolean verifyCertificate(String certificatePath) {
        return CertificateUtils.verifyCertificate(new Date(), certificatePath);
    }

    public static byte[] fileToByte(String filePath) throws Exception {
        byte[] data = new byte[]{};
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            byte[] cache = new byte[2048];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                out.write(cache, 0, nRead);
                out.flush();
            }
            out.close();
            in.close();
            data = out.toByteArray();
        }
        return data;
    }

    public static void byteArrayToFile(byte[] bytes, String filePath) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        File destFile = new File(filePath);
        if (!destFile.getParentFile().exists()) {
            destFile.getParentFile().mkdirs();
        }
        destFile.createNewFile();
        FileOutputStream out = new FileOutputStream(destFile);
        byte[] cache = new byte[2048];
        int nRead = 0;
        while ((nRead = in.read(cache)) != -1) {
            ((OutputStream)out).write(cache, 0, nRead);
            out.flush();
        }
        ((OutputStream)out).close();
        ((InputStream)in).close();
    }

    public static void main(String[] args) {
        try {
            String source = "\u8fd9\u662f\u4e00\u884c\u7b7e\u540d\u7684\u6d4b\u8bd5\u6587\u5b57";
            byte[] data = source.getBytes();
            byte[] encodedData = CertificateUtils.encryptByPrivateKey(data, "D:\\usbkey\\chenbinbin.jks", "chenbinbin", "111111");
            byte[] bytes = CertificateUtils.fileToByte("D:\\usbkey\\cer\\chenbinbin.cer");
            byte[] decodedData = CertificateUtils.decryptByPublicKey(encodedData, bytes);
            String target = new String(decodedData);
            System.out.println("\u52a0\u5bc6\u524d: \r\n" + source + "\r\n\u89e3\u5bc6\u540e: \r\n" + target);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

