/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.util;

public class Base64 {
    private static final byte[] DECODE_TABLE;
    private static final byte[] ENCODE_TABLE;

    private Base64() {
    }

    public static byte[] encode(byte[] data) {
        if (data == null) {
            return null;
        }
        int fullGroups = data.length / 3;
        int resultBytes = fullGroups * 4;
        if (data.length % 3 != 0) {
            resultBytes += 4;
        }
        byte[] result = new byte[resultBytes];
        int resultIndex = 0;
        int dataIndex = 0;
        int temp = 0;
        for (int i = 0; i < fullGroups; ++i) {
            temp = (data[dataIndex++] & 0xFF) << 16 | (data[dataIndex++] & 0xFF) << 8 | data[dataIndex++] & 0xFF;
            result[resultIndex++] = ENCODE_TABLE[temp >> 18 & 0x3F];
            result[resultIndex++] = ENCODE_TABLE[temp >> 12 & 0x3F];
            result[resultIndex++] = ENCODE_TABLE[temp >> 6 & 0x3F];
            result[resultIndex++] = ENCODE_TABLE[temp & 0x3F];
        }
        temp = 0;
        while (dataIndex < data.length) {
            temp <<= 8;
            temp |= data[dataIndex++] & 0xFF;
        }
        switch (data.length % 3) {
            case 1: {
                temp <<= 8;
                result[resultIndex++] = ENCODE_TABLE[(temp <<= 8) >> 18 & 0x3F];
                result[resultIndex++] = ENCODE_TABLE[temp >> 12 & 0x3F];
                result[resultIndex++] = 61;
                result[resultIndex++] = 61;
                break;
            }
            case 2: {
                result[resultIndex++] = ENCODE_TABLE[(temp <<= 8) >> 18 & 0x3F];
                result[resultIndex++] = ENCODE_TABLE[temp >> 12 & 0x3F];
                result[resultIndex++] = ENCODE_TABLE[temp >> 6 & 0x3F];
                result[resultIndex++] = 61;
                break;
            }
        }
        return result;
    }

    public static byte[] decode(byte[] base64Data) {
        if (base64Data == null) {
            return null;
        }
        if (base64Data.length == 0) {
            return new byte[0];
        }
        if (base64Data.length % 4 != 0) {
            throw new IllegalArgumentException("\u6570\u636e\u4e0d\u5b8c\u6574\uff0c\u957f\u5ea6\u4e3a\uff1a" + base64Data.length);
        }
        byte[] result = null;
        int groupCount = base64Data.length / 4;
        int lastData = base64Data.length;
        while (base64Data[lastData - 1] == 61) {
            if (--lastData != 0) continue;
            return new byte[0];
        }
        result = new byte[lastData - groupCount];
        int temp = 0;
        int resultIndex = 0;
        int dataIndex = 0;
        while (dataIndex + 4 < base64Data.length) {
            temp = DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex++]];
            result[resultIndex++] = (byte)(temp >> 16 & 0xFF);
            result[resultIndex++] = (byte)(temp >> 8 & 0xFF);
            result[resultIndex++] = (byte)(temp & 0xFF);
        }
        temp = 0;
        int j = 0;
        while (dataIndex < base64Data.length) {
            temp = (temp << 6) + DECODE_TABLE[base64Data[dataIndex]];
            ++dataIndex;
            ++j;
        }
        while (j < 4) {
            temp <<= 6;
            ++j;
        }
        result[resultIndex++] = (byte)(temp >> 16 & 0xFF);
        if (base64Data[dataIndex - 2] != 61) {
            result[resultIndex++] = (byte)(temp >> 8 & 0xFF);
        }
        if (base64Data[dataIndex - 1] != 61) {
            result[resultIndex++] = (byte)(temp & 0xFF);
        }
        return result;
    }

    static {
        int c;
        DECODE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 0, 0, 0, 0, 0, 0, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 0, 0, 0, 0, 0};
        ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        int index = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64.ENCODE_TABLE[index++] = (byte)c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64.ENCODE_TABLE[index++] = (byte)c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64.ENCODE_TABLE[index++] = (byte)c;
        }
        Base64.ENCODE_TABLE[index++] = 43;
        Base64.ENCODE_TABLE[index++] = 47;
        for (int i = 0; i < 64; ++i) {
            Base64.DECODE_TABLE[Base64.ENCODE_TABLE[i]] = (byte)i;
        }
    }
}

