/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.struct;

import com.bokesoft.yes.common.struct.MultiKeyNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class MultiKey
implements Comparable<MultiKey> {
    private ArrayList<MultiKeyNode> values = null;
    private Object userObject = null;

    public MultiKey(ArrayList<MultiKeyNode> values) {
        this.values = values;
    }

    public MultiKey() {
        this.values = new ArrayList();
    }

    public void addValue(MultiKeyNode value) {
        this.values.add(value);
    }

    public void addAll(List<MultiKeyNode> list) {
        this.values.addAll(list);
    }

    public void addAll(int index, List<MultiKeyNode> list) {
        this.values.addAll(index, list);
    }

    public int getValueCount() {
        return this.values.size();
    }

    public MultiKeyNode getValue(int index) {
        return this.values.get(index);
    }

    public ArrayList<MultiKeyNode> getValues() {
        return this.values;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public boolean contains(MultiKey otherValue) {
        int otherCount = otherValue.getValueCount();
        if (this.getValueCount() < otherCount) {
            return false;
        }
        MultiKeyNode v1 = null;
        MultiKeyNode v2 = null;
        for (int i = 0; i < otherCount; ++i) {
            v1 = this.getValue(i);
            if (v1.equals(v2 = otherValue.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public MultiKey clone() {
        MultiKey newObject = new MultiKey();
        Iterator<MultiKeyNode> it = this.values.iterator();
        MultiKeyNode node = null;
        while (it.hasNext()) {
            node = it.next();
            newObject.addValue(node.clone());
        }
        return newObject;
    }

    public MultiKey shallowClone() {
        MultiKey newObject = new MultiKey();
        newObject.addAll(this.values);
        return newObject;
    }

    public static MultiKey newInstance() {
        return new MultiKey();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiKey other = (MultiKey)obj;
        if (this.values.size() != other.getValueCount()) {
            return false;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            MultiKeyNode node_B;
            MultiKeyNode node_A = this.values.get(i);
            if (node_A.equals(node_B = other.getValue(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.values.hashCode();
        result = 31 * result + (this.userObject == null ? 0 : this.userObject.hashCode());
        return result;
    }

    public int compare(MultiKey other) {
        int count = this.getValueCount();
        int result = 0;
        for (int i = 0; i < count; ++i) {
            MultiKeyNode node1 = this.getValue(i);
            MultiKeyNode node2 = other.getValue(i);
            Object value1 = node1.getValue();
            Object value2 = node2.getValue();
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            if (value1 == null && value2 == null) continue;
            switch (node1.getDataType()) {
                case 1: {
                    result = ((Integer)value1).compareTo((Integer)value2);
                    break;
                }
                case 7: {
                    result = ((Long)value1).compareTo((Long)value2);
                    break;
                }
                case 4: {
                    result = ((BigDecimal)value1).compareTo((BigDecimal)value2);
                    break;
                }
                case 2: {
                    result = ((String)value1).compareTo((String)value2);
                    break;
                }
                case 3: {
                    result = ((Date)value1).compareTo((Date)value2);
                }
            }
            if (result != 0) break;
        }
        return result;
    }

    public static Comparator<MultiKey> newComparator() {
        return new Comparator<MultiKey>(){

            @Override
            public int compare(MultiKey o1, MultiKey o2) {
                return o1.compare(o2);
            }

            @Override
            public Comparator<MultiKey> reversed() {
                return null;
            }

            @Override
            public Comparator<MultiKey> thenComparing(Comparator<? super MultiKey> other) {
                return null;
            }

            @Override
            public <U> Comparator<MultiKey> thenComparing(Function<? super MultiKey, ? extends U> keyExtractor, Comparator<? super U> keyComparator) {
                return null;
            }

            @Override
            public <U extends Comparable<? super U>> Comparator<MultiKey> thenComparing(Function<? super MultiKey, ? extends U> keyExtractor) {
                return null;
            }

            @Override
            public Comparator<MultiKey> thenComparingInt(ToIntFunction<? super MultiKey> keyExtractor) {
                return null;
            }

            @Override
            public Comparator<MultiKey> thenComparingLong(ToLongFunction<? super MultiKey> keyExtractor) {
                return null;
            }

            @Override
            public Comparator<MultiKey> thenComparingDouble(ToDoubleFunction<? super MultiKey> keyExtractor) {
                return null;
            }
        };
    }

    @Override
    public int compareTo(MultiKey o) {
        return this.compare(o);
    }
}

