/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.struct;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class LinkedHashMapIgnoreCase<V>
extends HashMapIgnoreCase<V>
implements Map<String, V> {
    private static final long serialVersionUID = 3801124242820219131L;
    transient Entry<V> head;
    transient Entry<V> tail;
    final boolean accessOrder;

    private void linkNodeLast(Entry<V> p) {
        Entry<V> last = this.tail;
        this.tail = p;
        if (last == null) {
            this.head = p;
        } else {
            p.before = last;
            last.after = p;
        }
    }

    private void transferLinks(Entry<V> src, Entry<V> dst) {
        Entry b = dst.before = src.before;
        Entry a = dst.after = src.after;
        if (b == null) {
            this.head = dst;
        } else {
            b.after = dst;
        }
        if (a == null) {
            this.tail = dst;
        } else {
            a.before = dst;
        }
    }

    @Override
    void reinitialize() {
        super.reinitialize();
        this.tail = null;
        this.head = null;
    }

    @Override
    HashMapIgnoreCase.Node<V> newNode(int hash, String key, V value, HashMapIgnoreCase.Node<V> e) {
        Entry<V> p = new Entry<V>(hash, key, value, e);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    HashMapIgnoreCase.Node<V> replacementNode(HashMapIgnoreCase.Node<V> p, HashMapIgnoreCase.Node<V> next) {
        Entry q = (Entry)p;
        Entry<Object> t = new Entry<Object>(q.hash, q.key, q.value, next);
        this.transferLinks(q, t);
        return t;
    }

    @Override
    HashMapIgnoreCase.TreeNode<V> newTreeNode(int hash, String key, V value, HashMapIgnoreCase.Node<V> next) {
        HashMapIgnoreCase.TreeNode<V> p = new HashMapIgnoreCase.TreeNode<V>(hash, key, value, next);
        this.linkNodeLast(p);
        return p;
    }

    @Override
    HashMapIgnoreCase.TreeNode<V> replacementTreeNode(HashMapIgnoreCase.Node<V> p, HashMapIgnoreCase.Node<V> next) {
        Entry q = (Entry)p;
        HashMapIgnoreCase.TreeNode<Object> t = new HashMapIgnoreCase.TreeNode<Object>(q.hash, q.key, q.value, next);
        this.transferLinks(q, t);
        return t;
    }

    @Override
    void afterNodeRemoval(HashMapIgnoreCase.Node<V> e) {
        Entry p = (Entry)e;
        Entry b = p.before;
        Entry a = p.after;
        p.after = null;
        p.before = null;
        if (b == null) {
            this.head = a;
        } else {
            b.after = a;
        }
        if (a == null) {
            this.tail = b;
        } else {
            a.before = b;
        }
    }

    @Override
    void afterNodeInsertion(boolean evict) {
        Entry<V> first;
        if (evict && (first = this.head) != null && this.removeEldestEntry(first)) {
            String key = first.key;
            this.removeNode(LinkedHashMapIgnoreCase.hash(key), key, null, false, true);
        }
    }

    @Override
    void afterNodeAccess(HashMapIgnoreCase.Node<V> e) {
        Entry<V> last;
        if (this.accessOrder && (last = this.tail) != e) {
            Entry p = (Entry)e;
            Entry b = p.before;
            Entry a = p.after;
            p.after = null;
            if (b == null) {
                this.head = a;
            } else {
                b.after = a;
            }
            if (a != null) {
                a.before = b;
            } else {
                last = b;
            }
            if (last == null) {
                this.head = p;
            } else {
                p.before = last;
                last.after = p;
            }
            this.tail = p;
            ++this.modCount;
        }
    }

    @Override
    void internalWriteEntries(ObjectOutputStream s) throws IOException {
        Entry<V> e = this.head;
        while (e != null) {
            s.writeObject(e.key);
            s.writeObject(e.value);
            e = e.after;
        }
    }

    public LinkedHashMapIgnoreCase(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashMapIgnoreCase(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashMapIgnoreCase() {
        this.accessOrder = false;
    }

    public LinkedHashMapIgnoreCase(Map<? extends String, ? extends V> m) {
        this.accessOrder = false;
        this.putMapEntries(m, false);
    }

    public LinkedHashMapIgnoreCase(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<V> e = this.head;
        while (e != null) {
            Object v = e.value;
            if (v == value || value != null && value.equals(v)) {
                return true;
            }
            e = e.after;
        }
        return false;
    }

    @Override
    public V get(String key) {
        HashMapIgnoreCase.Node e = this.getNode(LinkedHashMapIgnoreCase.hash(key), key);
        if (e == null) {
            return null;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(e);
        }
        return e.value;
    }

    @Override
    public V getOrDefault(String key, V defaultValue) {
        HashMapIgnoreCase.Node e = this.getNode(LinkedHashMapIgnoreCase.hash(key), key);
        if (e == null) {
            return defaultValue;
        }
        if (this.accessOrder) {
            this.afterNodeAccess(e);
        }
        return e.value;
    }

    @Override
    public void clear() {
        super.clear();
        this.tail = null;
        this.head = null;
    }

    protected boolean removeEldestEntry(Map.Entry<String, V> eldest) {
        return false;
    }

    @Override
    public Set<String> keySet() {
        Set ks = this.keySet;
        return ks == null ? (this.keySet = new LinkedKeySet()) : ks;
    }

    @Override
    public Collection<V> values() {
        Collection vs = this.values;
        return vs == null ? (this.values = new LinkedValues()) : vs;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        Set es = this.entrySet;
        return es == null ? (this.entrySet = new LinkedEntrySet()) : es;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        int mc = this.modCount;
        Entry<V> e = this.head;
        while (e != null) {
            action.accept(e.key, e.value);
            e = e.after;
        }
        if (this.modCount != mc) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        int mc = this.modCount;
        Entry<V> e = this.head;
        while (e != null) {
            e.value = function.apply(e.key, e.value);
            e = e.after;
        }
        if (this.modCount != mc) {
            throw new ConcurrentModificationException();
        }
    }

    final class LinkedEntryIterator
    extends LinkedHashIterator
    implements Iterator<Map.Entry<String, V>> {
        LinkedEntryIterator() {
        }

        @Override
        public final Map.Entry<String, V> next() {
            return this.nextNode();
        }
    }

    final class LinkedValueIterator
    extends LinkedHashIterator
    implements Iterator<V> {
        LinkedValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class LinkedKeyIterator
    extends LinkedHashIterator
    implements Iterator<String> {
        LinkedKeyIterator() {
        }

        @Override
        public final String next() {
            return this.nextNode().getKey();
        }
    }

    abstract class LinkedHashIterator {
        Entry<V> next;
        Entry<V> current;
        int expectedModCount;

        LinkedHashIterator() {
            this.next = LinkedHashMapIgnoreCase.this.head;
            this.expectedModCount = LinkedHashMapIgnoreCase.this.modCount;
            this.current = null;
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<V> nextNode() {
            Entry e = this.next;
            if (LinkedHashMapIgnoreCase.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = e.after;
            return e;
        }

        public final void remove() {
            Entry p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (LinkedHashMapIgnoreCase.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            String key = p.key;
            LinkedHashMapIgnoreCase.this.removeNode(HashMapIgnoreCase.hash(key), key, null, false, false);
            this.expectedModCount = LinkedHashMapIgnoreCase.this.modCount;
        }
    }

    final class LinkedEntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        LinkedEntrySet() {
        }

        @Override
        public final int size() {
            return LinkedHashMapIgnoreCase.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMapIgnoreCase.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<String, V>> iterator() {
            return new LinkedEntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key = (String)e.getKey();
            HashMapIgnoreCase.Node candidate = LinkedHashMapIgnoreCase.this.getNode(HashMapIgnoreCase.hash(key), key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                String key = (String)e.getKey();
                Object value = e.getValue();
                return LinkedHashMapIgnoreCase.this.removeNode(HashMapIgnoreCase.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<String, V>> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<String, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMapIgnoreCase.this.modCount;
            Entry e = LinkedHashMapIgnoreCase.this.head;
            while (e != null) {
                action.accept(e);
                e = e.after;
            }
            if (LinkedHashMapIgnoreCase.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedValues
    extends AbstractCollection<V> {
        LinkedValues() {
        }

        @Override
        public final int size() {
            return LinkedHashMapIgnoreCase.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMapIgnoreCase.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new LinkedValueIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return LinkedHashMapIgnoreCase.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return Spliterators.spliterator(this, 80);
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMapIgnoreCase.this.modCount;
            Entry e = LinkedHashMapIgnoreCase.this.head;
            while (e != null) {
                action.accept(e.value);
                e = e.after;
            }
            if (LinkedHashMapIgnoreCase.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class LinkedKeySet
    extends AbstractSet<String> {
        LinkedKeySet() {
        }

        @Override
        public final int size() {
            return LinkedHashMapIgnoreCase.this.size;
        }

        @Override
        public final void clear() {
            LinkedHashMapIgnoreCase.this.clear();
        }

        @Override
        public final Iterator<String> iterator() {
            return new LinkedKeyIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return LinkedHashMapIgnoreCase.this.containsKey(o);
        }

        public final boolean remove(String key) {
            return LinkedHashMapIgnoreCase.this.removeNode(HashMapIgnoreCase.hash(key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<String> spliterator() {
            return Spliterators.spliterator(this, 81);
        }

        @Override
        public final void forEach(Consumer<? super String> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = LinkedHashMapIgnoreCase.this.modCount;
            Entry e = LinkedHashMapIgnoreCase.this.head;
            while (e != null) {
                action.accept(e.key);
                e = e.after;
            }
            if (LinkedHashMapIgnoreCase.this.modCount != mc) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static class Entry<V>
    extends HashMapIgnoreCase.Node<V> {
        Entry<V> before;
        Entry<V> after;

        Entry(int hash, String key, V value, HashMapIgnoreCase.Node<V> next) {
            super(hash, key, value, next);
        }
    }
}

