/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.struct;

import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class HashMapIgnoreCase<V>
extends AbstractMap<String, V>
implements Map<String, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -1104173898840693110L;
    volatile transient Set<String> keySet;
    volatile transient Collection<V> values;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    transient Node<V>[] table;
    transient Set<Map.Entry<String, V>> entrySet;
    transient int size;
    transient int modCount;
    int threshold;
    final float loadFactor;

    static final int hash(String key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = HashMapIgnoreCase.getHashCode(key);
            n = h ^ h >>> 16;
        }
        return n;
    }

    protected static int getHashCode(String key) {
        int len = key.length();
        char[] chars = key.toCharArray();
        int h = 0;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            h = c >= 'A' && c <= 'Z' ? 31 * h + (c + 32) : 31 * h + c;
        }
        return h;
    }

    static Class<?> comparableClassFor(Object x) {
        if (x instanceof Comparable) {
            Class<?> c = x.getClass();
            if (c == String.class) {
                return c;
            }
            Type[] ts = c.getGenericInterfaces();
            if (ts != null) {
                for (int i = 0; i < ts.length; ++i) {
                    Type[] as;
                    ParameterizedType p;
                    Type t = ts[i];
                    if (!(t instanceof ParameterizedType) || (p = (ParameterizedType)t).getRawType() != Comparable.class || (as = p.getActualTypeArguments()) == null || as.length != 1 || as[0] != c) continue;
                    return c;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> kc, Object k, Object x) {
        return x == null || x.getClass() != kc ? 0 : ((Comparable)k).compareTo(x);
    }

    static final int tableSizeFor(int cap) {
        int n = cap - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    public HashMapIgnoreCase(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.threshold = HashMapIgnoreCase.tableSizeFor(initialCapacity);
    }

    public HashMapIgnoreCase(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashMapIgnoreCase() {
        this.loadFactor = 0.75f;
    }

    public HashMapIgnoreCase(Map<? extends String, ? extends V> m) {
        this.loadFactor = 0.75f;
        this.putMapEntries(m, false);
    }

    final void putMapEntries(Map<? extends String, ? extends V> m, boolean evict) {
        int s = m.size();
        if (s > 0) {
            if (this.table == null) {
                int t;
                float ft = (float)s / this.loadFactor + 1.0f;
                int n = t = ft < 1.0737418E9f ? (int)ft : 0x40000000;
                if (t > this.threshold) {
                    this.threshold = HashMapIgnoreCase.tableSizeFor(t);
                }
            } else if (s > this.threshold) {
                this.resize();
            }
            for (Map.Entry<String, V> e : m.entrySet()) {
                String key = e.getKey();
                V value = e.getValue();
                this.putVal(HashMapIgnoreCase.hash(key), key, value, false, evict);
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(String key) {
        Node<V> e = this.getNode(HashMapIgnoreCase.hash(key), key);
        return e == null ? null : (V)e.value;
    }

    final Node<V> getNode(int hash, String key) {
        Node<V> first;
        int n;
        Node<V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (first = tab[n - 1 & hash]) != null) {
            String k;
            if (first.hash == hash && ((k = first.key) == key || key != null && key.equalsIgnoreCase(k))) {
                return first;
            }
            Node e = first.next;
            if (e != null) {
                if (first instanceof TreeNode) {
                    return ((TreeNode)first).getTreeNode(hash, key);
                }
                do {
                    if (e.hash != hash || (k = e.key) != key && (key == null || !key.equalsIgnoreCase(k))) continue;
                    return e;
                } while ((e = e.next) != null);
            }
        }
        return null;
    }

    public boolean containsKey(String key) {
        return this.getNode(HashMapIgnoreCase.hash(key), key) != null;
    }

    @Override
    public V put(String key, V value) {
        return this.putVal(HashMapIgnoreCase.hash(key), key, value, false, true);
    }

    final V putVal(int hash, String key, V value, boolean onlyIfAbsent, boolean evict) {
        int i;
        Node<V> p;
        int n;
        Node<V>[] tab = this.table;
        if (this.table == null || (n = tab.length) == 0) {
            tab = this.resize();
            n = tab.length;
        }
        if ((p = tab[i = n - 1 & hash]) == null) {
            tab[i] = this.newNode(hash, key, value, null);
        } else {
            Node<V> e;
            String k;
            if (p.hash == hash && ((k = p.key) == key || key != null && key.equalsIgnoreCase(k))) {
                e = p;
            } else if (p instanceof TreeNode) {
                e = ((TreeNode)p).putTreeVal(this, tab, hash, key, value);
            } else {
                int binCount = 0;
                while (true) {
                    if ((e = p.next) == null) {
                        p.next = this.newNode(hash, key, value, null);
                        if (binCount < 7) break;
                        this.treeifyBin(tab, hash);
                        break;
                    }
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equalsIgnoreCase(k))) break;
                    p = e;
                    ++binCount;
                }
            }
            if (e != null) {
                Object oldValue = e.value;
                if (!onlyIfAbsent || oldValue == null) {
                    e.value = value;
                }
                this.afterNodeAccess(e);
                return oldValue;
            }
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.resize();
        }
        this.afterNodeInsertion(evict);
        return null;
    }

    final Node<V>[] resize() {
        int newCap;
        Node<V>[] oldTab = this.table;
        int oldCap = oldTab == null ? 0 : oldTab.length;
        int oldThr = this.threshold;
        int newThr = 0;
        if (oldCap > 0) {
            if (oldCap >= 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return oldTab;
            }
            newCap = oldCap << 1;
            if (newCap < 0x40000000 && oldCap >= 16) {
                newThr = oldThr << 1;
            }
        } else if (oldThr > 0) {
            newCap = oldThr;
        } else {
            newCap = 16;
            newThr = 12;
        }
        if (newThr == 0) {
            float ft = (float)newCap * this.loadFactor;
            newThr = newCap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
        }
        this.threshold = newThr;
        Node[] newTab = new Node[newCap];
        this.table = newTab;
        if (oldTab != null) {
            for (int j = 0; j < oldCap; ++j) {
                Node next;
                Node<V> e = oldTab[j];
                if (e == null) continue;
                oldTab[j] = null;
                if (e.next == null) {
                    newTab[e.hash & newCap - 1] = e;
                    continue;
                }
                if (e instanceof TreeNode) {
                    ((TreeNode)e).split(this, newTab, j, oldCap);
                    continue;
                }
                Node<V> loHead = null;
                Node<V> loTail = null;
                Node<V> hiHead = null;
                Node<V> hiTail = null;
                do {
                    next = e.next;
                    if ((e.hash & oldCap) == 0) {
                        if (loTail == null) {
                            loHead = e;
                        } else {
                            loTail.next = e;
                        }
                        loTail = e;
                        continue;
                    }
                    if (hiTail == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                } while ((e = next) != null);
                if (loTail != null) {
                    loTail.next = null;
                    newTab[j] = loHead;
                }
                if (hiTail == null) continue;
                hiTail.next = null;
                newTab[j + oldCap] = hiHead;
            }
        }
        return newTab;
    }

    final void treeifyBin(Node<V>[] tab, int hash) {
        int n;
        if (tab == null || (n = tab.length) < 64) {
            this.resize();
        } else {
            int index = n - 1 & hash;
            Node<V> e = tab[index];
            if (e != null) {
                TreeNode<V> hd = null;
                TreeNode<V> tl = null;
                do {
                    TreeNode<V> p = this.replacementTreeNode(e, null);
                    if (tl == null) {
                        hd = p;
                    } else {
                        p.prev = tl;
                        tl.next = p;
                    }
                    tl = p;
                } while ((e = e.next) != null);
                tab[index] = hd;
                if (tab[index] != null) {
                    hd.treeify(tab);
                }
            }
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        this.putMapEntries(m, true);
    }

    public V remove(String key) {
        Node<V> e = this.removeNode(HashMapIgnoreCase.hash(key), key, null, false, true);
        return e == null ? null : (V)e.value;
    }

    final Node<V> removeNode(int hash, String key, Object value, boolean matchValue, boolean movable) {
        int index;
        Node<V> p;
        int n;
        Node<V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (p = tab[index = n - 1 & hash]) != null) {
            Object v;
            String k;
            Node<V> node = null;
            if (p.hash == hash && ((k = p.key) == key || key != null && key.equalsIgnoreCase(k))) {
                node = p;
            } else {
                Node e = p.next;
                if (e != null) {
                    if (p instanceof TreeNode) {
                        node = ((TreeNode)p).getTreeNode(hash, key);
                    } else {
                        do {
                            if (e.hash == hash && ((k = e.key) == key || key != null && key.equalsIgnoreCase(k))) {
                                node = e;
                                break;
                            }
                            p = e;
                        } while ((e = e.next) != null);
                    }
                }
            }
            if (node != null && (!matchValue || (v = node.value) == value || value != null && value.equals(v))) {
                if (node instanceof TreeNode) {
                    ((TreeNode)node).removeTreeNode(this, tab, movable);
                } else if (node == p) {
                    tab[index] = node.next;
                } else {
                    p.next = node.next;
                }
                ++this.modCount;
                --this.size;
                this.afterNodeRemoval(node);
                return node;
            }
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Node<V>[] tab = this.table;
        if (this.table != null && this.size > 0) {
            this.size = 0;
            for (int i = 0; i < tab.length; ++i) {
                tab[i] = null;
            }
        }
    }

    @Override
    public boolean containsValue(Object value) {
        Node<V>[] tab = this.table;
        if (this.table != null && this.size > 0) {
            for (int i = 0; i < tab.length; ++i) {
                Node<V> e = tab[i];
                while (e != null) {
                    Object v = e.value;
                    if (v == value || value != null && value.equals(v)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<String> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs == null ? (this.values = new Values()) : vs;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    public V getOrDefault(String key, V defaultValue) {
        Node<V> e = this.getNode(HashMapIgnoreCase.hash(key), key);
        return e == null ? defaultValue : e.value;
    }

    @Override
    public V putIfAbsent(String key, V value) {
        return this.putVal(HashMapIgnoreCase.hash(key), key, value, true, true);
    }

    public boolean remove(String key, Object value) {
        return this.removeNode(HashMapIgnoreCase.hash(key), key, value, true, true) != null;
    }

    @Override
    public boolean replace(String key, V oldValue, V newValue) {
        Object v;
        Node<V> e = this.getNode(HashMapIgnoreCase.hash(key), key);
        if (e != null && ((v = e.value) == oldValue || v != null && v.equals(oldValue))) {
            e.value = newValue;
            this.afterNodeAccess(e);
            return true;
        }
        return false;
    }

    @Override
    public V replace(String key, V value) {
        Node<V> e = this.getNode(HashMapIgnoreCase.hash(key), key);
        if (e != null) {
            Object oldValue = e.value;
            e.value = value;
            this.afterNodeAccess(e);
            return oldValue;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(String key, Function<? super String, ? extends V> mappingFunction) {
        V v;
        int i;
        Node<V> first;
        int n;
        Node<V>[] tab;
        Node old;
        TreeNode t;
        int binCount;
        int hash;
        block16: {
            block15: {
                if (mappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = HashMapIgnoreCase.hash(key);
                binCount = 0;
                t = null;
                old = null;
                if (this.size > this.threshold) break block15;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block16;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            Object oldValue;
            if (first instanceof TreeNode) {
                t = (TreeNode)first;
                old = t.getTreeNode(hash, key);
            } else {
                Node<V> e = first;
                do {
                    String k;
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equalsIgnoreCase(k))) {
                        old = e;
                        break;
                    }
                    ++binCount;
                } while ((e = e.next) != null);
            }
            if (old != null && (oldValue = old.value) != null) {
                this.afterNodeAccess(old);
                return oldValue;
            }
        }
        if ((v = mappingFunction.apply(key)) == null) {
            return null;
        }
        if (old != null) {
            old.value = v;
            this.afterNodeAccess(old);
            return v;
        }
        if (t != null) {
            t.putTreeVal(this, tab, hash, key, v);
        } else {
            tab[i] = this.newNode(hash, key, v, first);
            if (binCount >= 7) {
                this.treeifyBin(tab, hash);
            }
        }
        ++this.modCount;
        ++this.size;
        this.afterNodeInsertion(true);
        return v;
    }

    @Override
    public V computeIfPresent(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        int hash = HashMapIgnoreCase.hash(key);
        Node<V> e = this.getNode(hash, key);
        if (e != null && (oldValue = e.value) != null) {
            V v = remappingFunction.apply(key, oldValue);
            if (v != null) {
                e.value = v;
                this.afterNodeAccess(e);
                return v;
            }
            this.removeNode(hash, key, null, false, true);
        }
        return null;
    }

    @Override
    public V compute(String key, BiFunction<? super String, ? super V, ? extends V> remappingFunction) {
        int i;
        Node<V> first;
        int n;
        Node<V>[] tab;
        Node old;
        TreeNode t;
        int binCount;
        int hash;
        block18: {
            block17: {
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = HashMapIgnoreCase.hash(key);
                binCount = 0;
                t = null;
                old = null;
                if (this.size > this.threshold) break block17;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block18;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            if (first instanceof TreeNode) {
                t = (TreeNode)first;
                old = t.getTreeNode(hash, key);
            } else {
                Node<V> e = first;
                do {
                    String k;
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equalsIgnoreCase(k))) {
                        old = e;
                        break;
                    }
                    ++binCount;
                } while ((e = e.next) != null);
            }
        }
        Object oldValue = old == null ? null : (Object)old.value;
        V v = remappingFunction.apply(key, oldValue);
        if (old != null) {
            if (v != null) {
                old.value = v;
                this.afterNodeAccess(old);
            } else {
                this.removeNode(hash, key, null, false, true);
            }
        } else if (v != null) {
            if (t != null) {
                t.putTreeVal(this, tab, hash, key, v);
            } else {
                tab[i] = this.newNode(hash, key, v, first);
                if (binCount >= 7) {
                    this.treeifyBin(tab, hash);
                }
            }
            ++this.modCount;
            ++this.size;
            this.afterNodeInsertion(true);
        }
        return v;
    }

    @Override
    public V merge(String key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        int i;
        Node<V> first;
        int n;
        Node<V>[] tab;
        Node old;
        TreeNode t;
        int binCount;
        int hash;
        block18: {
            block17: {
                if (value == null) {
                    throw new NullPointerException();
                }
                if (remappingFunction == null) {
                    throw new NullPointerException();
                }
                hash = HashMapIgnoreCase.hash(key);
                binCount = 0;
                t = null;
                old = null;
                if (this.size > this.threshold) break block17;
                tab = this.table;
                if (this.table != null && (n = tab.length) != 0) break block18;
            }
            tab = this.resize();
            n = tab.length;
        }
        if ((first = tab[i = n - 1 & hash]) != null) {
            if (first instanceof TreeNode) {
                t = (TreeNode)first;
                old = t.getTreeNode(hash, key);
            } else {
                Node<V> e = first;
                do {
                    String k;
                    if (e.hash == hash && ((k = e.key) == key || key != null && key.equalsIgnoreCase(k))) {
                        old = e;
                        break;
                    }
                    ++binCount;
                } while ((e = e.next) != null);
            }
        }
        if (old != null) {
            V v = old.value != null ? remappingFunction.apply(old.value, value) : value;
            if (v != null) {
                old.value = v;
                this.afterNodeAccess(old);
            } else {
                this.removeNode(hash, key, null, false, true);
            }
            return v;
        }
        if (value != null) {
            if (t != null) {
                t.putTreeVal(this, tab, hash, key, value);
            } else {
                tab[i] = this.newNode(hash, key, value, first);
                if (binCount >= 7) {
                    this.treeifyBin(tab, hash);
                }
            }
            ++this.modCount;
            ++this.size;
            this.afterNodeInsertion(true);
        }
        return value;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super V> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node<V>[] tab = this.table;
            if (this.table != null) {
                int mc = this.modCount;
                for (int i = 0; i < tab.length; ++i) {
                    Node<V> e = tab[i];
                    while (e != null) {
                        action.accept(e.key, e.value);
                        e = e.next;
                    }
                }
                if (this.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super V, ? extends V> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node<V>[] tab = this.table;
            if (this.table != null) {
                int mc = this.modCount;
                for (int i = 0; i < tab.length; ++i) {
                    Node<V> e = tab[i];
                    while (e != null) {
                        e.value = function.apply(e.key, e.value);
                        e = e.next;
                    }
                }
                if (this.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public Object clone() {
        HashMapIgnoreCase result;
        try {
            result = (HashMapIgnoreCase)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        result.reinitialize();
        result.putMapEntries(this, false);
        return result;
    }

    final float loadFactor() {
        return this.loadFactor;
    }

    final int capacity() {
        return this.table != null ? this.table.length : (this.threshold > 0 ? this.threshold : 16);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int buckets = this.capacity();
        s.defaultWriteObject();
        s.writeInt(buckets);
        s.writeInt(this.size);
        this.internalWriteEntries(s);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.reinitialize();
        if (this.loadFactor <= 0.0f || Float.isNaN(this.loadFactor)) {
            throw new InvalidObjectException("Illegal load factor: " + this.loadFactor);
        }
        s.readInt();
        int mappings = s.readInt();
        if (mappings < 0) {
            throw new InvalidObjectException("Illegal mappings count: " + mappings);
        }
        if (mappings > 0) {
            float lf = Math.min(Math.max(0.25f, this.loadFactor), 4.0f);
            float fc = (float)mappings / lf + 1.0f;
            int cap = fc < 16.0f ? 16 : (fc >= 1.0737418E9f ? 0x40000000 : HashMapIgnoreCase.tableSizeFor((int)fc));
            float ft = (float)cap * lf;
            this.threshold = cap < 0x40000000 && ft < 1.0737418E9f ? (int)ft : Integer.MAX_VALUE;
            Node[] tab = new Node[cap];
            this.table = tab;
            for (int i = 0; i < mappings; ++i) {
                String key = (String)s.readObject();
                Object value = s.readObject();
                this.putVal(HashMapIgnoreCase.hash(key), key, value, false, false);
            }
        }
    }

    Node<V> newNode(int hash, String key, V value, Node<V> next) {
        return new Node<V>(hash, key, value, next);
    }

    Node<V> replacementNode(Node<V> p, Node<V> next) {
        return new Node(p.hash, p.key, p.value, next);
    }

    TreeNode<V> newTreeNode(int hash, String key, V value, Node<V> next) {
        return new TreeNode<V>(hash, key, value, next);
    }

    TreeNode<V> replacementTreeNode(Node<V> p, Node<V> next) {
        return new TreeNode(p.hash, p.key, p.value, next);
    }

    void reinitialize() {
        this.table = null;
        this.entrySet = null;
        this.keySet = null;
        this.values = null;
        this.modCount = 0;
        this.threshold = 0;
        this.size = 0;
    }

    void afterNodeAccess(Node<V> p) {
    }

    void afterNodeInsertion(boolean evict) {
    }

    void afterNodeRemoval(Node<V> p) {
    }

    void internalWriteEntries(ObjectOutputStream s) throws IOException {
        if (this.size > 0) {
            Node<V>[] tab = this.table;
            if (this.table != null) {
                for (int i = 0; i < tab.length; ++i) {
                    Node<V> e = tab[i];
                    while (e != null) {
                        s.writeObject(e.key);
                        s.writeObject(e.value);
                        e = e.next;
                    }
                }
            }
        }
    }

    static final class TreeNode<V>
    extends LinkedHashMapIgnoreCase.Entry<V> {
        TreeNode<V> parent;
        TreeNode<V> left;
        TreeNode<V> right;
        TreeNode<V> prev;
        boolean red;

        TreeNode(int hash, String key, V val, Node<V> next) {
            super(hash, key, val, next);
        }

        final TreeNode<V> root() {
            TreeNode<V> r = this;
            TreeNode<V> p;
            while ((p = r.parent) != null) {
                r = p;
            }
            return r;
        }

        static <V> void moveRootToFront(Node<V>[] tab, TreeNode<V> root) {
            int n;
            if (root != null && tab != null && (n = tab.length) > 0) {
                int index = n - 1 & root.hash;
                TreeNode first = (TreeNode)tab[index];
                if (root != first) {
                    tab[index] = root;
                    TreeNode<V> rp = root.prev;
                    Node rn = root.next;
                    if (rn != null) {
                        ((TreeNode)rn).prev = rp;
                    }
                    if (rp != null) {
                        rp.next = rn;
                    }
                    if (first != null) {
                        first.prev = root;
                    }
                    root.next = first;
                    root.prev = null;
                }
                assert (TreeNode.checkInvariants(root));
            }
        }

        final TreeNode<V> find(int h, String k, Class<?> kc) {
            TreeNode<V> p = this;
            do {
                int dir;
                TreeNode<V> pl = p.left;
                TreeNode<V> pr = p.right;
                int ph = p.hash;
                if (ph > h) {
                    p = pl;
                    continue;
                }
                if (ph < h) {
                    p = pr;
                    continue;
                }
                String pk = p.key;
                if (pk == k || k != null && k.equalsIgnoreCase(pk)) {
                    return p;
                }
                if (pl == null) {
                    p = pr;
                    continue;
                }
                if (pr == null) {
                    p = pl;
                    continue;
                }
                if ((kc != null || (kc = HashMapIgnoreCase.comparableClassFor(k)) != null) && (dir = HashMapIgnoreCase.compareComparables(kc, k, pk)) != 0) {
                    p = dir < 0 ? pl : pr;
                    continue;
                }
                TreeNode<V> q = pr.find(h, k, kc);
                if (q != null) {
                    return q;
                }
                p = pl;
            } while (p != null);
            return null;
        }

        final TreeNode<V> getTreeNode(int h, String k) {
            return (this.parent != null ? this.root() : this).find(h, k, null);
        }

        static int tieBreakOrder(Object a, Object b) {
            int d;
            if (a == null || b == null || (d = a.getClass().getName().compareTo(b.getClass().getName())) == 0) {
                d = System.identityHashCode(a) <= System.identityHashCode(b) ? -1 : 1;
            }
            return d;
        }

        final void treeify(Node<V>[] tab) {
            TreeNode<V> root = null;
            TreeNode<V> x = this;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (root == null) {
                    x.parent = null;
                    x.red = false;
                    root = x;
                } else {
                    TreeNode<V> xp;
                    int dir;
                    String k = x.key;
                    int h = x.hash;
                    Class<?> kc = null;
                    TreeNode<V> p = root;
                    do {
                        String pk = p.key;
                        int ph = p.hash;
                        if (ph > h) {
                            dir = -1;
                        } else if (ph < h) {
                            dir = 1;
                        } else if (kc == null && (kc = HashMapIgnoreCase.comparableClassFor(k)) == null || (dir = HashMapIgnoreCase.compareComparables(kc, k, pk)) == 0) {
                            dir = TreeNode.tieBreakOrder(k, pk);
                        }
                        xp = p;
                    } while ((p = dir <= 0 ? p.left : p.right) != null);
                    x.parent = xp;
                    if (dir <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    root = TreeNode.balanceInsertion(root, x);
                }
                x = next;
            }
            TreeNode.moveRootToFront(tab, root);
        }

        final Node<V> untreeify(HashMapIgnoreCase<V> map) {
            Node<V> hd = null;
            Node<V> tl = null;
            Node q = this;
            while (q != null) {
                Node<V> p = map.replacementNode(q, null);
                if (tl == null) {
                    hd = p;
                } else {
                    tl.next = p;
                }
                tl = p;
                q = q.next;
            }
            return hd;
        }

        final TreeNode<V> putTreeVal(HashMapIgnoreCase<V> map, Node<V>[] tab, int h, String k, V v) {
            TreeNode<V> xp;
            int dir;
            TreeNode<V> root;
            Class<?> kc = null;
            boolean searched = false;
            TreeNode<V> p = root = this.parent != null ? this.root() : this;
            do {
                int ph;
                if ((ph = p.hash) > h) {
                    dir = -1;
                } else if (ph < h) {
                    dir = 1;
                } else {
                    String pk = p.key;
                    if (pk == k || k != null && k.equalsIgnoreCase(pk)) {
                        return p;
                    }
                    if (kc == null && (kc = HashMapIgnoreCase.comparableClassFor(k)) == null || (dir = HashMapIgnoreCase.compareComparables(kc, k, pk)) == 0) {
                        if (!searched) {
                            TreeNode<V> q;
                            searched = true;
                            TreeNode<V> ch = p.left;
                            if (ch != null && (q = ch.find(h, k, kc)) != null || (ch = p.right) != null && (q = ch.find(h, k, kc)) != null) {
                                return q;
                            }
                        }
                        dir = TreeNode.tieBreakOrder(k, pk);
                    }
                }
                xp = p;
            } while ((p = dir <= 0 ? p.left : p.right) != null);
            Node xpn = xp.next;
            TreeNode<V> x = map.newTreeNode(h, k, v, xpn);
            if (dir <= 0) {
                xp.left = x;
            } else {
                xp.right = x;
            }
            xp.next = x;
            x.prev = xp;
            x.parent = x.prev;
            if (xpn != null) {
                ((TreeNode)xpn).prev = x;
            }
            TreeNode.moveRootToFront(tab, TreeNode.balanceInsertion(root, x));
            return null;
        }

        final void removeTreeNode(HashMapIgnoreCase<V> map, Node<V>[] tab, boolean movable) {
            TreeNode<V> r;
            TreeNode<V> replacement;
            TreeNode<V> rl;
            TreeNode<V> first;
            int n;
            if (tab == null || (n = tab.length) == 0) {
                return;
            }
            int index = n - 1 & this.hash;
            TreeNode<V> root = first = (TreeNode<V>)tab[index];
            TreeNode succ = (TreeNode)this.next;
            TreeNode<V> pred = this.prev;
            if (pred == null) {
                first = succ;
                tab[index] = first;
            } else {
                pred.next = succ;
            }
            if (succ != null) {
                succ.prev = pred;
            }
            if (first == null) {
                return;
            }
            if (root.parent != null) {
                root = root.root();
            }
            if (root == null || root.right == null || (rl = root.left) == null || rl.left == null) {
                tab[index] = first.untreeify(map);
                return;
            }
            TreeNode<V> p = this;
            TreeNode<V> pl = this.left;
            TreeNode<V> pr = this.right;
            if (pl != null && pr != null) {
                TreeNode<V> sl;
                TreeNode<V> s = pr;
                while ((sl = s.left) != null) {
                    s = sl;
                }
                boolean c = s.red;
                s.red = p.red;
                p.red = c;
                TreeNode<V> sr = s.right;
                TreeNode<V> pp = p.parent;
                if (s == pr) {
                    p.parent = s;
                    s.right = p;
                } else {
                    TreeNode<V> sp = s.parent;
                    p.parent = sp;
                    if (p.parent != null) {
                        if (s == sp.left) {
                            sp.left = p;
                        } else {
                            sp.right = p;
                        }
                    }
                    if ((s.right = pr) != null) {
                        pr.parent = s;
                    }
                }
                p.left = null;
                p.right = sr;
                if (p.right != null) {
                    sr.parent = p;
                }
                if ((s.left = pl) != null) {
                    pl.parent = s;
                }
                if ((s.parent = pp) == null) {
                    root = s;
                } else if (p == pp.left) {
                    pp.left = s;
                } else {
                    pp.right = s;
                }
                replacement = sr != null ? sr : p;
            } else {
                replacement = pl != null ? pl : (pr != null ? pr : p);
            }
            if (replacement != p) {
                replacement.parent = p.parent;
                TreeNode<V> pp = replacement.parent;
                if (pp == null) {
                    root = replacement;
                } else if (p == pp.left) {
                    pp.left = replacement;
                } else {
                    pp.right = replacement;
                }
                p.parent = null;
                p.right = null;
                p.left = null;
            }
            TreeNode<V> treeNode = r = p.red ? root : TreeNode.balanceDeletion(root, replacement);
            if (replacement == p) {
                TreeNode<V> pp = p.parent;
                p.parent = null;
                if (pp != null) {
                    if (p == pp.left) {
                        pp.left = null;
                    } else if (p == pp.right) {
                        pp.right = null;
                    }
                }
            }
            if (movable) {
                TreeNode.moveRootToFront(tab, r);
            }
        }

        final void split(HashMapIgnoreCase<V> map, Node<V>[] tab, int index, int bit) {
            TreeNode b = this;
            TreeNode loHead = null;
            TreeNode loTail = null;
            TreeNode hiHead = null;
            TreeNode hiTail = null;
            int lc = 0;
            int hc = 0;
            TreeNode e = b;
            while (e != null) {
                TreeNode next = (TreeNode)e.next;
                e.next = null;
                if ((e.hash & bit) == 0) {
                    e.prev = loTail;
                    if (e.prev == null) {
                        loHead = e;
                    } else {
                        loTail.next = e;
                    }
                    loTail = e;
                    ++lc;
                } else {
                    e.prev = hiTail;
                    if (e.prev == null) {
                        hiHead = e;
                    } else {
                        hiTail.next = e;
                    }
                    hiTail = e;
                    ++hc;
                }
                e = next;
            }
            if (loHead != null) {
                if (lc <= 6) {
                    tab[index] = loHead.untreeify(map);
                } else {
                    tab[index] = loHead;
                    if (hiHead != null) {
                        loHead.treeify(tab);
                    }
                }
            }
            if (hiHead != null) {
                if (hc <= 6) {
                    tab[index + bit] = hiHead.untreeify(map);
                } else {
                    tab[index + bit] = hiHead;
                    if (loHead != null) {
                        hiHead.treeify(tab);
                    }
                }
            }
        }

        static <V> TreeNode<V> rotateLeft(TreeNode<V> root, TreeNode<V> p) {
            TreeNode<V> r;
            if (p != null && (r = p.right) != null) {
                p.right = r.left;
                TreeNode<V> rl = p.right;
                if (p.right != null) {
                    rl.parent = p;
                }
                TreeNode<V> pp = r.parent = p.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p;
                p.parent = r;
            }
            return root;
        }

        static <V> TreeNode<V> rotateRight(TreeNode<V> root, TreeNode<V> p) {
            TreeNode<V> l;
            if (p != null && (l = p.left) != null) {
                p.left = l.right;
                TreeNode<V> lr = p.left;
                if (p.left != null) {
                    lr.parent = p;
                }
                TreeNode<V> pp = l.parent = p.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p;
                p.parent = l;
            }
            return root;
        }

        static <V> TreeNode<V> balanceInsertion(TreeNode<V> root, TreeNode<V> x) {
            x.red = true;
            while (true) {
                TreeNode<V> xpp;
                TreeNode<V> xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode<V> xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode<V> xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeNode.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode<V> treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeNode.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeNode.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode<V> treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeNode.rotateLeft(root, xpp);
            }
        }

        static <V> TreeNode<V> balanceDeletion(TreeNode<V> root, TreeNode<V> x) {
            while (x != null && x != root) {
                TreeNode<V> sr;
                TreeNode<V> sl;
                TreeNode<V> xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode<V> xpl = xp.left;
                if (xpl == x) {
                    TreeNode<V> xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeNode.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode<V> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeNode.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode<V> treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeNode.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeNode.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode<V> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeNode.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode<V> treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeNode.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <V> boolean checkInvariants(TreeNode<V> t) {
            TreeNode<V> tp = t.parent;
            TreeNode<V> tl = t.left;
            TreeNode<V> tr = t.right;
            TreeNode<V> tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr != null && (tr.parent != t || tr.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr != null && tr.red) {
                return false;
            }
            if (tl != null && !TreeNode.checkInvariants(tl)) {
                return false;
            }
            return tr == null || TreeNode.checkInvariants(tr);
        }
    }

    static class Entry<V>
    extends Node<V> {
        Entry<V> before;
        Entry<V> after;

        Entry(int hash, String key, V value, Node<V> next) {
            super(hash, key, value, next);
        }
    }

    static final class EntrySpliterator<V>
    extends HashMapSpliterator<V>
    implements Spliterator<Map.Entry<String, V>> {
        EntrySpliterator(HashMapIgnoreCase<V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        @Override
        public EntrySpliterator<V> trySplit() {
            EntrySpliterator<V> entrySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                entrySpliterator = null;
            } else {
                this.index = mid;
                EntrySpliterator<V> entrySpliterator2 = new EntrySpliterator<V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<String, V>> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMapIgnoreCase m = this.map;
            Node<V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<String, V>> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Node e = this.current;
                    this.current = this.current.next;
                    action.accept(e);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static final class ValueSpliterator<V>
    extends HashMapSpliterator<V>
    implements Spliterator<V> {
        ValueSpliterator(HashMapIgnoreCase<V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        @Override
        public ValueSpliterator<V> trySplit() {
            ValueSpliterator<V> valueSpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                valueSpliterator = null;
            } else {
                this.index = mid;
                ValueSpliterator<V> valueSpliterator2 = new ValueSpliterator<V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMapIgnoreCase m = this.map;
            Node<V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p.value);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    Object v = this.current.value;
                    this.current = this.current.next;
                    action.accept(v);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return this.fence < 0 || this.est == this.map.size ? 64 : 0;
        }
    }

    static final class KeySpliterator<V>
    extends HashMapSpliterator<V>
    implements Spliterator<String> {
        KeySpliterator(HashMapIgnoreCase<V> m, int origin, int fence, int est, int expectedModCount) {
            super(m, origin, fence, est, expectedModCount);
        }

        @Override
        public KeySpliterator<V> trySplit() {
            KeySpliterator<V> keySpliterator;
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            if (lo >= mid || this.current != null) {
                keySpliterator = null;
            } else {
                this.index = mid;
                KeySpliterator<V> keySpliterator2 = new KeySpliterator<V>(this.map, lo, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
            int i;
            int mc;
            if (action == null) {
                throw new NullPointerException();
            }
            HashMapIgnoreCase m = this.map;
            Node<V>[] tab = m.table;
            int hi = this.fence;
            if (hi < 0) {
                mc = this.expectedModCount = m.modCount;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            } else {
                mc = this.expectedModCount;
            }
            if (tab != null && tab.length >= hi && (i = this.index) >= 0 && (i < (this.index = hi) || this.current != null)) {
                Node p = this.current;
                this.current = null;
                do {
                    if (p == null) {
                        p = tab[i++];
                        continue;
                    }
                    action.accept(p.key);
                    p = p.next;
                } while (p != null || i < hi);
                if (m.modCount != mc) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            int hi;
            if (action == null) {
                throw new NullPointerException();
            }
            Node<V>[] tab = this.map.table;
            if (tab != null && tab.length >= (hi = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < hi) {
                    if (this.current == null) {
                        this.current = tab[this.index++];
                        continue;
                    }
                    String k = this.current.key;
                    this.current = this.current.next;
                    action.accept(k);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static class HashMapSpliterator<V> {
        final HashMapIgnoreCase<V> map;
        Node<V> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        HashMapSpliterator(HashMapIgnoreCase<V> m, int origin, int fence, int est, int expectedModCount) {
            this.map = m;
            this.index = origin;
            this.fence = fence;
            this.est = est;
            this.expectedModCount = expectedModCount;
        }

        final int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                HashMapIgnoreCase<V> m = this.map;
                this.est = m.size;
                this.expectedModCount = m.modCount;
                Node<V>[] tab = m.table;
                this.fence = tab == null ? 0 : tab.length;
                hi = this.fence;
            }
            return hi;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<String, V>> {
        EntryIterator() {
        }

        @Override
        public final Map.Entry<String, V> next() {
            return this.nextNode();
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<String> {
        KeyIterator() {
        }

        @Override
        public final String next() {
            return this.nextNode().key;
        }
    }

    abstract class HashIterator {
        Node<V> next;
        Node<V> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = HashMapIgnoreCase.this.modCount;
            Node<V>[] t = HashMapIgnoreCase.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && HashMapIgnoreCase.this.size > 0) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<V> nextNode() {
            Node e = this.next;
            if (HashMapIgnoreCase.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                Node<V>[] t = HashMapIgnoreCase.this.table;
                if (HashMapIgnoreCase.this.table != null) {
                    while (this.index < t.length && (this.next = t[this.index++]) == null) {
                    }
                }
            }
            return e;
        }

        public final void remove() {
            Node p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (HashMapIgnoreCase.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            String key = p.key;
            HashMapIgnoreCase.this.removeNode(HashMapIgnoreCase.hash(key), key, null, false, false);
            this.expectedModCount = HashMapIgnoreCase.this.modCount;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<String, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return HashMapIgnoreCase.this.size;
        }

        @Override
        public final void clear() {
            HashMapIgnoreCase.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<String, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            String key = (String)e.getKey();
            Node candidate = HashMapIgnoreCase.this.getNode(HashMapIgnoreCase.hash(key), key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                String key = (String)e.getKey();
                Object value = e.getValue();
                return HashMapIgnoreCase.this.removeNode(HashMapIgnoreCase.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<String, V>> spliterator() {
            return new EntrySpliterator(HashMapIgnoreCase.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<String, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMapIgnoreCase.this.size > 0) {
                Node<V>[] tab = HashMapIgnoreCase.this.table;
                if (HashMapIgnoreCase.this.table != null) {
                    int mc = HashMapIgnoreCase.this.modCount;
                    for (int i = 0; i < tab.length; ++i) {
                        Node e = tab[i];
                        while (e != null) {
                            action.accept(e);
                            e = e.next;
                        }
                    }
                    if (HashMapIgnoreCase.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final int size() {
            return HashMapIgnoreCase.this.size;
        }

        @Override
        public final void clear() {
            HashMapIgnoreCase.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public final boolean contains(Object o) {
            return HashMapIgnoreCase.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return new ValueSpliterator(HashMapIgnoreCase.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMapIgnoreCase.this.size > 0) {
                Node<V>[] tab = HashMapIgnoreCase.this.table;
                if (HashMapIgnoreCase.this.table != null) {
                    int mc = HashMapIgnoreCase.this.modCount;
                    for (int i = 0; i < tab.length; ++i) {
                        Node e = tab[i];
                        while (e != null) {
                            action.accept(e.value);
                            e = e.next;
                        }
                    }
                    if (HashMapIgnoreCase.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class KeySet
    extends AbstractSet<String> {
        KeySet() {
        }

        @Override
        public final int size() {
            return HashMapIgnoreCase.this.size;
        }

        @Override
        public final void clear() {
            HashMapIgnoreCase.this.clear();
        }

        @Override
        public final Iterator<String> iterator() {
            return new KeyIterator();
        }

        public final boolean contains(String o) {
            return HashMapIgnoreCase.this.containsKey(o);
        }

        public final boolean remove(String key) {
            return HashMapIgnoreCase.this.removeNode(HashMapIgnoreCase.hash(key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<String> spliterator() {
            return new KeySpliterator(HashMapIgnoreCase.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super String> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMapIgnoreCase.this.size > 0) {
                Node<V>[] tab = HashMapIgnoreCase.this.table;
                if (HashMapIgnoreCase.this.table != null) {
                    int mc = HashMapIgnoreCase.this.modCount;
                    for (int i = 0; i < tab.length; ++i) {
                        Node e = tab[i];
                        while (e != null) {
                            action.accept(e.key);
                            e = e.next;
                        }
                    }
                    if (HashMapIgnoreCase.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    static class Node<V>
    implements Map.Entry<String, V> {
        final int hash;
        final String key;
        V value;
        Node<V> next;

        Node(int hash, String key, V value, Node<V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public final String getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Map.Entry e;
            if (o == this) {
                return true;
            }
            return o instanceof Map.Entry && this.key.equalsIgnoreCase((String)(e = (Map.Entry)o).getKey()) && Objects.equals(this.value, e.getValue());
        }
    }
}

