/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.json;

import org.json.JSONException;
import org.json.JSONObject;

public class JSONHelper {
    public static int readFromJSON(JSONObject jsonObj, String propertyName, int defaultValue) throws JSONException {
        int value = -1;
        value = !jsonObj.has(propertyName) ? defaultValue : jsonObj.getInt(propertyName);
        return value;
    }

    public static long readFromJSON(JSONObject jsonObj, String propertyName, long defaultValue) throws JSONException {
        long value = -1L;
        value = !jsonObj.has(propertyName) ? defaultValue : jsonObj.getLong(propertyName);
        return value;
    }

    public static String readFromJSON(JSONObject jsonObj, String propertyName, String defaultValue) throws JSONException {
        String value = "";
        value = !jsonObj.has(propertyName) ? defaultValue : jsonObj.getString(propertyName).intern();
        return value;
    }

    public static boolean readFromJSON(JSONObject jsonObj, String propertyName, boolean defaultValue) throws JSONException {
        boolean value = false;
        value = !jsonObj.has(propertyName) ? defaultValue : jsonObj.getBoolean(propertyName);
        return value;
    }

    public static void writeToJSON(JSONObject jsonObj, String propertyName, int value, int defaultValue) throws JSONException {
        if (value != defaultValue) {
            jsonObj.put(propertyName, value);
        }
    }

    public static void writeToJSON(JSONObject jsonObj, String propertyName, Object value) throws JSONException {
        jsonObj.put(propertyName, value);
    }

    public static void writeToJSON(JSONObject jsonObj, String propertyName, long value, long defaultValue) throws JSONException {
        if (value != defaultValue) {
            jsonObj.put(propertyName, value);
        }
    }

    public static void writeToJSON(JSONObject jsonObj, String propertyName, Double value, Double defaultValue) throws JSONException {
        if (value != defaultValue) {
            jsonObj.put(propertyName, (Object)value);
        }
    }

    public static void writeToJSON(JSONObject jsonObj, String propertyName, String value, String defaultValue) throws JSONException {
        if (value != null && !value.equalsIgnoreCase(defaultValue)) {
            jsonObj.put(propertyName, (Object)value);
        }
    }

    public static void writeToJSON(JSONObject jsonObj, String propertyName, boolean value, boolean defaultValue) throws JSONException {
        if (value != defaultValue) {
            jsonObj.put(propertyName, value);
        }
    }
}

