/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.encrypt;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.shiro.codec.Hex;
import org.apache.shiro.crypto.hash.Sha256Hash;

public class SaltHash {
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final int SALT_BYTE_SIZE = 256;
    private static final int HASH_BYTE_SIZE = 256;
    private static final int PBKDF2_ITERATIONS = 1000;

    private SaltHash() {
    }

    public static String createHash(String password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return SaltHash.createHash(password.toCharArray());
    }

    public static String createHash(char[] password) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] salt = SaltHash.generateRandomSalt();
        byte[] hash = SaltHash.pbkdf2(password, salt, 1000, 256);
        return Hex.encodeToString((byte[])salt) + ":" + Hex.encodeToString((byte[])hash);
    }

    public static boolean validatePassword(String password, String correctHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return SaltHash.validatePassword(password.toCharArray(), correctHash);
    }

    public static boolean validatePassword(char[] password, String correctHash) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String[] params = correctHash.split(":");
        byte[] salt = Hex.decode((String)params[0]);
        String hash = params[1];
        byte[] pbkdf2 = SaltHash.pbkdf2(password, salt, 1000, 256);
        String tmpHash = Hex.encodeToString((byte[])pbkdf2);
        return hash.equals(tmpHash);
    }

    public static byte[] generateRandomSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[256];
        random.nextBytes(salt);
        return salt;
    }

    public static byte[] pbkdf2(String password, byte[] salt, int iterations, int byteSize) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return SaltHash.pbkdf2(password.toCharArray(), salt, iterations, byteSize);
    }

    public static byte[] pbkdf2(char[] password, byte[] salt, int iterations, int byteSize) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password, salt, iterations, byteSize * 8);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
        return skf.generateSecret(spec).getEncoded();
    }

    public static String createSha256Hash(String password) {
        byte[] salt = SaltHash.generateRandomSalt();
        String hash = SaltHash.sha256String(password, salt);
        return Hex.encodeToString((byte[])salt) + ":" + hash;
    }

    public static boolean validateSha256Password(String password, String correctHash) {
        String[] params = correctHash.split(":");
        byte[] salt = Hex.decode((String)params[0]);
        String hash = params[1];
        String tmpHash = SaltHash.sha256String(password, salt);
        return hash.equals(tmpHash);
    }

    public static byte[] sha256Bytes(String password, byte[] salt) {
        return new Sha256Hash((Object)password, (Object)salt).getBytes();
    }

    public static byte[] sha256Bytes(String password, byte[] salt, int iterations) {
        return new Sha256Hash((Object)password, (Object)salt, iterations).getBytes();
    }

    public static String sha256String(String password, byte[] salt) {
        return new Sha256Hash((Object)password, (Object)salt).toString();
    }

    public static String sha256String(String password, byte[] salt, int iterations) {
        return new Sha256Hash((Object)password, (Object)salt, iterations).toString();
    }

    private static boolean slowEquals(byte[] a, byte[] b) {
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    public static void main(String[] args) {
        SaltHash.pbkdf2Test();
    }

    private static void pbkdf2Test() {
        try {
            for (int i = 0; i < 10; ++i) {
                long begin = System.currentTimeMillis();
                String password = Hex.encodeToString((byte[])SaltHash.generateRandomSalt());
                String hash = SaltHash.createHash(password);
                System.out.println("length:[" + hash.length() + "]:" + hash);
                long end = System.currentTimeMillis();
                System.out.println("\u7b2c\u3010" + i + "\u3011\u6b21\u8ba1\u7b97\u82b1\u8d39\u65f6\u95f4\uff1a " + (end - begin) + "ms");
            }
            String password1 = "salt-hash-test";
            byte[] salt = SaltHash.generateRandomSalt();
            byte[] hash1 = SaltHash.pbkdf2(password1, salt, 1000, 256);
            byte[] hash2 = SaltHash.pbkdf2(password1, salt, 500, 256);
            System.out.println("-----" + SaltHash.slowEquals(hash1, hash2));
            boolean failure = false;
            System.out.println("Running tests...");
            for (int i = 0; i < 10; ++i) {
                String wrongPassword;
                String secondHash;
                String password = "" + i;
                String hash = SaltHash.createHash(password);
                if (hash.equals(secondHash = SaltHash.createHash(password))) {
                    System.out.println("FAILURE: TWO HASHES ARE EQUAL!");
                    failure = true;
                }
                if (SaltHash.validatePassword(wrongPassword = "" + (i + 1), hash)) {
                    System.out.println("FAILURE: WRONG PASSWORD ACCEPTED!");
                    failure = true;
                }
                long begin = System.currentTimeMillis();
                if (!SaltHash.validatePassword(password, hash)) {
                    System.out.println("FAILURE: GOOD PASSWORD NOT ACCEPTED!");
                    failure = true;
                }
                long end = System.currentTimeMillis();
                System.out.println("\u7b2c\u3010" + i + "\u3011\u6b21\u6821\u9a8c\u82b1\u8d39\u65f6\u95f4\uff1a " + (end - begin) + "ms");
            }
            if (failure) {
                System.out.println("TESTS FAILED!");
            } else {
                System.out.println("TESTS PASSED!");
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: " + ex);
        }
    }

    private static void sha256Test() {
        try {
            for (int i = 0; i < 10; ++i) {
                long begin = System.nanoTime();
                String password = Hex.encodeToString((byte[])SaltHash.generateRandomSalt());
                String hash = SaltHash.createSha256Hash(password);
                System.out.println("length:[" + hash.length() + "]:" + hash);
                long end = System.nanoTime();
                System.out.println("\u7b2c\u3010" + i + "\u3011\u6b21\u8ba1\u7b97\u82b1\u8d39\u65f6\u95f4\uff1a " + (end - begin) / 1000L + "us");
            }
            String password1 = "salt-hash-test";
            byte[] salt = SaltHash.generateRandomSalt();
            byte[] hash1 = SaltHash.sha256Bytes(password1, salt, 1000);
            byte[] hash2 = SaltHash.sha256Bytes(password1, salt, 500);
            System.out.println("-----" + SaltHash.slowEquals(hash1, hash2));
            boolean failure = false;
            System.out.println("Running tests...");
            for (int i = 0; i < 10; ++i) {
                String wrongPassword;
                String secondHash;
                String password = "" + i;
                String hash = SaltHash.createSha256Hash(password);
                if (hash.equals(secondHash = SaltHash.createSha256Hash(password))) {
                    System.out.println("FAILURE: TWO HASHES ARE EQUAL!");
                    failure = true;
                }
                if (SaltHash.validateSha256Password(wrongPassword = "" + (i + 1), hash)) {
                    System.out.println("FAILURE: WRONG PASSWORD ACCEPTED!");
                    failure = true;
                }
                if (SaltHash.validateSha256Password(password, hash)) continue;
                System.out.println("FAILURE: GOOD PASSWORD NOT ACCEPTED!");
                failure = true;
            }
            if (failure) {
                System.out.println("TESTS FAILED!");
            } else {
                System.out.println("TESTS PASSED!");
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: " + ex);
        }
    }
}

