/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.encrypt;

import com.bokesoft.yes.common.util.Base64;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.Cipher;

public class RSA {
    private static final int ENCRYPT_SEG = 64;
    private static final int DECRYPT_SEG = 128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encryptByPublic(byte[] data, String key) throws Exception {
        byte[] result = null;
        int length = data.length;
        try (ByteArrayOutputStream rout = new ByteArrayOutputStream();){
            if (length == 0) {
                byte[] tmpResult = this.doEncryptByPublic(data, key);
                rout.write(tmpResult);
            } else {
                for (int pos = 0; pos < length; pos += 64) {
                    byte[] tmp = null;
                    tmp = pos + 64 < length ? Arrays.copyOfRange(data, pos, pos + 64) : Arrays.copyOfRange(data, pos, length);
                    byte[] tmpResult = this.doEncryptByPublic(tmp, key);
                    rout.write(tmpResult);
                }
            }
            result = rout.toByteArray();
        }
        return result;
    }

    public byte[] doEncryptByPublic(byte[] data, String key) throws Exception {
        byte[] keyBytes = Base64.decode(key.getBytes());
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey keyInstance = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, keyInstance);
        return cipher.doFinal(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encryptByPrivate(byte[] data, String key) throws Exception {
        byte[] result = null;
        int length = data.length;
        try (ByteArrayOutputStream rout = new ByteArrayOutputStream();){
            if (length == 0) {
                byte[] tmpResult = this.doEncryptByPrivate(data, key);
                rout.write(tmpResult);
            } else {
                for (int pos = 0; pos < length; pos += 64) {
                    byte[] tmp = null;
                    tmp = pos + 64 < length ? Arrays.copyOfRange(data, pos, pos + 64) : Arrays.copyOfRange(data, pos, length);
                    byte[] tmpResult = this.doEncryptByPrivate(tmp, key);
                    rout.write(tmpResult);
                }
            }
            result = rout.toByteArray();
        }
        return result;
    }

    public byte[] doEncryptByPrivate(byte[] data, String key) throws Exception {
        byte[] keyBytes = Base64.decode(key.getBytes());
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey keyInstance = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(1, keyInstance);
        return cipher.doFinal(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptByPrivate(byte[] data, String key) throws Exception {
        byte[] result = null;
        try (ByteArrayOutputStream rout = new ByteArrayOutputStream();){
            int length = data.length;
            for (int pos = 0; pos < length; pos += 128) {
                byte[] tmp = null;
                tmp = pos + 128 < length ? Arrays.copyOfRange(data, pos, pos + 128) : Arrays.copyOfRange(data, pos, length);
                byte[] tmpResult = this.doDecryptByPrivate(tmp, key);
                rout.write(tmpResult);
            }
            result = rout.toByteArray();
        }
        return result;
    }

    public byte[] doDecryptByPrivate(byte[] data, String key) throws Exception {
        byte[] keyBytes = Base64.decode(key.getBytes());
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey keyInstance = keyFactory.generatePrivate(pkcs8KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, keyInstance);
        return cipher.doFinal(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decryptByPublic(byte[] data, String key) throws Exception {
        byte[] result = null;
        try (ByteArrayOutputStream rout = new ByteArrayOutputStream();){
            int length = data.length;
            for (int pos = 0; pos < length; pos += 128) {
                byte[] tmp = null;
                tmp = pos + 128 < length ? Arrays.copyOfRange(data, pos, pos + 128) : Arrays.copyOfRange(data, pos, length);
                byte[] tmpResult = this.doDecryptByPublic(tmp, key);
                rout.write(tmpResult);
            }
            result = rout.toByteArray();
        }
        return result;
    }

    public byte[] doDecryptByPublic(byte[] data, String key) throws Exception {
        byte[] keyBytes = Base64.decode(key.getBytes());
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey keyInstance = keyFactory.generatePublic(x509KeySpec);
        Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
        cipher.init(2, keyInstance);
        return cipher.doFinal(data);
    }
}

