/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.directgraph;

import com.bokesoft.yes.common.directgraph.IGraphNodeContent;
import java.util.LinkedList;

public class GraphNode<T extends IGraphNodeContent> {
    private T content = null;
    private LinkedList<GraphNode<T>> inNodes = null;
    private LinkedList<GraphNode<T>> outNodes = null;
    private Object extendData = null;

    public GraphNode(T content) {
        this.content = content;
    }

    public void addInNode(GraphNode<T> node) {
        if (this.inNodes == null) {
            this.inNodes = new LinkedList();
        }
        this.inNodes.add(node);
    }

    public boolean hasInputNodes() {
        return this.inNodes == null ? false : !this.inNodes.isEmpty();
    }

    public boolean hasNoInputNodes() {
        return this.inNodes == null ? true : this.inNodes.isEmpty();
    }

    public void addOutNode(GraphNode<T> node) {
        if (this.outNodes == null) {
            this.outNodes = new LinkedList();
        }
        this.outNodes.add(node);
    }

    public boolean hasOutNodes() {
        return this.outNodes == null ? false : !this.outNodes.isEmpty();
    }

    public void removeInNode(GraphNode<T> node) {
        this.inNodes.remove(node);
    }

    public void removeOutNode(GraphNode<T> node) {
        this.outNodes.remove(node);
    }

    public void removeAllOutNodes() {
        if (this.outNodes != null) {
            this.outNodes.clear();
        }
    }

    public void setContent(T content) {
        this.content = content;
    }

    public T getContent() {
        return this.content;
    }

    public LinkedList<GraphNode<T>> getInNodes() {
        return this.inNodes;
    }

    public LinkedList<GraphNode<T>> getOutNodes() {
        return this.outNodes;
    }

    public void setExtendData(Object extendData) {
        this.extendData = extendData;
    }

    public Object getExtendData() {
        return this.extendData;
    }
}

