/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.common.directgraph;

import com.bokesoft.yes.common.directgraph.GraphNode;
import com.bokesoft.yes.common.directgraph.IGraphCallback;
import com.bokesoft.yes.common.directgraph.IGraphNodeContent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;

public class Graph<T extends IGraphNodeContent> {
    private ArrayList<GraphNode<T>> nodeArray = new ArrayList();
    private TreeMap<Object, GraphNode<T>> nodeMap = new TreeMap();

    public void add(T content) {
        GraphNode<T> node = new GraphNode<T>(content);
        this.nodeArray.add(node);
        this.nodeMap.put(content.getKey(), node);
    }

    public T get(Object key) {
        GraphNode<T> node = this.nodeMap.get(key);
        if (node != null) {
            return node.getContent();
        }
        return null;
    }

    public void create() {
        Iterator<GraphNode<T>> it = this.nodeArray.iterator();
        GraphNode<T> node = null;
        GraphNode<T> inNode = null;
        String inKey = null;
        while (it.hasNext()) {
            node = it.next();
            List<String> inKeys = node.getContent().getInputKeys();
            if (inKeys == null) continue;
            int length = inKeys.size();
            for (int i = 0; i < length; ++i) {
                inKey = inKeys.get(i);
                inNode = this.nodeMap.get(inKey);
                if (inNode == null) continue;
                inNode.addOutNode(node);
                node.addInNode(inNode);
            }
        }
    }

    public boolean sort(LinkedList<GraphNode<T>> resultList, LinkedList<GraphNode<T>> circleList, IGraphCallback<T> callback) {
        int nodeCount = this.nodeArray.size();
        if (nodeCount == 0) {
            return true;
        }
        Stack<GraphNode<Object>> workStack = new Stack<GraphNode<Object>>();
        Iterator<GraphNode<Object>> it = this.nodeArray.iterator();
        GraphNode node = null;
        while (it.hasNext()) {
            node = it.next();
            if (!node.hasNoInputNodes()) continue;
            workStack.add(node);
        }
        if (workStack.isEmpty()) {
            return false;
        }
        ArrayList<GraphNode<T>> tmpNodeArray = null;
        if (circleList != null) {
            tmpNodeArray = new ArrayList<GraphNode<T>>();
            tmpNodeArray.addAll(this.nodeArray);
        }
        int resultCount = 0;
        Object var10_10 = null;
        while (!workStack.isEmpty()) {
            node = (GraphNode)workStack.pop();
            resultList.addLast(node);
            if (callback != null) {
                callback.process(node);
            }
            if (circleList != null) {
                tmpNodeArray.remove(node);
            }
            ++resultCount;
            if (node.getOutNodes() != null) {
                for (GraphNode<Object> graphNode : node.getOutNodes()) {
                    graphNode.removeInNode(node);
                    if (!graphNode.hasNoInputNodes()) continue;
                    workStack.push(graphNode);
                }
            }
            node.removeAllOutNodes();
        }
        if (resultCount < nodeCount) {
            if (circleList != null) {
                it = tmpNodeArray.iterator();
                while (it.hasNext()) {
                    circleList.add(it.next());
                }
            }
            return false;
        }
        return true;
    }
}

