/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.bpm;

import com.bokesoft.yes.bpm.service.cmd.DownloadProcessGraphCmd;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoadAuditRecord {
    public static final String PROCESS_KEY = "processKey";
    public static final String VERSION = "version";
    public static final String TRANS_PATH = "transPath";
    public static final String AUDIT_LOG = "auditLog";
    public static final String WORKITEM_ID = "workItemID";
    public static final String WORKITEM_NAME = "workitemName";
    public static final String CREATE_TIME = "creatTime";
    public static final String FINISH_TIME = "finishTime";
    public static final String AUDIT_RESULT = "auditResult";
    public static final String USER_INFO = "userInfo";
    public static final String WORKITEM_STATE = "workitemState";
    public static final String OPERATOR_ID = "operatorID";
    public static final String INSTANCE_STATE = "instanceState";
    public static final String LOG_INDEX = "logIndex";
    private String processKey = "";
    private Integer verID = -1;
    private Long OID = -1L;

    public LoadAuditRecord(String string, Integer n2, Long l2) {
        this.processKey = string;
        this.verID = n2;
        this.OID = l2;
    }

    public JSONObject load(DefaultContext defaultContext) throws Throwable {
        JSONObject jSONObject = new JSONObject();
        DownloadProcessGraphCmd downloadProcessGraphCmd = new DownloadProcessGraphCmd();
        downloadProcessGraphCmd.setProcessKey(this.processKey);
        downloadProcessGraphCmd.setVerID(this.verID);
        downloadProcessGraphCmd.setOID(this.OID);
        downloadProcessGraphCmd = (JSONObject)downloadProcessGraphCmd.doCmd(defaultContext);
        jSONObject.put(PROCESS_KEY, (Object)downloadProcessGraphCmd.optString("key"));
        jSONObject.put(VERSION, downloadProcessGraphCmd.optInt(VERSION));
        jSONObject.put(TRANS_PATH, (Object)downloadProcessGraphCmd.optJSONObject("transpath"));
        jSONObject.put(AUDIT_LOG, (Object)this.loadBPMLog(defaultContext));
        return jSONObject;
    }

    private JSONArray loadBPMLog(DefaultContext defaultContext) throws Throwable {
        JSONArray jSONArray = new JSONArray();
        defaultContext = defaultContext.getDBManager();
        Object object = "select BPM_Log.workItemID,workItemName,creatTime,finishTime,auditResult,userInfo,WorkitemState,BPM_Log.operatorID,InstanceState,LogIndex from BPM_Log join BPM_Instance on BPM_Log.InstanceID=BPM_Instance.InstanceID where workItemID in(select workitemID from BPM_WorkitemInfo where instanceID in(select instanceID from BPM_Instance where OID=?))order by LogIndex desc";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = defaultContext.preparedQueryStatement((String)object);
            PSArgs pSArgs = new PSArgs();
            pSArgs.addLongArg(this.OID);
            resultSet = defaultContext.executeQuery(preparedStatement, (String)object, (QueryArguments)pSArgs);
            while (resultSet.next()) {
                defaultContext = new JSONObject();
                defaultContext.put(WORKITEM_ID, resultSet.getLong(1));
                defaultContext.put(WORKITEM_NAME, (Object)resultSet.getString(2));
                object = resultSet.getTimestamp(3);
                if (object != null) {
                    defaultContext.put(CREATE_TIME, (Object)((Timestamp)object).toString());
                }
                if ((object = resultSet.getTimestamp(4)) != null) {
                    defaultContext.put(FINISH_TIME, (Object)((Timestamp)object).toString());
                }
                defaultContext.put(AUDIT_RESULT, resultSet.getInt(5));
                defaultContext.put(USER_INFO, (Object)resultSet.getString(6));
                defaultContext.put(WORKITEM_STATE, resultSet.getInt(7));
                defaultContext.put(OPERATOR_ID, resultSet.getLong(8));
                defaultContext.put(INSTANCE_STATE, resultSet.getInt(9));
                defaultContext.put(LOG_INDEX, resultSet.getInt(10));
                jSONArray.put((Object)defaultContext);
            }
        }
        finally {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return jSONArray;
    }
}

