/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.node;

import com.bokesoft.yes.bpm.engine.common.BPMUtil;
import com.bokesoft.yes.bpm.engine.data.row.RNode;
import com.bokesoft.yes.bpm.engine.data.virtual.VirtualInstanceData;
import com.bokesoft.yes.bpm.engine.instance.CreateNodeUtil;
import com.bokesoft.yes.bpm.engine.instance.VirtualInstance;
import com.bokesoft.yes.bpm.engine.node.ExecNode;
import com.bokesoft.yes.bpm.interpreter.NodeFactoryProxy;
import com.bokesoft.yes.bpm.interpreter.defaultproxy.DefaultProxy;
import com.bokesoft.yes.gop.bpm.IExecutionContext;
import com.bokesoft.yes.gop.bpm.handler.IInlineHandler;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.node.MetaInline;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class ExecInline
extends ExecNode
implements IInlineHandler {
    private MetaInline inline = null;
    private VirtualInstance inlineInstance = null;

    public ExecInline(VirtualInstance virtualInstance, MetaNode metaNode) {
        super(virtualInstance, metaNode);
        this.inline = (MetaInline)metaNode;
    }

    public VirtualInstance initInlineInstance(NodeFactoryProxy nodeFactoryProxy, BPMContext bPMContext) throws Throwable {
        MetaProcess metaProcess;
        int n2 = this.node.getID();
        Object object = this.instance.getInstanceData().getNode().getNodeData(n2, bPMContext.getDBManager());
        int n3 = ((RNode)object).getInlineVersion();
        bPMContext.setInlineNode(this);
        String string = BPMUtil.getInlineProcessKey(this.inline, (DefaultContext)bPMContext, (RNode)object);
        if (string == null || string.length() == 0) {
            return null;
        }
        ((RNode)object).setInlineProcessKey(string);
        if (n3 > 0) {
            metaProcess = BPMUtil.getProcessDefinationBy(bPMContext.getVE(), string, n3);
        } else {
            metaProcess = BPMUtil.getProcessDefinationByDeployKey(bPMContext.getVE(), string);
            ((RNode)object).setInlineVersion(metaProcess.getVersion());
        }
        object = this.instance.getBPMInstance().getInstanceData().createVirtualInstanceData(this.getID());
        this.inlineInstance = new VirtualInstance(metaProcess, nodeFactoryProxy, (VirtualInstanceData)object, this.instance.getBPMInstance(), bPMContext);
        this.inlineInstance.setInlineNode(this);
        return this.inlineInstance;
    }

    public void embedInstanceEnd(BPMContext bPMContext) throws Throwable {
        int n2 = this.instance.applyNewTokenID();
        this.instance.getInstanceData().getToken().createNewToken(n2, this.getID());
        bPMContext.setActiveTokenID(n2);
        this.output(bPMContext);
    }

    public void startInlineInstance(IExecutionContext iExecutionContext) throws Throwable {
        this.inlineInstance.startInstance((BPMContext)iExecutionContext);
    }

    public boolean checkStraightEmbedNodeID(IExecutionContext iExecutionContext) throws Throwable {
        return ((BPMContext)iExecutionContext).getStraightEmbedNodeID() > 0;
    }

    public void straightEmbedNode(IExecutionContext iExecutionContext) throws Throwable {
        ExecNode execNode;
        int n2 = this.inlineInstance.applyNewTokenID();
        this.inlineInstance.getInstanceData().getToken().createNewToken(n2, -1);
        iExecutionContext.setActiveTokenID(n2);
        n2 = ((BPMContext)iExecutionContext).getStraightEmbedNodeID();
        try {
            execNode = this.inlineInstance.getNodeByID(n2);
        }
        catch (Throwable throwable) {
            execNode = this.createNode(iExecutionContext);
        }
        execNode.input(iExecutionContext);
    }

    private ExecNode createNode(IExecutionContext iExecutionContext) throws Throwable {
        MetaNode metaNode = this.inlineInstance.getMetaNodeByID(((BPMContext)iExecutionContext).getStraightEmbedNodeID());
        return new CreateNodeUtil(iExecutionContext, this.inlineInstance).createNode(metaNode);
    }

    public void handleInlineNode(IExecutionContext iExecutionContext) throws Throwable {
        VirtualInstance virtualInstance = this.initInlineInstance(new DefaultProxy(), (BPMContext)iExecutionContext);
        virtualInstance.checkAndCreateNodeData(iExecutionContext.getDBManager());
        this.instance.getBPMInstance().putInstanceMap(this.inline.getID(), virtualInstance);
    }

    public VirtualInstance getInlineVirtualInstance() {
        return this.inlineInstance;
    }

    public void cleanInlineNodeContext(IExecutionContext iExecutionContext) throws Throwable {
        ((BPMContext)iExecutionContext).setInlineNode(null);
    }
}

