/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.data.table;

import com.bokesoft.yes.bpm.common.exception.BPMError;
import com.bokesoft.yes.bpm.engine.common.StatusUtil;
import com.bokesoft.yes.bpm.engine.data.OIDRef;
import com.bokesoft.yes.bpm.engine.data.row.RTransaction;
import com.bokesoft.yes.bpm.engine.data.table.BPMTable;
import com.bokesoft.yes.bpm.workitem.data.SqlHelper;
import com.bokesoft.yes.mid.cache.RowKey;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.mid.connection.IDBManager;

public class TTransaction
extends BPMTable<RTransaction> {
    private static final String Source = "select * from  BPM_Transaction where instanceID=? order by transactionID desc";
    private static final String Delete = "delete from BPM_Transaction where instanceID=? and transactionID=?";
    private static final String Insert = "insert into  BPM_Transaction  (instanceID,OID,workitemID,transactionID,operatorID,workitemRevoke,fieldKey,fieldValue,statusValue) values(?,?,?,?,?,?,?,?,?)";
    private static final String DeleteAll = "delete from BPM_Transaction  where instanceID=?";

    public TTransaction(Long l2, OIDRef oIDRef) {
        super(l2, oIDRef);
    }

    @Override
    public String getDataSourceSql() {
        return Source;
    }

    @Override
    public String getDeleteSql() {
        return Delete;
    }

    @Override
    public String getInsertSql() {
        return Insert;
    }

    @Override
    protected String getDeleteAllSql() {
        return DeleteAll;
    }

    @Override
    public RTransaction createEmptyRow() {
        return new RTransaction(this.instanceID);
    }

    public QueryArguments getDeletePSArgs(IDBManager iDBManager, RTransaction rTransaction) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        SqlHelper.dealInstanceID2ConditionArge(iDBManager, this.instanceID, this.OID, pSArgs);
        pSArgs.addIntArg(rTransaction.getTransactionID());
        return pSArgs;
    }

    public QueryArguments getUpdatePSArgs(IDBManager iDBManager, RTransaction rTransaction) throws Throwable {
        return null;
    }

    @Override
    public QueryArguments getInsertPSArgs(RTransaction rTransaction) throws Throwable {
        PSArgs pSArgs = new PSArgs();
        pSArgs.addLongArg(this.instanceID);
        pSArgs.addLongArg(Long.valueOf(this.OID.get()));
        pSArgs.addLongArg(rTransaction.getWorkitemID());
        pSArgs.addIntArg(rTransaction.getTransactionID());
        pSArgs.addLongArg(rTransaction.getOperatorID());
        pSArgs.addIntArg(Integer.valueOf(rTransaction.isworkitemRevoke() ? 1 : 0));
        pSArgs.addStringArg(rTransaction.getFieldKey());
        pSArgs.addStringArg(rTransaction.getFieldValue());
        pSArgs.addIntArg(rTransaction.getStatusValue());
        return pSArgs;
    }

    public Integer getTransactionIDByWorkitemID(Long l2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        for (RTransaction rTransaction : this.rowList) {
            if (!rTransaction.getWorkitemID().equals(l2)) continue;
            return rTransaction.getTransactionID();
        }
        return -1;
    }

    public int rollbackToWorkitem(BPMContext bPMContext, Long object, Boolean object22, IDBManager iDBManager) throws Throwable {
        this.load(iDBManager);
        int n2 = -1;
        Integer.valueOf(-1);
        Integer n3 = null;
        for (RTransaction rTransaction : this.rowList) {
            if (!rTransaction.getWorkitemID().equals(object) || rTransaction.getTransactionID() < 0) continue;
            n2 = rTransaction.getTransactionID();
            n3 = rTransaction.getStatusValue();
            break;
        }
        if (n2 < 0) {
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)17, (Object[])new Object[0]);
        }
        for (RTransaction rTransaction : this.rowList) {
            if (rTransaction.getTransactionID() < n2) continue;
            StatusUtil.changeFieldValue(bPMContext, rTransaction.getFieldKey(), rTransaction.getFieldValue());
        }
        if (n3 >= 0) {
            StatusUtil.changeStatusValue(bPMContext, n3);
        }
        if (!object22.booleanValue()) {
            return n2;
        }
        long l2 = bPMContext.getEnv().getUserID();
        for (Object object22 : this.rowList) {
            if (((RTransaction)((Object)object22)).getTransactionID() < n2 || ((RTransaction)((Object)object22)).isworkitemRevoke() && ((RTransaction)((Object)object22)).getOperatorID() == l2) continue;
            throw BPMError.getBPMError((ILocale)bPMContext.getEnv(), (int)17, (Object[])new Object[0]);
        }
        return n2;
    }

    public Integer getStatusByWorkitemID(Long l2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        for (RTransaction rTransaction : this.rowList) {
            if (!rTransaction.getWorkitemID().equals(l2)) continue;
            return rTransaction.getStatusValue();
        }
        return -1;
    }

    public void deleteData(int n2, IDBManager object) throws Throwable {
        this.load((IDBManager)object);
        for (RTransaction rTransaction : this.rowList) {
            if (rTransaction.getTransactionID() < n2) continue;
            rTransaction.setDeleted();
        }
    }

    public RTransaction getTransaction(int n2, IDBManager iDBManager) throws Throwable {
        RowKey rowKey = new RowKey();
        rowKey.put((Object)this.instanceID);
        rowKey.put((Object)n2);
        RTransaction rTransaction = (RTransaction)this.getRow(rowKey);
        if (rTransaction == null) {
            this.load(iDBManager);
            rTransaction = (RTransaction)this.getRow(rowKey);
        }
        return rTransaction;
    }
}

