/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.engine.data;

import com.bokesoft.yes.bpm.engine.data.OIDRef;
import com.bokesoft.yes.bpm.engine.data.rollback.RollBackTable;
import com.bokesoft.yes.bpm.engine.data.table.BPMTable;
import com.bokesoft.yes.bpm.engine.data.table.TAttachment;
import com.bokesoft.yes.bpm.engine.data.table.TAttachmentRB;
import com.bokesoft.yes.bpm.engine.data.table.TAuditRetLog;
import com.bokesoft.yes.bpm.engine.data.table.TDirectTransition;
import com.bokesoft.yes.bpm.engine.data.table.TDirectTransitionRB;
import com.bokesoft.yes.bpm.engine.data.table.TEventLog;
import com.bokesoft.yes.bpm.engine.data.table.TFocusInstance;
import com.bokesoft.yes.bpm.engine.data.table.TFocusInstanceRB;
import com.bokesoft.yes.bpm.engine.data.table.TFocusedInstance;
import com.bokesoft.yes.bpm.engine.data.table.TFocusedInstanceRB;
import com.bokesoft.yes.bpm.engine.data.table.TInstance;
import com.bokesoft.yes.bpm.engine.data.table.TLog;
import com.bokesoft.yes.bpm.engine.data.table.TLogRB;
import com.bokesoft.yes.bpm.engine.data.table.TNode;
import com.bokesoft.yes.bpm.engine.data.table.TNodeParticipator;
import com.bokesoft.yes.bpm.engine.data.table.TNodeParticipatorRB;
import com.bokesoft.yes.bpm.engine.data.table.TNodeRB;
import com.bokesoft.yes.bpm.engine.data.table.TRefDoc;
import com.bokesoft.yes.bpm.engine.data.table.TState;
import com.bokesoft.yes.bpm.engine.data.table.TStateRB;
import com.bokesoft.yes.bpm.engine.data.table.TStepInfo;
import com.bokesoft.yes.bpm.engine.data.table.TStepInfoRB;
import com.bokesoft.yes.bpm.engine.data.table.TTimerEvent;
import com.bokesoft.yes.bpm.engine.data.table.TTimerEventRB;
import com.bokesoft.yes.bpm.engine.data.table.TToken;
import com.bokesoft.yes.bpm.engine.data.table.TTokenRB;
import com.bokesoft.yes.bpm.engine.data.table.TTransaction;
import com.bokesoft.yes.bpm.engine.data.table.TTransitTo;
import com.bokesoft.yes.bpm.engine.data.table.TTransitToRB;
import com.bokesoft.yes.bpm.engine.data.table.TWorkitemInfo;
import com.bokesoft.yes.bpm.engine.data.table.TWorkitemInfoRB;
import com.bokesoft.yes.bpm.engine.data.virtual.VirtualInstanceData;
import com.bokesoft.yes.bpm.timer.TimerProxy;
import com.bokesoft.yes.bpm.workitem.data.RWorkitem;
import com.bokesoft.yes.bpm.workitem.data.WorkitemDataContainer;
import com.bokesoft.yigo.bpm.common.BPMContext;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;

public class InstanceData {
    private final Long instanceID;
    private TInstance instance;
    private TTransaction transaction;
    private TLog log;
    private TNode node;
    private TToken token;
    private TWorkitemInfo workitemInfo;
    private TTimerEvent timerEvent;
    private TFocusInstance focusInstance;
    private TFocusedInstance focusedInstance;
    private TState state;
    private TStepInfo stepInfo;
    private TDirectTransition directTransition;
    private TAttachment attachment;
    private TEventLog eventLog;
    private TTransitTo transitTo;
    private TRefDoc refDoc;
    private TNodeParticipator nodeParticipator;
    private TAuditRetLog auditRetLog;
    private WorkitemDataContainer workitemData;
    private ArrayList<BPMTable<?>> tableList = new ArrayList();
    private TLogRB logRB;
    private TNodeRB nodeRB;
    private TTokenRB tokenRB;
    private TWorkitemInfoRB workitemInfoRB;
    private TTimerEventRB timerEventRB;
    private TFocusInstanceRB focusInstanceRB;
    private TFocusedInstanceRB focusedInstanceRB;
    private TStepInfoRB stepInfoRB;
    private TStateRB stateRB;
    private TDirectTransitionRB directTransitionRB;
    private TAttachmentRB attachmentRB;
    private TTransitToRB transitToRB;
    private TNodeParticipatorRB nodeParticipatorRB;
    private ArrayList<RollBackTable<?, ?>> rbDataTableList = new ArrayList();
    private boolean rollbackData = false;
    private int rollbackTransactionID = -1;
    private boolean deleteData = false;
    final OIDRef OID;

    public InstanceData(Long l2, Long l3) {
        this.OID = new OIDRef(l3);
        this.instanceID = l2;
        this.instance = new TInstance(l2, this.OID);
        this.node = new TNode(l2, this.OID);
        this.stepInfo = new TStepInfo(l2, this.OID);
        this.token = new TToken(l2, this.OID);
        this.workitemInfo = new TWorkitemInfo(l2, this.OID);
        this.timerEvent = new TTimerEvent(l2, this.OID);
        this.focusInstance = new TFocusInstance(l2, this.OID);
        this.focusedInstance = new TFocusedInstance(l2, this.OID);
        this.log = new TLog(l2, this.OID);
        this.transaction = new TTransaction(l2, this.OID);
        this.state = new TState(l2, this.OID);
        this.directTransition = new TDirectTransition(l2, this.OID);
        this.attachment = new TAttachment(l2, this.OID);
        this.eventLog = new TEventLog(l2, this.OID);
        this.refDoc = new TRefDoc(l2, this.OID);
        this.transitTo = new TTransitTo(l2, this.OID);
        this.auditRetLog = new TAuditRetLog(l2, this.OID);
        this.nodeParticipator = new TNodeParticipator(l2, this.OID);
        this.workitemData = new WorkitemDataContainer(this.OID);
        this.tableList.add(this.instance);
        this.tableList.add(this.node);
        this.tableList.add(this.stepInfo);
        this.tableList.add(this.token);
        this.tableList.add(this.workitemInfo);
        this.tableList.add(this.timerEvent);
        this.tableList.add(this.focusInstance);
        this.tableList.add(this.focusedInstance);
        this.tableList.add(this.log);
        this.tableList.add(this.transaction);
        this.tableList.add(this.state);
        this.tableList.add(this.directTransition);
        this.tableList.add(this.attachment);
        this.tableList.add(this.eventLog);
        this.tableList.add(this.refDoc);
        this.tableList.add(this.transitTo);
        this.tableList.add(this.auditRetLog);
        this.tableList.add(this.nodeParticipator);
        this.logRB = new TLogRB(l2, this.OID);
        this.nodeRB = new TNodeRB(l2, this.OID);
        this.tokenRB = new TTokenRB(l2, this.OID);
        this.workitemInfoRB = new TWorkitemInfoRB(l2, this.OID);
        this.timerEventRB = new TTimerEventRB(l2, this.OID);
        this.focusInstanceRB = new TFocusInstanceRB(l2, this.OID);
        this.focusedInstanceRB = new TFocusedInstanceRB(l2, this.OID);
        this.stateRB = new TStateRB(l2, this.OID);
        this.stepInfoRB = new TStepInfoRB(l2, this.OID);
        this.directTransitionRB = new TDirectTransitionRB(l2, this.OID);
        this.attachmentRB = new TAttachmentRB(l2, this.OID);
        this.transitToRB = new TTransitToRB(l2, this.OID);
        this.nodeParticipatorRB = new TNodeParticipatorRB(l2, this.OID);
        this.rbDataTableList.add(this.logRB);
        this.rbDataTableList.add(this.nodeRB);
        this.rbDataTableList.add(this.tokenRB);
        this.rbDataTableList.add(this.workitemInfoRB);
        this.rbDataTableList.add(this.timerEventRB);
        this.rbDataTableList.add(this.focusInstanceRB);
        this.rbDataTableList.add(this.focusedInstanceRB);
        this.rbDataTableList.add(this.stateRB);
        this.rbDataTableList.add(this.stepInfoRB);
        this.rbDataTableList.add(this.directTransitionRB);
        this.rbDataTableList.add(this.attachmentRB);
        this.rbDataTableList.add(this.transitToRB);
        this.rbDataTableList.add(this.nodeParticipatorRB);
    }

    public void load(IDBManager iDBManager) throws Throwable {
        iDBManager.setRowLock("BPM_Instance", "instanceID", this.instanceID);
        Iterator<BPMTable<?>> iterator = this.tableList.iterator();
        while (iterator.hasNext()) {
            iterator.next().load(iDBManager);
        }
    }

    public void deleteUnfinishedWorkitemData(IDBManager iDBManager) throws Throwable {
        this.workitemData.deleteUnfinishedData(iDBManager, this.workitemInfo.getAllIDSet(iDBManager));
    }

    public void markUnfinishedWorkitemData(IDBManager iDBManager, int n2) throws Throwable {
        this.workitemData.markUnfinishedData(iDBManager, this.workitemInfo.getAllIDSet(iDBManager), n2);
    }

    public TreeSet<Long> getMarkedWorkitemData(IDBManager iDBManager, int n2) throws Throwable {
        return this.workitemData.getMarkedData(iDBManager, this.workitemInfo.getAllIDSet(iDBManager), n2);
    }

    public void removeUnfinishedWorkitemData(IDBManager iDBManager) throws Throwable {
        this.workitemData.removeUnfinishedData(iDBManager, this.workitemInfo.getAllIDSet(iDBManager));
    }

    public void recoverHidedWorkitemData(IDBManager iDBManager) throws Throwable {
        this.workitemData.recoverHidedData(iDBManager, this.workitemInfo.getAllIDSet(iDBManager));
    }

    public VirtualInstanceData createVirtualInstanceData(int n2) {
        VirtualInstanceData virtualInstanceData = new VirtualInstanceData(this.instanceID, n2);
        virtualInstanceData.setNode(this.node.split(n2));
        virtualInstanceData.setStepInfo(this.stepInfo.split(n2));
        virtualInstanceData.setToken(this.token.split(n2));
        virtualInstanceData.setWorkitemInfo(this.workitemInfo.split(n2));
        virtualInstanceData.setTimerEvent(this.timerEvent.split(n2));
        virtualInstanceData.setFocusInstance(this.focusInstance.split(n2));
        virtualInstanceData.setState(this.state.split(n2));
        virtualInstanceData.setDirectTransition(this.directTransition.split(n2));
        virtualInstanceData.setAuditRetLog(this.auditRetLog.split(n2));
        virtualInstanceData.setTransitTo(this.transitTo.split(n2));
        virtualInstanceData.setNodeParticipator(this.nodeParticipator.split(n2));
        return virtualInstanceData;
    }

    public void rollbackToWorkitem(BPMContext bPMContext, Long l2, Boolean bl) throws Throwable {
        int n2 = this.transaction.rollbackToWorkitem(bPMContext, l2, bl, bPMContext.getDBManager());
        if (n2 > 0) {
            this.rollbackData = true;
            this.rollbackTransactionID = n2;
            TimerProxy.removeNodeData(bPMContext.getDBManager(), this.instanceID, n2);
        }
    }

    public void deleteInstance(BPMContext bPMContext) throws Throwable {
        this.deleteData = true;
        TimerProxy.removeInstanceData(bPMContext.getDBManager(), this.instanceID);
    }

    private void rollback(IDBManager iDBManager) throws Throwable {
        Iterator<BPMTable> iterator = this.rbDataTableList.iterator();
        while (iterator.hasNext()) {
            iterator.next().load(iDBManager);
        }
        if (this.instance.getData().getInstanceState() == 2) {
            this.instance.getData().setInstanceState(1);
            this.instance.getData().setEndTime(null);
            this.instance.getData().setCostTime(-1L);
        }
        this.transaction.deleteData(this.rollbackTransactionID, iDBManager);
        this.logRB.rollback(this.log, this.rollbackTransactionID, iDBManager);
        this.nodeRB.rollback(this.node, this.rollbackTransactionID, iDBManager);
        this.tokenRB.rollback(this.token, this.rollbackTransactionID, iDBManager);
        this.workitemInfoRB.rollback(this.workitemInfo, this.rollbackTransactionID, iDBManager);
        this.timerEventRB.rollback(this.timerEvent, this.rollbackTransactionID, iDBManager);
        this.focusInstanceRB.rollback(this.focusInstance, this.rollbackTransactionID, iDBManager);
        this.focusedInstanceRB.rollback(this.focusedInstance, this.rollbackTransactionID, iDBManager);
        this.stateRB.rollback(this.state, this.rollbackTransactionID, iDBManager);
        this.stepInfoRB.rollback(this.stepInfo, this.rollbackTransactionID, iDBManager);
        this.directTransitionRB.rollback(this.directTransition, this.rollbackTransactionID, iDBManager);
        this.attachmentRB.rollback(this.attachment, this.rollbackTransactionID, iDBManager);
        this.transitToRB.rollback(this.transitTo, this.rollbackTransactionID, iDBManager);
        this.nodeParticipatorRB.rollback(this.nodeParticipator, this.rollbackTransactionID, iDBManager);
        this.workitemData.rollback(iDBManager, this.rollbackTransactionID, this.workitemInfo.getAllIDSet(iDBManager));
        iterator = this.tableList.iterator();
        while (iterator.hasNext()) {
            iterator.next().submit(iDBManager);
        }
        iterator = this.rbDataTableList.iterator();
        while (iterator.hasNext()) {
            iterator.next().submit(iDBManager);
        }
        this.rollbackData = false;
    }

    private void deleteInstanceData(IDBManager iDBManager) throws Throwable {
        Iterator<RollBackTable<?, ?>> iterator = this.workitemInfo.getAllIDSet(iDBManager);
        this.workitemData.deleteAll(iDBManager, (TreeSet<Long>)((Object)iterator));
        iterator = this.tableList.iterator();
        while (iterator.hasNext()) {
            ((BPMTable)((Object)iterator.next())).deleteAll(iDBManager);
        }
        iterator = this.rbDataTableList.iterator();
        while (iterator.hasNext()) {
            iterator.next().deleteAll(iDBManager);
        }
    }

    public void commit(DefaultContext defaultContext) throws Throwable {
        Object object2;
        IDBManager iDBManager = defaultContext.getDBManager();
        if (this.rollbackData) {
            this.rollback(iDBManager);
            return;
        }
        if (this.deleteData) {
            this.deleteInstanceData(iDBManager);
            return;
        }
        for (Object object2 : this.workitemData.getWorkitemList()) {
            if (object2.isNew() || object2.isModified()) {
                this.log.syncDataFromWorkitem((RWorkitem)((Object)object2), defaultContext.getDBManager());
                continue;
            }
            if (!object2.isDeleted()) continue;
            object2.setFinishTime(new Timestamp(defaultContext.getDBManager().getCurTime()));
            object2.setWorkitemState(4);
            this.workitemData.deleteParticipatorData(object2.getWorkItemID());
            this.log.syncDataFromWorkitem((RWorkitem)((Object)object2), defaultContext.getDBManager());
        }
        int n2 = this.instance.applyNewTransactionID();
        this.logRB.createRBData(this.log, n2);
        this.nodeRB.createRBData(this.node, n2);
        this.tokenRB.createRBData(this.token, n2);
        this.workitemInfoRB.createRBData(this.workitemInfo, n2);
        this.timerEventRB.createRBData(this.timerEvent, n2);
        this.focusInstanceRB.createRBData(this.focusInstance, n2);
        this.focusedInstanceRB.createRBData(this.focusedInstance, n2);
        this.stateRB.createRBData(this.state, n2);
        this.stepInfoRB.createRBData(this.stepInfo, n2);
        this.directTransitionRB.createRBData(this.directTransition, n2);
        this.attachmentRB.createRBData(this.attachment, n2);
        this.transitToRB.createRBData(this.transitTo, n2);
        this.nodeParticipatorRB.createRBData(this.nodeParticipator, n2);
        object2 = this.tableList.iterator();
        while (object2.hasNext()) {
            ((BPMTable)((Object)object2.next())).submit(iDBManager);
        }
        object2 = this.rbDataTableList.iterator();
        while (object2.hasNext()) {
            ((BPMTable)((Object)object2.next())).submit(iDBManager);
        }
        this.workitemData.submit(iDBManager, n2);
    }

    public Long getInstanceID() {
        return this.instanceID;
    }

    public TInstance getInstance() {
        return this.instance;
    }

    public TFocusedInstance getFocusedInstance() {
        return this.focusedInstance;
    }

    public TTransaction getTransaction() {
        return this.transaction;
    }

    public TFocusInstance getFocusInstance() {
        return this.focusInstance;
    }

    public TToken getToken() {
        return this.token;
    }

    public TWorkitemInfo getWorkitemInfo() {
        return this.workitemInfo;
    }

    public TDirectTransition getDirectTransition() {
        return this.directTransition;
    }

    public TLog getLog() {
        return this.log;
    }

    public WorkitemDataContainer getWorkitemData() {
        return this.workitemData;
    }

    public TState getState() {
        return this.state;
    }

    public TStepInfo getStepInfo() {
        return this.stepInfo;
    }

    public TNode getNode() {
        return this.node;
    }

    public TRefDoc getRefDoc() {
        return this.refDoc;
    }

    public TTimerEvent getTimerEvent() {
        return this.timerEvent;
    }

    public TAttachment getAttachment() {
        return this.attachment;
    }

    public TEventLog getEventLog() {
        return this.eventLog;
    }

    public TTransitTo getTransitTo() {
        return this.transitTo;
    }

    public TNodeParticipator getNodeParticipator() {
        return this.nodeParticipator;
    }
}

