/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.meta.transform.graph;

import com.bokesoft.yes.bpm.meta.transform.graph.TransBPMPath;
import com.bokesoft.yigo.meta.bpm.process.MetaProcess;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaNodeGraphic;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimline;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineCollection;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlinePosition;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaSwimlineSize;
import com.bokesoft.yigo.meta.bpm.process.attribute.MetaTransitionGraphic;
import com.bokesoft.yigo.meta.bpm.process.node.MetaNode;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaAssociation;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaExceptionFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaSequenceFlow;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransition;
import com.bokesoft.yigo.meta.bpm.process.transition.MetaTransitionCollection;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class BPMCompleteGraphConvertor {
    public JSONObject toJSON(MetaProcess definition, TransBPMPath transBPMPath) throws Throwable {
        JSONObject json = new JSONObject();
        json.put("key", (Object)definition.getKey());
        json.put("caption", (Object)definition.getCaption());
        json.put("version", definition.getVersion());
        if (!definition.isEmpty()) {
            JSONArray jsonArray = new JSONArray();
            JSONArray jsonArraySwims = new JSONArray();
            Iterator it = definition.entryIterator();
            MetaSwimlineCollection swimlineCollection = definition.getSwimlineCollection();
            Iterator swimIt = swimlineCollection.entryIterator();
            Map.Entry entry = null;
            MetaNode node = null;
            Map.Entry swim_entry = null;
            MetaSwimline swimLine = null;
            while (it.hasNext()) {
                entry = (Map.Entry)it.next();
                node = (MetaNode)entry.getValue();
                jsonArray.put((Object)this.node2JSON(node, transBPMPath));
            }
            while (swimIt.hasNext()) {
                swim_entry = (Map.Entry)swimIt.next();
                swimLine = (MetaSwimline)swim_entry.getValue();
                jsonArraySwims.put((Object)this.swim2JSON(swimLine));
            }
            json.put("nodes", (Object)jsonArray);
            json.put("swims", (Object)jsonArraySwims);
            if (transBPMPath != null) {
                json.put("transpath", (Object)transBPMPath.toJSON());
            }
        }
        return json;
    }

    private JSONObject transition2JSON(MetaNode node, MetaTransition transition, TransBPMPath transBPMPath) {
        JSONObject json = new JSONObject();
        MetaTransitionGraphic graph = transition.getGraphic();
        json.put("id", transition.getID());
        json.put("key", (Object)transition.getKey());
        json.put("line-style", graph.getLineStyle());
        json.put("target-node-key", (Object)transition.getTargetNodeKey());
        json.put("style", (Object)graph.getStyle());
        if (transition.getTargetNode() != null) {
            json.put("target-node-id", transition.getTargetNode().getID());
            if (transBPMPath != null && transBPMPath.containPath(node.getID(), transition.getTargetNode().getID())) {
                json.put("state", 2);
            }
        }
        if (transition instanceof MetaAssociation) {
            json.put("tag-name", (Object)"association");
        } else if (transition instanceof MetaExceptionFlow) {
            json.put("tag-name", (Object)"exception-flow");
        } else if (transition instanceof MetaSequenceFlow) {
            json.put("tag-name", (Object)"sequence-flow");
        }
        return json;
    }

    private JSONObject node2JSON(MetaNode node, TransBPMPath transBPMPath) {
        JSONObject json = new JSONObject();
        json.put("id", node.getID());
        json.put("key", (Object)node.getKey());
        MetaNodeGraphic graph = node.getNodeGraphic();
        json.put("x", (Object)graph.getX());
        json.put("y", (Object)graph.getY());
        json.put("width", (Object)graph.getWidth());
        json.put("height", (Object)graph.getHeight());
        json.put("image", (Object)graph.getImage());
        json.put("image_past", (Object)graph.getPastImage());
        json.put("image_last", (Object)graph.getLastImage());
        json.put("caption", (Object)node.getCaption());
        json.put("style", (Object)graph.getStyle());
        if (transBPMPath != null && transBPMPath.getLast().contains(node.getID())) {
            json.put("state", 3);
        }
        int nodeType = node.getNodeType();
        switch (nodeType) {
            case 0: {
                json.put("tag-name", (Object)"begin");
                break;
            }
            case 1: {
                json.put("tag-name", (Object)"end");
                break;
            }
            case 2: {
                json.put("tag-name", (Object)"user-task");
                break;
            }
            case 3: {
                json.put("tag-name", (Object)"audit");
                break;
            }
            case 4: {
                json.put("tag-name", (Object)"countersign");
                break;
            }
            case 5: {
                json.put("tag-name", (Object)"decision");
                break;
            }
            case 6: {
                json.put("tag-name", (Object)"sub-process");
                break;
            }
            case 7: {
                json.put("tag-name", (Object)"fork");
                break;
            }
            case 8: {
                json.put("tag-name", (Object)"join");
                break;
            }
            case 9: {
                json.put("tag-name", (Object)"event");
                break;
            }
            case 10: {
                json.put("tag-name", (Object)"state");
                break;
            }
            case 11: {
                json.put("tag-name", (Object)"timer");
                break;
            }
            case 12: {
                json.put("tag-name", (Object)"inline");
                break;
            }
            case 13: {
                json.put("tag-name", (Object)"data-map");
                break;
            }
            case 14: {
                json.put("tag-name", (Object)"complex-join");
                break;
            }
            case 15: {
                json.put("tag-name", (Object)"manual-task");
                break;
            }
            case 16: {
                json.put("tag-name", (Object)"exclusive-fork");
                break;
            }
            case 17: {
                json.put("tag-name", (Object)"service-task");
                break;
            }
            case 18: {
                json.put("tag-name", (Object)"branch-end");
                break;
            }
            case 19: {
                json.put("tag-name", (Object)"state-action");
                break;
            }
            case 20: {
                json.put("tag-name", (Object)"multi-task");
                break;
            }
            case 21: {
                json.put("tag-name", (Object)"multi-audit");
                break;
            }
            case 25: {
                json.put("tag-name", (Object)"message-send");
                break;
            }
            case 26: {
                json.put("tag-name", (Object)"message-receive");
            }
        }
        json.put("nodeType", nodeType);
        MetaTransitionCollection transitions = node.getTransitionCollection();
        if (transitions != null && !transitions.empty()) {
            JSONArray jsonArray = new JSONArray();
            Iterator it = transitions.iterator();
            MetaTransition transition = null;
            while (it.hasNext()) {
                transition = (MetaTransition)it.next();
                jsonArray.put((Object)this.transition2JSON(node, transition, transBPMPath));
                if (transBPMPath == null || transition.getTargetNode() == null || !transBPMPath.containPath(node.getID(), transition.getTargetNode().getID())) continue;
                json.put("state", 2);
            }
            json.put("transitions", (Object)jsonArray);
        }
        return json;
    }

    private JSONObject swim2JSON(MetaSwimline swim) {
        JSONObject json = new JSONObject();
        json.put("id", swim.getID());
        json.put("key", (Object)swim.getKey());
        MetaSwimlinePosition position = swim.getPosition();
        json.put("x", position.getX());
        json.put("y", position.getY());
        MetaSwimlineSize size = swim.getSize();
        json.put("width", size.getWidth());
        json.put("height", size.getHeight());
        json.put("caption", (Object)swim.getCaption());
        json.put("direction", (Object)swim.getDirection());
        return json;
    }
}

