/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.bpm.meta.transform.graph;

import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMAudit;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMBegin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMBranchEnd;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMComplexJoin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMCountersign;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMDataMap;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMDecision;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMEnd;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMEvent;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMExclusiveFork;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMFork;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMInline;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMJoin;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMManualTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMessageReceive;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMessageSend;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMultiAudit;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMMultiUserTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMNode;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMServiceTask;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMState;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMStateAction;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMSubProcess;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMSwimline;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMTimer;
import com.bokesoft.yes.bpm.meta.transform.elements.TransBPMUserTask;
import com.bokesoft.yes.bpm.meta.transform.graph.TransBPMPath;
import com.bokesoft.yigo.common.json.JSONSerializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class TransBPMGraph
implements JSONSerializable {
    private String key = "";
    private String caption = "";
    private int version = 1;
    private ArrayList<TransBPMNode> nodeArray = null;
    private ArrayList<TransBPMSwimline> swimArray = null;
    private TransBPMPath path = null;
    public static final String tag_key = "key";
    public static final String tag_caption = "caption";
    public static final String tag_version = "version";
    public static final String tag_nodes = "nodes";
    public static final String tag_swims = "swims";

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public void addNode(TransBPMNode node) {
        if (this.nodeArray == null) {
            this.nodeArray = new ArrayList();
        }
        this.nodeArray.add(node);
    }

    public int getNodeCount() {
        return this.nodeArray == null ? 0 : this.nodeArray.size();
    }

    public TransBPMNode getNode(int index) {
        return this.nodeArray.get(index);
    }

    public Iterator<TransBPMNode> iteratorNode() {
        return this.nodeArray.iterator();
    }

    public Iterator<TransBPMSwimline> iteratorSwim() {
        if (this.swimArray != null) {
            return this.swimArray.iterator();
        }
        return null;
    }

    public void addSwim(TransBPMSwimline swim) {
        if (this.swimArray == null) {
            this.swimArray = new ArrayList();
        }
        this.swimArray.add(swim);
    }

    public void setTransPath(TransBPMPath path) {
        this.path = path;
    }

    public TransBPMPath getTransPath() {
        return this.path;
    }

    private TransBPMNode createNode(String tagName) {
        TransBPMNode node = null;
        if ("audit".equals(tagName)) {
            node = new TransBPMAudit();
        } else if ("begin".equals(tagName)) {
            node = new TransBPMBegin();
        } else if ("branch-end".equals(tagName)) {
            node = new TransBPMBranchEnd();
        } else if ("complex-join".equals(tagName)) {
            node = new TransBPMComplexJoin();
        } else if ("countersign".equals(tagName)) {
            node = new TransBPMCountersign();
        } else if ("data-map".equals(tagName)) {
            node = new TransBPMDataMap();
        } else if ("decision".equals(tagName)) {
            node = new TransBPMDecision();
        } else if ("end".equals(tagName)) {
            node = new TransBPMEnd();
        } else if ("event".equals(tagName)) {
            node = new TransBPMEvent();
        } else if ("fork".equals(tagName)) {
            node = new TransBPMFork();
        } else if ("exclusive-fork".equals(tagName)) {
            node = new TransBPMExclusiveFork();
        } else if ("inline".equals(tagName)) {
            node = new TransBPMInline();
        } else if ("join".equals(tagName)) {
            node = new TransBPMJoin();
        } else if ("service-task".equals(tagName)) {
            node = new TransBPMServiceTask();
        } else if ("state".equals(tagName)) {
            node = new TransBPMState();
        } else if ("sub-process".equals(tagName)) {
            node = new TransBPMSubProcess();
        } else if ("timer".equals(tagName)) {
            node = new TransBPMTimer();
        } else if ("user-task".equals(tagName)) {
            node = new TransBPMUserTask();
        } else if ("manual-task".equals(tagName)) {
            node = new TransBPMManualTask();
        } else if ("state-action".equals(tagName)) {
            node = new TransBPMStateAction();
        } else if ("multi-task".equals(tagName)) {
            node = new TransBPMMultiUserTask();
        } else if ("multi-audit".equals(tagName)) {
            node = new TransBPMMultiAudit();
        } else if ("message-send".equals(tagName)) {
            node = new TransBPMMessageSend();
        } else if ("message-receive".equals(tagName)) {
            node = new TransBPMMessageReceive();
        }
        return node;
    }

    private TransBPMSwimline createSwimLine() {
        return new TransBPMSwimline();
    }

    public JSONObject toJSON() throws Throwable {
        JSONObject json = new JSONObject();
        json.put(tag_key, (Object)this.key);
        json.put(tag_caption, (Object)this.caption);
        json.put(tag_version, this.version);
        if (this.nodeArray != null) {
            JSONArray jsonArray = new JSONArray();
            Iterator<TransBPMNode> it = this.nodeArray.iterator();
            TransBPMNode node = null;
            while (it.hasNext()) {
                node = it.next();
                jsonArray.put((Object)node.toJSON());
            }
            json.put(tag_nodes, (Object)jsonArray);
        }
        if (this.path != null) {
            json.put("transpath", (Object)this.path.toJSON());
        }
        return json;
    }

    public void fromJSON(JSONObject json) throws Throwable {
        JSONObject tmpJson;
        int i;
        int size;
        JSONArray jsonArray;
        this.key = json.optString(tag_key);
        this.caption = json.optString(tag_caption);
        this.version = json.optInt(tag_version);
        if (json.has(tag_nodes)) {
            jsonArray = json.getJSONArray(tag_nodes);
            size = jsonArray.length();
            for (i = 0; i < size; ++i) {
                tmpJson = jsonArray.getJSONObject(i);
                String tagName = tmpJson.optString("tag-name");
                TransBPMNode node = this.createNode(tagName);
                node.fromJSON(tmpJson);
                this.addNode(node);
            }
        }
        if (json.has(tag_swims)) {
            jsonArray = json.getJSONArray(tag_swims);
            size = jsonArray.length();
            for (i = 0; i < size; ++i) {
                tmpJson = jsonArray.getJSONObject(i);
                TransBPMSwimline swimLine = this.createSwimLine();
                swimLine.fromJSON(tmpJson);
                this.addSwim(swimLine);
            }
        }
        if (json.has("transpath")) {
            this.path = new TransBPMPath();
            this.path.fromJSON(json.optJSONObject("transpath"));
        }
    }
}

