/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yeslibrary.baidutts;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.Toast;
import com.baidu.tts.client.SpeechError;
import com.baidu.tts.client.SpeechSynthesizer;
import com.baidu.tts.client.SpeechSynthesizerListener;
import com.baidu.tts.client.TtsMode;
import com.bokesoft.yeslibrary.app.AppInterface;
import com.bokesoft.yeslibrary.app.IPlugin;
import com.bokesoft.yeslibrary.baidutts.R;
import com.bokesoft.yeslibrary.baidutts.TTSFunImplCluster;
import com.bokesoft.yeslibrary.common.util.LogUtils;
import com.bokesoft.yeslibrary.ui.form.function.parser.ViewFunctionImplMap;
import com.bokesoft.yigo.parser.IFunImplCluster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;

public class TTSPlugin
implements IPlugin {
    private static final String APP_ID = "com.bokesoft.yeslibrary.baidutts.APP_ID";
    private static final String API_KEY = "com.bokesoft.yeslibrary.baidutts.API_KEY";
    private static final String SECRET_KEY = "com.bokesoft.yeslibrary.baidutts.SECRET_KEY";
    private static final String SPEECH_FEMALE_MODEL_NAME = "bd_etts_common_speech_f7_mand_eng_high_am-mix_v3.0.0_20170512.dat";
    private static final String SPEECH_MALE_MODEL_NAME = "bd_etts_common_speech_m15_mand_eng_high_am-mix_v3.0.0_20170505.dat";
    private static final String TEXT_MODEL_NAME = "bd_etts_text.dat";
    private static final String BAIDU_TTS_DIR_NAME = "baiduTTS";

    public void initInApplicationOnCreate(Application context) {
        ViewFunctionImplMap.getViewInstance().regFunctionImplCluster((IFunImplCluster)new TTSFunImplCluster());
    }

    public boolean initInService(final Application context) {
        this.copyFromAssetsToSdcard((Context)context, true, SPEECH_FEMALE_MODEL_NAME, SPEECH_FEMALE_MODEL_NAME);
        this.copyFromAssetsToSdcard((Context)context, true, SPEECH_MALE_MODEL_NAME, SPEECH_MALE_MODEL_NAME);
        this.copyFromAssetsToSdcard((Context)context, true, TEXT_MODEL_NAME, TEXT_MODEL_NAME);
        SpeechSynthesizer speechSynthesizer = SpeechSynthesizer.getInstance();
        speechSynthesizer.setContext((Context)context);
        final TTSHandler handler = new TTSHandler(context);
        speechSynthesizer.setSpeechSynthesizerListener(new SpeechSynthesizerListener(){

            public void onSynthesizeStart(String s) {
            }

            public void onSynthesizeDataArrived(String var1, byte[] var2, int var3, int var4) {
            }

            public void onSynthesizeFinish(String s) {
            }

            public void onSpeechStart(String s) {
            }

            public void onSpeechProgressChanged(String s, int i) {
            }

            public void onSpeechFinish(String s) {
            }

            public void onError(String s, SpeechError speechError) {
                Message msg = Message.obtain();
                msg.obj = context.getString(R.string.error, new Object[]{String.valueOf(speechError.code), speechError.description});
                handler.sendMessage(msg);
            }
        });
        speechSynthesizer.setParam(SpeechSynthesizer.PARAM_TTS_TEXT_MODEL_FILE, this.getBaiduTTSDirFile((Context)context, TEXT_MODEL_NAME).getPath());
        speechSynthesizer.setParam(SpeechSynthesizer.PARAM_TTS_SPEECH_MODEL_FILE, this.getBaiduTTSDirFile((Context)context, SPEECH_FEMALE_MODEL_NAME).getPath());
        speechSynthesizer.setAppId(AppInterface.getMetaStringValue((Context)context, (String)APP_ID, (String)""));
        speechSynthesizer.setApiKey(AppInterface.getMetaStringValue((Context)context, (String)API_KEY, (String)""), AppInterface.getMetaStringValue((Context)context, (String)SECRET_KEY, (String)""));
        speechSynthesizer.setParam(SpeechSynthesizer.PARAM_SPEAKER, "0");
        speechSynthesizer.setParam(SpeechSynthesizer.PARAM_MIX_MODE, SpeechSynthesizer.MIX_MODE_DEFAULT);
        speechSynthesizer.initTts(TtsMode.MIX);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFromAssetsToSdcard(Context context, boolean isCover, String source, String dest) {
        File file = this.getBaiduTTSDirFile(context, dest);
        if (isCover || !file.exists()) {
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                int size;
                is = context.getResources().getAssets().open(source);
                fos = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((size = is.read(buffer, 0, 1024)) >= 0) {
                    fos.write(buffer, 0, size);
                }
            }
            catch (IOException e) {
                LogUtils.printStackTrace((Throwable)e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        LogUtils.printStackTrace((Throwable)e);
                    }
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    LogUtils.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private File getBaiduTTSDirFile(Context context, String path) {
        File root = context.getDir(BAIDU_TTS_DIR_NAME, 0);
        if (!root.exists()) {
            root.mkdirs();
        }
        return new File(root, path);
    }

    private static class TTSHandler
    extends Handler {
        private final WeakReference<Context> mContext;

        private TTSHandler(Application context) {
            super(Looper.getMainLooper());
            this.mContext = new WeakReference<Application>(context);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            Context context = (Context)this.mContext.get();
            if (context != null) {
                Toast.makeText((Context)context, (CharSequence)((String)msg.obj), (int)0).show();
            }
        }
    }
}

