/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.loopj;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

class MyRedirectHandler
extends DefaultRedirectHandler {
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";
    private final boolean enableRedirects;

    public MyRedirectHandler(boolean allowRedirects) {
        this.enableRedirects = allowRedirects;
    }

    public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
        if (!this.enableRedirects) {
            return false;
        }
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        int n2 = response.getStatusLine().getStatusCode();
        switch (n2) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
        URI uRI;
        Object object;
        HttpHost httpHost;
        URI uRI2;
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        Header header = response.getFirstHeader("location");
        if (header == null) {
            throw new ProtocolException("Received redirect response " + response.getStatusLine() + " but no location header");
        }
        String string = header.getValue().replaceAll(" ", "%20");
        try {
            uRI2 = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, (Throwable)uRISyntaxException);
        }
        HttpParams httpParams = response.getParams();
        if (!uRI2.isAbsolute()) {
            if (httpParams.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uRI2 + "' not allowed");
            }
            httpHost = (HttpHost)context.getAttribute("http.target_host");
            if (httpHost == null) {
                throw new IllegalStateException("Target host not available in the HTTP context");
            }
            object = (HttpRequest)context.getAttribute("http.request");
            try {
                uRI = new URI(object.getRequestLine().getUri());
                URI uRI3 = URIUtils.rewriteURI((URI)uRI, (HttpHost)httpHost, (boolean)true);
                uRI2 = URIUtils.resolve((URI)uRI3, (URI)uRI2);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
            }
        }
        if (httpParams.isParameterFalse("http.protocol.allow-circular-redirects")) {
            httpHost = (RedirectLocations)context.getAttribute(REDIRECT_LOCATIONS);
            if (httpHost == null) {
                httpHost = new RedirectLocations();
                context.setAttribute(REDIRECT_LOCATIONS, (Object)httpHost);
            }
            if (uRI2.getFragment() != null) {
                try {
                    uRI = new HttpHost(uRI2.getHost(), uRI2.getPort(), uRI2.getScheme());
                    object = URIUtils.rewriteURI((URI)uRI2, (HttpHost)uRI, (boolean)true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
                }
            } else {
                object = uRI2;
            }
            if (httpHost.contains((URI)object)) {
                throw new CircularRedirectException("Circular redirect to '" + object + "'");
            }
            httpHost.add((URI)object);
        }
        return uRI2;
    }
}

