/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.tts.client;

import android.content.Context;
import android.os.Bundle;
import com.baidu.tts.a.b.a;
import com.baidu.tts.aop.tts.TtsError;
import com.baidu.tts.auth.AuthInfo;
import com.baidu.tts.chainofresponsibility.logger.LoggerProxy;
import com.baidu.tts.client.SpeechSynthesizeBag;
import com.baidu.tts.client.SpeechSynthesizerListener;
import com.baidu.tts.client.TtsMode;
import com.baidu.tts.f.b;
import com.baidu.tts.f.c;
import com.baidu.tts.f.d;
import com.baidu.tts.f.g;
import com.baidu.tts.f.h;
import com.baidu.tts.f.j;
import com.baidu.tts.f.k;
import com.baidu.tts.f.l;
import com.baidu.tts.f.n;
import com.baidu.tts.tools.DataTool;
import com.baidu.tts.tools.StringTool;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpeechSynthesizer {
    public static final String VersionName = "2.5.5.109";
    public static final String VersionName_CODE = "2.5.5.109.3";
    public static final int ERROR_QUEUE_IS_FULL = n.U.b();
    public static final int ERROR_LIST_IS_TOO_LONG = n.V.b();
    public static final int ERROR_TEXT_IS_EMPTY = n.P.b();
    public static final int ERROR_TEXT_IS_TOO_LONG = n.Q.b();
    public static final int ERROR_TEXT_ENCODE_IS_WRONG = n.R.b();
    public static final int ERROR_APP_ID_IS_INVALID = n.X.b();
    public static final int MAX_QUEUE_SIZE = 15000;
    public static final int MAX_LIST_SIZE = 100;
    public static final String PARAM_REQUEST_PROTOCOL = g.a(g.ao);
    public static final String PARAM_REQUEST_ENABLE_DNS = g.a(g.ap);
    public static final String REQUEST_DNS_OFF = "0";
    public static final String REQUEST_DNS_ON = "1";
    public static final String REQUEST_PROTOCOL_HTTP = "http";
    public static final String REQUEST_PROTOCOL_HTTPS = "https";
    public static final String PARAM_PROXY_HOST = g.a(g.am);
    public static final String PARAM_PROXY_PORT = g.a(g.an);
    public static final String PARAM_URL = g.a(g.e);
    public static final String PARAM_AUDIO_CTRL = g.a(g.az);
    public static final String PARAM_TEXT_CTRL = g.a(g.aA);
    public static final String PARAM_SPEED = g.a(g.D);
    public static final String PARAM_PITCH = g.a(g.F);
    public static final String PARAM_VOLUME = g.a(g.E);
    public static final String PARAM_SPEC = g.a(g.ak);
    public static final String PARAM_TTS_TEXT_MODEL_FILE = g.a(g.P);
    public static final String PARAM_TTS_SPEECH_MODEL_FILE = g.a(g.Q);
    public static final String PARAM_TTS_LICENCE_FILE = g.a(g.R);
    public static final String PARAM_VOCODER_OPTIM_LEVEL = g.a(g.U);
    public static final String PARAM_CUSTOM_SYNTH = g.a(g.S);
    public static final String PARAM_OPEN_XML = g.a(g.T);
    public static final String PARAM_BILINGUAL_MODE = g.a(g.av);
    public static final String PARAM_PRODUCT_ID = g.a(g.O);
    public static final String PARAM_KEY = g.a(g.al);
    public static final String PARAM_LANGUAGE = g.a(g.G);
    public static final String PARAM_AUDIO_ENCODE = g.a(g.J);
    public static final String PARAM_AUDIO_RATE = g.a(g.K);
    public static final String PARAM_SPEAKER = g.a(g.L);
    public static final String PARAM_MIX_MODE = g.a(g.x);
    public static final String MIX_MODE_DEFAULT = j.a.name();
    public static final String MIX_MODE_HIGH_SPEED_NETWORK = j.b.name();
    public static final String PARAM_MIX_MODE_TIMEOUT = g.a(g.aw);
    public static final String PARAM_MIX_TIMEOUT_TWO_SECOND = l.b.name();
    public static final String PARAM_MIX_TIMEOUT_THREE_SECOND = l.c.name();
    public static final String PARAM_MIX_TIMEOUT_FOUR_SECOND = l.d.name();
    public static final String MIX_MODE_HIGH_SPEED_SYNTHESIZE = j.c.name();
    public static final String MIX_MODE_HIGH_SPEED_SYNTHESIZE_WIFI = j.d.name();
    public static final String LANGUAGE_ZH = h.a.a();
    public static final String LANGUAGE_EN = h.b.a();
    public static final String TEXT_ENCODE_GBK = d.a.b();
    public static final String TEXT_ENCODE_BIG5 = d.b.b();
    public static final String TEXT_ENCODE_UTF8 = d.c.b();
    public static final String AUDIO_ENCODE_BV = com.baidu.tts.f.b.a.a();
    public static final String AUDIO_ENCODE_AMR = com.baidu.tts.f.b.b.a();
    public static final String AUDIO_ENCODE_OPUS = com.baidu.tts.f.b.c.a();
    public static final String AUDIO_ENCODE_MP3 = com.baidu.tts.f.b.d.a();
    public static final String AUDIO_ENCODE_PCM = com.baidu.tts.f.b.e.a();
    public static final int AUDIO_SAMPLERATE_8K = k.a.a();
    public static final int AUDIO_SAMPLERATE_16K = k.b.a();
    public static final int AUDIO_SAMPLERATE_24K = k.c.a();
    public static final int AUDIO_SAMPLERATE_48K = k.d.a();
    public static final String AUDIO_BITRATE_BV_16K = c.a.a();
    public static final String AUDIO_BITRATE_AMR_6K6 = c.b.a();
    public static final String AUDIO_BITRATE_AMR_8K85 = c.c.a();
    public static final String AUDIO_BITRATE_AMR_12K65 = c.d.a();
    public static final String AUDIO_BITRATE_AMR_14K25 = c.e.a();
    public static final String AUDIO_BITRATE_AMR_15K85 = c.f.a();
    public static final String AUDIO_BITRATE_AMR_18K25 = c.g.a();
    public static final String AUDIO_BITRATE_AMR_19K85 = c.h.a();
    public static final String AUDIO_BITRATE_AMR_23K05 = c.i.a();
    public static final String AUDIO_BITRATE_AMR_23K85 = c.j.a();
    public static final String AUDIO_BITRATE_OPUS_8K = c.k.a();
    public static final String AUDIO_BITRATE_OPUS_16K = c.l.a();
    public static final String AUDIO_BITRATE_OPUS_18K = c.m.a();
    public static final String AUDIO_BITRATE_OPUS_20K = c.n.a();
    public static final String AUDIO_BITRATE_OPUS_24K = c.o.a();
    public static final String AUDIO_BITRATE_OPUS_32K = c.p.a();
    public static final String AUDIO_BITRATE_PCM = c.v.a();
    private static volatile SpeechSynthesizer a = null;
    private a b = new a();

    private SpeechSynthesizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpeechSynthesizer getInstance() {
        LoggerProxy.d("SpeechSynthesizer==", "SpeechSynthesizer getInstance versionName:2.5.5.109");
        if (a != null) return a;
        Class<SpeechSynthesizer> clazz = SpeechSynthesizer.class;
        synchronized (SpeechSynthesizer.class) {
            if (a != null) return a;
            a = new SpeechSynthesizer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    public void setSpeechSynthesizerListener(SpeechSynthesizerListener speechSynthesizerListener) {
        LoggerProxy.d("SpeechSynthesizer==", "setSpeechSynthesizerListener");
        this.b.a(speechSynthesizerListener);
    }

    public void setContext(Context context) {
        LoggerProxy.d("SpeechSynthesizer==", "setContext");
        this.b.a(context);
    }

    public synchronized int initTts(TtsMode ttsMode) {
        LoggerProxy.d("SpeechSynthesizer==", "VersionName: 2.5.5.109 initTts ttsMode:" + (Object)((Object)ttsMode));
        TtsError ttsError = this.b.a(ttsMode);
        return ttsError == null ? 0 : ttsError.getDetailCode();
    }

    public String libVersion() {
        return this.b.a();
    }

    public int setApiKey(String apiKey, String secretKey) {
        this.setParam(g.ah.name(), apiKey);
        this.setParam(g.ai.name(), secretKey);
        return 0;
    }

    public int setAppId(String appId) {
        if (StringTool.isAllNumber(appId)) {
            this.setParam(g.A.name(), appId);
            return 0;
        }
        return ERROR_APP_ID_IS_INVALID;
    }

    public int setParam(String key, String value) {
        LoggerProxy.d("SpeechSynthesizer==", "setParam key: " + key + " value:" + value);
        return this.b.a(key, value);
    }

    public synchronized int pause() {
        LoggerProxy.d("SpeechSynthesizer==", "pause");
        return this.b.b();
    }

    public synchronized int resume() {
        LoggerProxy.d("SpeechSynthesizer==", "resume");
        return this.b.c();
    }

    public synchronized int stop() {
        LoggerProxy.d("SpeechSynthesizer==", "stop");
        return this.b.d();
    }

    public synchronized int release() {
        LoggerProxy.d("SpeechSynthesizer==", "release");
        this.b.e();
        a = null;
        return 0;
    }

    public int loadCustomResource(String customModelPath) {
        LoggerProxy.d("SpeechSynthesizer==", "loadCustomResource: " + customModelPath);
        return this.b.a(customModelPath);
    }

    public int freeCustomResource() {
        LoggerProxy.d("SpeechSynthesizer==", "freeCustomResource: ");
        return this.b.f();
    }

    public int loadModel(String speechModelPath, String textModelPath) {
        LoggerProxy.d("SpeechSynthesizer==", "loadModel: " + speechModelPath + " " + textModelPath);
        return this.b.b(speechModelPath, textModelPath);
    }

    public int loadEnglishModel(String englishTextModelPath, String englishSpeechModelPath) {
        return this.b.c(englishTextModelPath, englishSpeechModelPath);
    }

    public int speak(String text) {
        return this.speak(text, null);
    }

    public int speak(SpeechSynthesizeBag speechSynthesizeBag) {
        try {
            String string = speechSynthesizeBag.getText();
            String string2 = speechSynthesizeBag.getUtteranceId();
            return this.speak(string, string2);
        }
        catch (Exception exception) {
            return n.Y.b();
        }
    }

    public int speak(String text, String utteranceId) {
        return this.speak(text, utteranceId, null);
    }

    public int speak(String text, String utteranceId, Bundle params) {
        LoggerProxy.d("SpeechSynthesizer==", "speak  text: " + text);
        return this.b.a(text, utteranceId, params);
    }

    public int synthesize(String text) {
        return this.synthesize(text, null);
    }

    public int synthesize(SpeechSynthesizeBag speechSynthesizeBag) {
        try {
            String string = speechSynthesizeBag.getText();
            String string2 = speechSynthesizeBag.getUtteranceId();
            return this.synthesize(string, string2);
        }
        catch (Exception exception) {
            return n.Y.b();
        }
    }

    public int synthesize(String text, String utteranceId) {
        return this.synthesize(text, utteranceId, null);
    }

    public int synthesize(String text, String utteranceId, Bundle params) {
        LoggerProxy.d("SpeechSynthesizer==", "synthesize  text: " + text);
        return this.b.b(text, utteranceId, params);
    }

    public int batchSpeak(List<SpeechSynthesizeBag> speechSynthesizeBags) {
        if (DataTool.isListEmpty(speechSynthesizeBags)) {
            return n.Y.b();
        }
        return this.b.a(speechSynthesizeBags);
    }

    public AuthInfo auth(TtsMode ttsMode) {
        LoggerProxy.d("SpeechSynthesizer==", "auth  ttsMode: " + ttsMode.getMode());
        return this.b.b(ttsMode);
    }

    public int setStereoVolume(float leftVolume, float rightVolume) {
        LoggerProxy.d("SpeechSynthesizer==", "setStereoVolume: " + leftVolume + " " + rightVolume);
        return this.b.a(leftVolume, rightVolume);
    }

    public int setAudioStreamType(int streamType) {
        LoggerProxy.d("SpeechSynthesizer==", "setAudioStreamType: " + streamType);
        return this.b.a(streamType);
    }

    public int setAudioAttributes(int usage, int contentType) {
        LoggerProxy.d("SpeechSynthesizer==", "setAudioAttributes usage:" + usage + " contentType:" + contentType);
        return this.b.a(usage, contentType);
    }

    public int setAudioSampleRate(int sampleRate) {
        LoggerProxy.d("SpeechSynthesizer==", "setAudioSampleRate ");
        return this.b.b(sampleRate);
    }

    public void setEnableAECPlay(boolean aecPlay) {
        LoggerProxy.d("SpeechSynthesizer==", "setEnableAECPlay " + aecPlay);
        com.baidu.tts.b.b.b.d.a(aecPlay);
    }
}

