/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.pushservice.message;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.baidu.android.pushservice.e.b;
import com.baidu.android.pushservice.f.a;
import com.baidu.android.pushservice.g.c;
import com.baidu.android.pushservice.g.d;
import com.baidu.android.pushservice.h;
import com.baidu.android.pushservice.h.m;
import com.baidu.android.pushservice.j;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicMsg
implements Parcelable {
    private static final String TAG = "PublicMsg";
    public static final int FLAG_NEED_CLEAR = 1;
    public static final int FLAG_NEED_VIBRATE = 2;
    public static final int FLAG_NEED_SOUND = 4;
    public String mMsgId;
    public String mAppId;
    public String mTitle;
    public String mDescription;
    public String mUrl;
    public String mPkgName;
    public int mPkgVercode = 0;
    public String mPkgContent;
    public int mNetType = 0;
    public int mNotificationBuilder = 0;
    public int mOpenType = 0;
    public int mNotificationBasicStyle = 7;
    public String mCustomContent;
    public String mSupportAppname;
    public boolean mIsSupportApp = true;
    public int mUserConfirm = 0;
    public int mAdvertiseStyle;
    public String mAdvertiseSmallIconUrl;
    public String mAdvertiseLargeIconUrl;
    public String mAdvertiseClickUrl;
    public String mAdvertiseBigPictureUrl;
    public String mAdvertiseBigPictureClickUrl;
    public String mAdvertiseDownloadClickUrl;
    public String mAdvertiseDetailClickUrl;
    public String mAdvertiseBigPictureTitle;
    public String mAdvertiseBigPictureContent;
    public static final Parcelable.Creator<PublicMsg> CREATOR = new Parcelable.Creator<PublicMsg>(){

        public PublicMsg a(Parcel parcel) {
            return new PublicMsg(parcel);
        }

        public PublicMsg[] a(int n2) {
            return new PublicMsg[n2];
        }

        public /* synthetic */ Object[] newArray(int n2) {
            return this.a(n2);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    public PublicMsg() {
    }

    PublicMsg(Parcel parcel) {
        this.mMsgId = parcel.readString();
        this.mAppId = parcel.readString();
        this.mTitle = parcel.readString();
        this.mDescription = parcel.readString();
        this.mUrl = parcel.readString();
        this.mPkgName = parcel.readString();
        this.mPkgVercode = parcel.readInt();
        this.mNotificationBuilder = parcel.readInt();
        this.mNotificationBasicStyle = parcel.readInt();
        this.mOpenType = parcel.readInt();
        this.mUserConfirm = parcel.readInt();
        this.mCustomContent = parcel.readString();
        this.mPkgContent = parcel.readString();
        this.mAdvertiseStyle = parcel.readInt();
        this.mAdvertiseSmallIconUrl = parcel.readString();
        this.mAdvertiseLargeIconUrl = parcel.readString();
        this.mAdvertiseClickUrl = parcel.readString();
        this.mAdvertiseBigPictureUrl = parcel.readString();
        this.mAdvertiseBigPictureClickUrl = parcel.readString();
        this.mAdvertiseDownloadClickUrl = parcel.readString();
        this.mAdvertiseDetailClickUrl = parcel.readString();
        this.mAdvertiseBigPictureTitle = parcel.readString();
        this.mAdvertiseBigPictureContent = parcel.readString();
    }

    public void handle(Context context, String string, String string2) {
        PackageInfo packageInfo;
        a.a(TAG, "--handle--", context.getApplicationContext());
        if ("com.baidu.pushservice.action.publicmsg.DELETE_V2".equals(string)) {
            a.a(TAG, "Public msg deleted by user", context.getApplicationContext());
            this.sendResult(context, string2, 2);
            return;
        }
        int n2 = 0;
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(this.mPkgName, 0);
            int n3 = packageInfo.versionCode;
            if (n3 >= this.mPkgVercode) {
                Intent intent = Intent.parseUri((String)this.mPkgContent, (int)0);
                intent.setPackage(this.mPkgName);
                if (packageManager.queryBroadcastReceivers(intent, 0).size() > 0) {
                    context.sendBroadcast(intent);
                    n2 = 1;
                } else if (packageManager.queryIntentActivities(intent, 0).size() > 0) {
                    intent.addFlags(0x10000000);
                    context.startActivity(intent);
                    n2 = 1;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            a.b(TAG, "package not exist \r\n" + nameNotFoundException.getMessage(), context);
            n2 = 0;
        }
        catch (URISyntaxException uRISyntaxException) {
            a.b(TAG, "uri to intent fail \r\n" + uRISyntaxException.getMessage(), context);
            n2 = 0;
        }
        catch (Exception exception) {
            a.b(TAG, "parse customize action error\r\n" + exception.getMessage(), context);
        }
        if (n2 == 0) {
            packageInfo = new Intent("android.intent.action.VIEW");
            packageInfo.setData(Uri.parse((String)this.mUrl));
            packageInfo.addFlags(0x10000000);
            try {
                context.startActivity((Intent)packageInfo);
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                a.b(TAG, ">>> Url cann't be deal! \r\n" + activityNotFoundException.getMessage(), context);
            }
        }
        this.sendResult(context, string2, n2);
    }

    public void handlePrivateNotification(Context context, String string, String string2, String string3, byte[] byArray, byte[] byArray2) {
        a.a(TAG, "=== Handle private notification: " + string, context);
        if ("com.baidu.android.pushservice.action.privatenotification.DELETE".equals(string)) {
            return;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.mPkgName, 0);
            int n2 = packageInfo.versionCode;
            if (n2 >= this.mPkgVercode) {
                Intent intent = new Intent();
                intent.putExtra("msgid", string2);
                intent.putExtra("notification_title", this.mTitle);
                intent.putExtra("notification_content", this.mDescription);
                intent.putExtra("com.baidu.pushservice.app_id", string3);
                intent.putExtra("baidu_message_secur_info", byArray);
                intent.putExtra("baidu_message_body", byArray2);
                this.addCustomContentToIntent(context, intent);
                m.b(context, intent, "com.baidu.android.pushservice.action.notification.CLICK", this.mPkgName);
                if (this.mOpenType == 1 && this.mUrl != null) {
                    Intent intent2 = new Intent();
                    intent2.setAction("android.intent.action.VIEW");
                    Uri uri = Uri.parse((String)this.mUrl);
                    intent2.setData(uri);
                    intent2.addFlags(0x10000000);
                    context.startActivity(intent2);
                } else if (this.mOpenType == 2) {
                    if (!TextUtils.isEmpty((CharSequence)this.mPkgContent)) {
                        Intent intent3 = Intent.parseUri((String)this.mPkgContent, (int)0);
                        intent3.setPackage(this.mPkgName);
                        if (packageManager.queryBroadcastReceivers(intent3, 0).size() > 0) {
                            String string4 = intent3.getAction();
                            if (string4 != null && string4.startsWith("com.baidu.android.pushservice.action")) {
                                context.sendBroadcast(intent3);
                            }
                        } else {
                            ActivityInfo activityInfo;
                            List list = packageManager.queryIntentActivities(intent3, 0);
                            if (list != null && list.size() > 0 && (activityInfo = ((ResolveInfo)list.get((int)0)).activityInfo) != null && activityInfo.exported) {
                                intent3.addFlags(0x10000000);
                                intent3.putExtra("open_type", 1);
                                intent3.putExtra("msgid", string2);
                                context.startActivity(intent3);
                            }
                        }
                    } else {
                        this.startApplicationLauncher(context, this.mPkgName, string2);
                    }
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            a.b(TAG, "package not exist \r\n" + nameNotFoundException.getMessage(), context);
        }
        catch (URISyntaxException uRISyntaxException) {
            a.b(TAG, "uri to intent fail \r\n" + uRISyntaxException.getMessage(), context);
        }
    }

    public String getLauncherActivityName(Context context, String string) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setPackage(string);
        List list = context.getPackageManager().queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : list) {
            if (resolveInfo.activityInfo == null) continue;
            return resolveInfo.activityInfo.name;
        }
        return null;
    }

    private void startApplicationLauncher(Context context, String string, String string2) {
        try {
            Intent intent = this.mPkgContent != null ? Intent.parseUri((String)this.mPkgContent, (int)0) : new Intent();
            String string3 = this.getLauncherActivityName(context, string);
            if (string3 != null) {
                intent.setClassName(string, string3);
                int n2 = intent.getFlags();
                intent.setFlags(n2 |= 0x10000000);
                intent.putExtra("open_type", 1);
                intent.putExtra("msgid", string2);
                context.startActivity(intent);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            a.b(TAG, "error " + uRISyntaxException.getMessage(), context.getApplicationContext());
        }
    }

    private void addCustomContentToIntent(Context context, Intent intent) {
        if (this.mCustomContent != null) {
            try {
                JSONObject jSONObject = new JSONObject(this.mCustomContent);
                Iterator iterator = jSONObject.keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = jSONObject.getString(string);
                    intent.putExtra(string, string2);
                }
                intent.putExtra("extra_extra_custom_content", this.mCustomContent);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    private void sendResult(final Context context, String string, int n2) {
        final String string2 = j.a(context).a();
        final String string3 = j.a(context).b();
        if (TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
            a.b(TAG, "Fail Send Public msg result. Token invalid!", context.getApplicationContext());
            return;
        }
        a.a(TAG, "Send Linkhit, msgId = " + string + ", resultCode = " + n2, context.getApplicationContext());
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("msgid", (Object)string);
            jSONObject.put("result_code", n2);
        }
        catch (JSONException jSONException) {
            a.b(TAG, jSONException.getMessage(), context.getApplicationContext());
        }
        final String string4 = jSONObject.toString();
        d.a().a(new c("PushService-linkhit", 90){

            @Override
            public void a() {
                try {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    com.baidu.android.pushservice.d.b.a(context, hashMap);
                    hashMap.put("method", "linkhit");
                    hashMap.put("channel_token", string3);
                    hashMap.put("data", string4);
                    String string = h.e() + string2;
                    com.baidu.android.pushservice.e.a a2 = b.a(context, string, "POST", hashMap);
                    if (a2.b() == 200) {
                        a.c(PublicMsg.TAG, "<<< public msg send result return OK!", context.getApplicationContext());
                    }
                }
                catch (Exception exception) {
                    a.b(PublicMsg.TAG, "error : " + exception.getMessage(), context.getApplicationContext());
                }
            }
        });
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        parcel.writeString(this.mMsgId);
        parcel.writeString(this.mAppId);
        parcel.writeString(this.mTitle);
        parcel.writeString(this.mDescription);
        parcel.writeString(this.mUrl);
        parcel.writeString(this.mPkgName);
        parcel.writeInt(this.mPkgVercode);
        parcel.writeInt(this.mNotificationBuilder);
        parcel.writeInt(this.mNotificationBasicStyle);
        parcel.writeInt(this.mOpenType);
        parcel.writeInt(this.mUserConfirm);
        parcel.writeString(this.mCustomContent);
        parcel.writeString(this.mPkgContent);
        parcel.writeInt(this.mAdvertiseStyle);
        parcel.writeString(this.mAdvertiseSmallIconUrl);
        parcel.writeString(this.mAdvertiseLargeIconUrl);
        parcel.writeString(this.mAdvertiseClickUrl);
        parcel.writeString(this.mAdvertiseBigPictureUrl);
        parcel.writeString(this.mAdvertiseBigPictureClickUrl);
        parcel.writeString(this.mAdvertiseDownloadClickUrl);
        parcel.writeString(this.mAdvertiseDetailClickUrl);
        parcel.writeString(this.mAdvertiseBigPictureTitle);
        parcel.writeString(this.mAdvertiseBigPictureContent);
    }

    public String toString() {
        return "\r\n mMsgId = " + this.mMsgId + "\r\n mAppId = " + this.mAppId + "\r\n mTitle = " + this.mTitle + "\r\n mDescription = " + this.mDescription + "\r\n mUrl = " + this.mUrl + "\r\n mNetType = " + this.mNetType + "\r\n mSupportAppname = " + this.mSupportAppname + "\r\n mIsSupportApp = " + this.mIsSupportApp + "\r\n mPkgName = " + this.mPkgName + "\r\n mPlgVercode = " + this.mPkgVercode + "\r\n mNotificationBuilder = " + this.mNotificationBuilder + "\r\n mNotificationBasicStyle = " + this.mNotificationBasicStyle + "\r\n mOpenType = " + this.mOpenType + "\r\n mCustomContent = " + this.mCustomContent + "\r\n mIntent = " + this.mPkgContent + "\r\n";
    }
}

