/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.pushservice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.baidu.android.pushservice.PushSettings;
import com.baidu.android.pushservice.b.d;
import com.baidu.android.pushservice.c.c;
import com.baidu.android.pushservice.f;
import com.baidu.android.pushservice.h.m;
import com.baidu.android.pushservice.message.a.e;
import com.baidu.android.pushservice.message.i;
import com.meizu.cloud.pushsdk.PushManager;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.mipush.sdk.MiPushMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class PushMessageReceiver
extends BroadcastReceiver {
    public static final String TAG = "PushMessageReceiver";

    public final void onReceive(Context context, Intent intent) {
        if (context == null || intent == null) {
            return;
        }
        try {
            intent.getByteArrayExtra("baidu_message_secur_info");
        }
        catch (Exception exception) {
            return;
        }
        String string = intent.getAction();
        if (TextUtils.equals((CharSequence)string, (CharSequence)"com.baidu.android.pushservice.action.MESSAGE")) {
            this.handleActionMessage(context, intent);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.baidu.android.pushservice.action.RECEIVE")) {
            this.handleNormalMethods(context, intent);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.baidu.android.pushservice.action.notification.CLICK")) {
            this.handleNotificationClick(context, intent);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.huawei.android.push.intent.RECEIVE")) {
            this.handleHuaweiMessage(context, intent, string);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.xiaomi.mipush.REGISTER")) {
            this.handleMiPushToken(context, intent);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.xiaomi.mipush.PUSH_MSG")) {
            this.handleMiPushMessage(context, intent);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.meizu.mzpush.REGISTER")) {
            this.handleMeizuToken(context, intent);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.meizu.mzpush.PUSH_MSG")) {
            this.handleMeizuMessage(context, intent);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.baidu.android.pushservice.action.OPPO_CLICK")) {
            this.handleOppoMessageCallBack(context, intent);
        } else if (TextUtils.equals((CharSequence)string, (CharSequence)"com.baidu.android.pushservice.action.VIVO_CLICK")) {
            this.handleVivoMessageCallBack(context, intent);
        }
    }

    private void handleMeizuMessage(Context context, Intent intent) {
        if (!m.c()) {
            return;
        }
        if (intent.hasExtra("mz_push_msg_type")) {
            this.handleMeizuMessageCallBack(context, intent);
        }
    }

    private void handleMeizuToken(Context context, Intent intent) {
        if (!d.f(context)) {
            return;
        }
        if (intent.hasExtra("mz_register_errorcode")) {
            String string = intent.getStringExtra("mz_register_errorcode");
            if (!TextUtils.isEmpty((CharSequence)string) && string.equals("200")) {
                String string2;
                if (intent.hasExtra("mz_pushid") && !TextUtils.isEmpty((CharSequence)(string2 = intent.getStringExtra("mz_pushid")))) {
                    f.a(context, string2);
                }
            } else {
                f.j(context);
            }
        }
    }

    private void handleMiPushMessage(Context context, Intent intent) {
        if (!m.b()) {
            return;
        }
        if (intent.hasExtra("xm_push_msg")) {
            MiPushMessage miPushMessage = (MiPushMessage)intent.getSerializableExtra("xm_push_msg");
            if (intent.hasExtra("xm_push_msg_type")) {
                int n2 = intent.getIntExtra("xm_push_msg_type", 0);
                this.handleXiaomiMessageCallBack(context, miPushMessage, n2);
            }
        }
    }

    private void handleMiPushToken(Context context, Intent intent) {
        if (!d.g(context)) {
            return;
        }
        if (intent.hasExtra("xm_register_errorcode")) {
            String string;
            long l2 = intent.getLongExtra("xm_register_errorcode", 0L);
            if (l2 != 0L) {
                f.i(context);
            } else if (intent.hasExtra("xm_regid") && !TextUtils.isEmpty((CharSequence)(string = intent.getStringExtra("xm_regid")))) {
                f.a(context, string);
            }
        }
    }

    private void handleHuaweiMessage(Context context, Intent intent, String string) {
        if (!d.h(context)) {
            return;
        }
        try {
            boolean bl = intent.getBooleanExtra("IS_HMS_PASS_MSG_KEY", false);
            if (bl) {
                this.handleHuaweiMessageCallBack(context, intent.getStringExtra("HMS_PASS_MSG_VALUE_KEY"), null);
            } else {
                byte[] byArray = intent.getByteArrayExtra("msg_data");
                byte[] byArray2 = intent.getByteArrayExtra("device_token");
                String string2 = new String(byArray, "utf-8");
                String string3 = new String(byArray2, "utf-8");
                this.handleHuaweiMessageCallBack(context, string2, string3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleNotificationClick(Context context, Intent intent) {
        String string = intent.getStringExtra("msgid");
        String string2 = intent.getStringExtra("notification_title");
        String string3 = intent.getStringExtra("notification_content");
        String string4 = intent.getStringExtra("extra_extra_custom_content");
        String string5 = intent.getStringExtra("com.baidu.pushservice.app_id");
        int n2 = intent.getIntExtra("proxy_mode", 0);
        byte[] byArray = intent.getByteArrayExtra("baidu_message_secur_info");
        byte[] byArray2 = intent.getByteArrayExtra("baidu_message_body");
        if (n2 == 5) {
            String string6 = intent.getStringExtra("proxy_sign_info");
            String string7 = intent.getStringExtra("proxy_check_info");
            if (f.a(context.getApplicationContext(), string6, string7)) {
                this.onNotificationClicked(context, string2, string3, string4);
            }
        } else if (m.a(context, string, string5, string2, string3, string4) || m.a(context, byArray, string, byArray2)) {
            this.onNotificationClicked(context, string2, string3, string4);
        }
    }

    private void handleNormalMethods(Context context, Intent intent) {
        block39: {
            String string = intent.getStringExtra("method");
            if (TextUtils.isEmpty((CharSequence)string)) {
                return;
            }
            int n2 = intent.getIntExtra("error_msg", 0);
            String string2 = "";
            if (intent.getByteArrayExtra("content") != null) {
                string2 = new String(intent.getByteArrayExtra("content"));
            }
            if (string.equals("com.baidu.android.pushservice.action.notification.ARRIVED")) {
                byte[] byArray;
                String string3 = intent.getStringExtra("msgid");
                String string4 = intent.getStringExtra("notification_title");
                String string5 = intent.getStringExtra("notification_content");
                String string6 = intent.getStringExtra("extra_extra_custom_content");
                byte[] byArray2 = intent.getByteArrayExtra("baidu_message_secur_info");
                if (m.a(context, byArray2, string3, byArray = intent.getByteArrayExtra("baidu_message_body"))) {
                    this.onNotificationArrived(context, string4, string5, string6);
                }
            } else if (string.equals("method_bind")) {
                if (n2 == 0 && !TextUtils.isEmpty((CharSequence)string2)) {
                    try {
                        JSONObject jSONObject = new JSONObject(string2);
                        String string7 = jSONObject.getString("request_id");
                        JSONObject jSONObject2 = jSONObject.getJSONObject("response_params");
                        String string8 = jSONObject2.getString("appid");
                        PushSettings.b(context, string8);
                        String string9 = jSONObject2.getString("channel_id");
                        String string10 = jSONObject2.optString("new_channel_id");
                        String string11 = jSONObject2.getString("user_id");
                        long l2 = 0L;
                        String string12 = null;
                        String string13 = null;
                        if (intent.hasExtra("real_bind")) {
                            l2 = System.currentTimeMillis();
                            string12 = intent.getStringExtra("access_token");
                            string13 = intent.getStringExtra("secret_key");
                        }
                        com.baidu.android.pushservice.h.i.a(context, string8, string9, string10, string7, string11, l2, string12, string13);
                        this.onBind(context, n2, string8, string11, TextUtils.isEmpty((CharSequence)string10) ? string9 : string10, string7);
                        m.a("PushMessageReceiver#onBind from " + context.getPackageName() + ", errorCode= " + n2 + ", appid=  " + string8 + ", userId=" + string11 + ", channelId=" + string9 + ", newChannelId=" + string10 + ", requestId=" + string7 + ", at time of " + System.currentTimeMillis(), context);
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(context.getPackageName());
                        stringBuilder.append(",");
                        stringBuilder.append(string8);
                        stringBuilder.append(",");
                        stringBuilder.append(string11);
                        stringBuilder.append(",");
                        stringBuilder.append("false");
                        stringBuilder.append(",");
                        stringBuilder.append(com.baidu.android.pushservice.a.a());
                        String string14 = m.c(stringBuilder.toString());
                        c.c(context, string14);
                    }
                    catch (Exception exception) {
                        this.onBind(context, n2, null, null, null, null);
                        m.a("onBind from " + context.getPackageName() + " errorCode " + n2 + " exception " + exception.getMessage() + " at time of " + System.currentTimeMillis(), context);
                    }
                } else {
                    this.onBind(context, n2, null, null, null, null);
                    m.a("onBind from " + context.getPackageName() + " errorCode " + n2 + " errorMsg = " + string2 + " at time of " + System.currentTimeMillis(), context);
                }
            } else if (string.equals("method_unbind")) {
                boolean bl;
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    String string15 = jSONObject.getString("request_id");
                    this.onUnbind(context, n2, string15);
                }
                catch (JSONException jSONException) {
                    this.onUnbind(context, n2, null);
                }
                m.a(context, false);
                boolean bl2 = d.g(context);
                if (bl2) {
                    MiPushClient.unregisterPush((Context)context);
                }
                if (bl = d.f(context)) {
                    String string16 = com.baidu.android.pushservice.h.i.a(context, "BD_MEIZU_PROXY_APPID_KEY");
                    String string17 = com.baidu.android.pushservice.h.i.a(context, "BD_MEIZU_PROXY_APPKEY_KEY");
                    if (!TextUtils.isEmpty((CharSequence)string16) && !TextUtils.isEmpty((CharSequence)string17)) {
                        PushManager.unRegister((Context)context, (String)string16, (String)string17);
                    }
                }
                m.a("unbind from" + context.getPackageName() + " errorCode " + n2 + " at time of " + System.currentTimeMillis(), context);
            } else if (string.equals("method_set_tags")) {
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    String string18 = jSONObject.getString("request_id");
                    String string19 = jSONObject.optString("error_msg");
                    if (!TextUtils.isEmpty((CharSequence)string19)) {
                        this.onSetTags(context, n2, new ArrayList<String>(), new ArrayList<String>(), string18);
                        break block39;
                    }
                    JSONObject jSONObject3 = jSONObject.optJSONObject("response_params");
                    if (jSONObject3 == null) {
                        return;
                    }
                    JSONArray jSONArray = jSONObject3.getJSONArray("details");
                    if (jSONArray == null) {
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                        JSONObject jSONObject4 = jSONArray.getJSONObject(i2);
                        String string20 = jSONObject4.getString("tag");
                        if (jSONObject4.getInt("result") == 0) {
                            arrayList.add(string20);
                            continue;
                        }
                        arrayList2.add(string20);
                    }
                    this.onSetTags(context, n2, arrayList, arrayList2, string18);
                }
                catch (JSONException jSONException) {
                    this.onSetTags(context, n2, null, null, null);
                }
            } else if (string.equals("method_del_tags")) {
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    String string21 = jSONObject.getString("request_id");
                    JSONObject jSONObject5 = jSONObject.getJSONObject("response_params");
                    if (jSONObject5 == null) {
                        return;
                    }
                    JSONArray jSONArray = jSONObject5.getJSONArray("details");
                    if (jSONArray == null) {
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
                        JSONObject jSONObject6 = jSONArray.getJSONObject(i3);
                        String string22 = jSONObject6.getString("tag");
                        if (jSONObject6.getInt("result") == 0) {
                            arrayList.add(string22);
                            continue;
                        }
                        arrayList3.add(string22);
                    }
                    this.onDelTags(context, n2, arrayList, arrayList3, string21);
                }
                catch (JSONException jSONException) {
                    this.onDelTags(context, n2, null, null, null);
                }
            } else if (string.equals("method_listtags")) {
                try {
                    JSONObject jSONObject = new JSONObject(string2);
                    String string23 = jSONObject.getString("request_id");
                    ArrayList arrayList = intent.getStringArrayListExtra("tags_list");
                    this.onListTags(context, n2, arrayList, string23);
                }
                catch (JSONException jSONException) {
                    this.onListTags(context, n2, null, null);
                }
            }
        }
    }

    private void handleActionMessage(final Context context, final Intent intent) {
        if (d.m(context) && !d.c(context)) {
            return;
        }
        if (intent.getExtras() == null) {
            return;
        }
        final byte[] byArray = intent.getByteArrayExtra("baidu_message_secur_info");
        final byte[] byArray2 = intent.getByteArrayExtra("baidu_message_body");
        final String string = intent.getStringExtra("message_id");
        final int n2 = intent.getIntExtra("baidu_message_type", -1);
        final String string2 = intent.getStringExtra("app_id");
        if (byArray == null || byArray2 == null || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || n2 == -1) {
            PushMessageReceiver.sendCallback(context, intent, 2);
            return;
        }
        if (m.j(context, string) || !com.baidu.android.pushservice.c.a.a(context, string)) {
            PushMessageReceiver.sendCallback(context, intent, 4);
        } else {
            final a a2 = new a(context){

                public void handleMessage(Message message) {
                    if (this.d.get() != null) {
                        PushMessageReceiver.this.onMessage((Context)this.d.get(), message.getData().getString("message"), message.getData().getString("custom_content"));
                        PushMessageReceiver.sendCallback(context, intent, 10);
                    }
                }
            };
            new Thread(){

                @Override
                public void run() {
                    String[] stringArray = e.a(context, n2, string2, string, byArray, byArray2);
                    if (stringArray == null || stringArray.length != 2) {
                        PushMessageReceiver.sendCallback(context, intent, 9);
                        return;
                    }
                    Message message = new Message();
                    Bundle bundle = new Bundle();
                    bundle.putString("message", stringArray[0]);
                    bundle.putString("custom_content", stringArray[1]);
                    message.setData(bundle);
                    a2.sendMessage(message);
                    m.a("message " + stringArray[0] + " at time of " + System.currentTimeMillis(), context);
                }
            }.start();
        }
    }

    private void handleHuaweiMessageCallBack(Context context, String string, String string2) {
        i i2 = new i();
        String string3 = i2.a(context, string);
        if (m.i(context) && !m.l(context, i2.b) && f.a(context, i2.e, i2.b + string3) && i2.c != com.baidu.android.pushservice.message.a.i.j.b() && (i2.c == com.baidu.android.pushservice.message.a.i.g.b() || i2.c == com.baidu.android.pushservice.message.a.i.b.b())) {
            this.onMessage(context, string3, null);
        }
    }

    private void handleMeizuMessageCallBack(Context context, Intent intent) {
        i i2 = new i();
        int n2 = intent.getIntExtra("mz_push_msg_type", 0);
        String string = intent.getStringExtra("mz_notification_self_define_content");
        String string2 = i2.c(context, string);
        if (!m.l(context, i2.b) && f.a(context, i2.e, (i2.b + string2).replaceAll("\\\\", "")) && n2 == b.c.a()) {
            String string3 = intent.getStringExtra("mz_notification_title");
            String string4 = intent.getStringExtra("mz_notification_content");
            this.onNotificationClicked(context, string3, string4, string2);
        }
    }

    private void handleOppoMessageCallBack(Context context, Intent intent) {
        if (!(m.e() || m.f() || m.g())) {
            return;
        }
        String string = intent.getStringExtra("op_notification_sign");
        String string2 = intent.getStringExtra("op_notification_msg_id");
        String string3 = intent.getStringExtra("op_notification_pkg_content");
        String string4 = intent.getStringExtra("extra_extra_custom_content");
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        if (!m.l(context, string2) && f.a(context, string, string2 + string4)) {
            Intent intent2;
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                try {
                    PackageManager packageManager;
                    intent2 = Intent.parseUri((String)string3, (int)0);
                    intent2.setPackage(context.getPackageName());
                    intent2.addFlags(0x10000000);
                    if (!TextUtils.isEmpty((CharSequence)string4)) {
                        packageManager = new JSONObject(string4);
                        Iterator iterator = packageManager.keys();
                        while (iterator.hasNext()) {
                            String string5 = (String)iterator.next();
                            intent2.putExtra(string5, packageManager.optString(string5));
                        }
                    }
                    if ((packageManager = context.getPackageManager()).queryIntentActivities(intent2, 0).size() > 0) {
                        context.startActivity(intent2);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
            try {
                intent2 = new JSONObject("{\"extras\":" + string4 + "}");
                string4 = intent2.getString("extras");
                this.onNotificationClicked(context, null, null, string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleVivoMessageCallBack(Context context, Intent intent) {
        if (!m.h()) {
            return;
        }
        String string = intent.getStringExtra("vi_notification_title");
        String string2 = intent.getStringExtra("vi_notification_content");
        String string3 = intent.getStringExtra("vi_notification_sign");
        String string4 = intent.getStringExtra("vi_notification_msg_id");
        String string5 = intent.getStringExtra("vi_notification_pkg_content");
        String string6 = intent.getStringExtra("extra_extra_custom_content");
        if (TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4)) {
            return;
        }
        if (!m.l(context, string4) && f.a(context, string3, string4 + string6)) {
            if (!TextUtils.isEmpty((CharSequence)string5)) {
                try {
                    PackageManager packageManager;
                    Intent intent2 = Intent.parseUri((String)string5, (int)0);
                    intent2.setPackage(context.getPackageName());
                    intent2.addFlags(0x10000000);
                    if (!TextUtils.isEmpty((CharSequence)string6)) {
                        packageManager = new JSONObject(string6);
                        Iterator iterator = packageManager.keys();
                        while (iterator.hasNext()) {
                            String string7 = (String)iterator.next();
                            intent2.putExtra(string7, packageManager.optString(string7));
                        }
                    }
                    if ((packageManager = context.getPackageManager()).queryIntentActivities(intent2, 0).size() > 0) {
                        context.startActivity(intent2);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
            try {
                this.onNotificationClicked(context, string, string2, string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleXiaomiMessageCallBack(Context context, MiPushMessage miPushMessage, int n2) {
        try {
            String string = miPushMessage.getContent();
            i i2 = new i();
            String string2 = "";
            boolean bl = PushMessageReceiver.msgFromXMConsole(context, string);
            if (bl) {
                string2 = string;
                i2.c = com.baidu.android.pushservice.message.a.i.b.b();
            } else {
                string2 = i2.b(context, string);
            }
            if (!(n2 != b.c.a() && m.l(context, i2.b) || i2.c == com.baidu.android.pushservice.message.a.i.j.b() || i2.c != com.baidu.android.pushservice.message.a.i.g.b() && i2.c != com.baidu.android.pushservice.message.a.i.c.b() && i2.c != com.baidu.android.pushservice.message.a.i.b.b() && i2.c != com.baidu.android.pushservice.message.a.i.f.b() && i2.c != com.baidu.android.pushservice.message.a.i.d.b() && i2.c != com.baidu.android.pushservice.message.a.i.e.b())) {
                if (n2 == b.a.a()) {
                    this.onMessage(context, string2, null);
                } else if (n2 == b.b.a()) {
                    this.onNotificationArrived(context, miPushMessage.getTitle(), miPushMessage.getDescription(), string2);
                } else if (n2 == b.c.a()) {
                    this.onNotificationClicked(context, miPushMessage.getTitle(), miPushMessage.getDescription(), string2);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static boolean msgFromXMConsole(Context context, String string) {
        try {
            new JSONObject(string);
        }
        catch (Exception exception) {
            return true;
        }
        return false;
    }

    private static void sendCallback(Context context, Intent intent, int n2) {
        boolean bl = intent.getBooleanExtra("bdpush_deliver_NO_CALLBACK", false);
        if (bl) {
            return;
        }
        String string = intent.getStringExtra("bd.cross.request.SOURCE_PACKAGE");
        if (TextUtils.equals((CharSequence)context.getPackageName(), (CharSequence)string)) {
            intent.putExtra("bd.cross.request.COMMAND_TYPE", "bd.cross.command.MESSAGE_ACK");
            intent.putExtra("bd.cross.request.RESULT_CODE", n2);
            com.baidu.android.pushservice.h.b.a(intent);
        }
    }

    public abstract void onBind(Context var1, int var2, String var3, String var4, String var5, String var6);

    public abstract void onUnbind(Context var1, int var2, String var3);

    public abstract void onSetTags(Context var1, int var2, List<String> var3, List<String> var4, String var5);

    public abstract void onDelTags(Context var1, int var2, List<String> var3, List<String> var4, String var5);

    public abstract void onListTags(Context var1, int var2, List<String> var3, String var4);

    public abstract void onMessage(Context var1, String var2, String var3);

    public abstract void onNotificationClicked(Context var1, String var2, String var3, String var4);

    public abstract void onNotificationArrived(Context var1, String var2, String var3, String var4);

    private static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b(1);
        public static final /* enum */ b b = new b(2);
        public static final /* enum */ b c = new b(3);
        private int d;
        private static final /* synthetic */ b[] e;

        private b(int n3) {
            this.d = n3;
        }

        private int a() {
            return this.d;
        }

        static {
            e = new b[]{a, b, c};
        }
    }

    private static class a
    extends Handler {
        protected final WeakReference<Context> d;

        public a(Context context) {
            super(context.getMainLooper());
            this.d = new WeakReference<Context>(context);
        }
    }
}

