/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.android.pushservice;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.baidu.android.pushservice.PushNotificationBuilder;
import com.baidu.android.pushservice.h.h;
import com.baidu.android.pushservice.h.m;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CustomPushNotificationBuilder
extends PushNotificationBuilder {
    private int mLayoutId;
    private int mLayoutIconId;
    private int mLayoutTitleId;
    private int mLayoutTextId;
    private int mLayoutIconDrawable;

    public CustomPushNotificationBuilder(int n2, int n3, int n4, int n5) {
        this.mLayoutId = n2;
        this.mLayoutIconId = n3;
        this.mLayoutTitleId = n4;
        this.mLayoutTextId = n5;
    }

    public void setLayoutDrawable(int n2) {
        this.mLayoutIconDrawable = n2;
    }

    @Override
    @SuppressLint(value={"NewApi"})
    public Notification construct(Context context) {
        Notification notification = null;
        Notification.Builder builder = new Notification.Builder(context);
        if (this.mNotificationDefaults != 0) {
            builder.setDefaults(this.mNotificationDefaults);
        }
        if (this.mNotificationsound != null) {
            builder.setSound(Uri.parse((String)this.mNotificationsound));
        }
        if (this.mVibratePattern != null) {
            builder.setVibrate(this.mVibratePattern);
        }
        if (this.mStatusbarIcon != 0) {
            builder.setSmallIcon(this.mStatusbarIcon);
        }
        if (this.mLayoutId != 0) {
            RemoteViews remoteViews = new RemoteViews(context.getPackageName(), this.mLayoutId);
            if (this.mLayoutIconDrawable != 0) {
                remoteViews.setImageViewResource(this.mLayoutIconId, this.mLayoutIconDrawable);
            }
            if (this.mNotificationTitle != null) {
                remoteViews.setTextViewText(this.mLayoutTitleId, (CharSequence)this.mNotificationTitle);
            }
            if (this.mNotificationText != null) {
                remoteViews.setTextViewText(this.mLayoutTextId, (CharSequence)this.mNotificationText);
            }
            builder.setContent(remoteViews);
        } else {
            builder.setContentTitle((CharSequence)this.mNotificationTitle);
            builder.setContentText((CharSequence)this.mNotificationText);
        }
        if (Build.VERSION.SDK_INT >= 21 && this.mColor != 0) {
            builder.setColor(this.mColor);
        }
        if (m.m(context)) {
            if (TextUtils.isEmpty((CharSequence)this.mChannelId)) {
                this.mChannelId = "com.baidu.android.pushservice.push";
            }
            if (TextUtils.isEmpty((CharSequence)this.mChannelName)) {
                this.mChannelName = "\u4e91\u63a8\u9001";
            }
            h.a(context, this.mChannelId, this.mChannelName);
            builder.setChannelId(this.mChannelId);
        }
        notification = Build.VERSION.SDK_INT >= 16 ? builder.build() : builder.getNotification();
        if (this.mNotificationFlags != 0 && notification != null) {
            notification.flags = this.mNotificationFlags;
        }
        return notification;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.mStatusbarIcon);
        objectOutputStream.writeInt(this.mNotificationFlags);
        objectOutputStream.writeInt(this.mNotificationDefaults);
        if (this.mNotificationsound != null) {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeObject(this.mNotificationsound);
        } else {
            objectOutputStream.writeBoolean(false);
        }
        if (this.mVibratePattern != null) {
            objectOutputStream.writeInt(this.mVibratePattern.length);
            for (int i2 = 0; i2 < this.mVibratePattern.length; ++i2) {
                objectOutputStream.writeLong(this.mVibratePattern[i2]);
            }
        } else {
            objectOutputStream.writeInt(0);
        }
        objectOutputStream.writeObject(this.mNotificationTitle);
        objectOutputStream.writeObject(this.mNotificationText);
        objectOutputStream.writeObject(this.mChannelId);
        objectOutputStream.writeObject(this.mChannelName);
        objectOutputStream.writeInt(this.mLayoutId);
        objectOutputStream.writeInt(this.mLayoutIconId);
        objectOutputStream.writeInt(this.mLayoutTitleId);
        objectOutputStream.writeInt(this.mLayoutTextId);
        objectOutputStream.writeInt(this.mLayoutIconDrawable);
        objectOutputStream.writeInt(this.mColor);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mStatusbarIcon = objectInputStream.readInt();
        this.mNotificationFlags = objectInputStream.readInt();
        this.mNotificationDefaults = objectInputStream.readInt();
        boolean bl = objectInputStream.readBoolean();
        if (bl) {
            this.mNotificationsound = (String)objectInputStream.readObject();
        }
        int n2 = objectInputStream.readInt();
        this.mVibratePattern = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.mVibratePattern[i2] = objectInputStream.readLong();
        }
        this.mNotificationTitle = (String)objectInputStream.readObject();
        this.mNotificationText = (String)objectInputStream.readObject();
        this.mChannelId = (String)objectInputStream.readObject();
        this.mChannelName = (String)objectInputStream.readObject();
        this.mLayoutId = objectInputStream.readInt();
        this.mLayoutIconId = objectInputStream.readInt();
        this.mLayoutTitleId = objectInputStream.readInt();
        this.mLayoutTextId = objectInputStream.readInt();
        this.mLayoutIconDrawable = objectInputStream.readInt();
        this.mColor = objectInputStream.readInt();
    }
}

