/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yeslibrary.baidupush;

import android.content.Context;
import com.baidu.android.pushservice.PushManager;
import com.bokesoft.yeslibrary.app.AppInterface;
import com.bokesoft.yeslibrary.baidupush.PushCallback;
import com.bokesoft.yeslibrary.baidupush.PushCore;
import com.bokesoft.yeslibrary.common.util.LogUtils;
import java.util.List;

public class PushHelper {
    public static final String META_KEY = "com.bokesoft.yeslibrary.baidupush.API_KEY";

    public static PushCore getInstance(Context context) {
        if (PushCore.pushCore == null) {
            PushCore.pushCore = new PushCore();
        }
        return PushCore.pushCore;
    }

    public static void startPush(Context context, PushCallback<String> callback) {
        String apiKey = AppInterface.getMetaStringValue((Context)context, (String)META_KEY, (String)"");
        PushCore pd = PushHelper.getInstance(context);
        pd.setChannelIdCallback(callback);
        try {
            PushManager.startWork((Context)context, (int)0, (String)apiKey);
        }
        catch (Exception e) {
            LogUtils.printStackTrace((Throwable)e);
        }
    }

    public static void stopPush(Context context) {
        PushManager.stopWork((Context)context);
    }

    public static void deleteTags(Context context, List<String> tags) {
        PushManager.delTags((Context)context, tags);
    }

    public static void listTags(Context context, PushCallback<List<String>> callback) {
        PushCore pd = PushHelper.getInstance(context);
        pd.setTagsCallback(callback);
        PushManager.listTags((Context)context);
    }

    public static void setTags(Context context, List<String> tags) {
        PushManager.setTags((Context)context, tags);
    }
}

