package com.bokesoft.yigoee.tech.bootsupport.web.enhancements.resver.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 用于处理静态资源的指示器, 标明了资源在浏览器客户的引用, 与资源的实际后台位置之间的映射关系
 */
public class StaticReferenceIndicator {
        /**
     * 需要进行静态资源版本处理的请求路径清单, 支持 Path 通配符。
     * 例如 /yesui/ux/** .
     */
    private String[] requestPathPatterns;
    /**
     * 资源文件搜索路径清单, 支持 Path 通配符; 注意: 路径仅到目录, 结尾不应该包含 "/", 不需要具体在文件名。
     * 例如 classpath*:/webapps/yigo/yesui/ux/** .
     */    
    private String[] resourceSearchPathPatterns;
    /**
     * 排除路径资源清单, 支持 Path 通配符.
     */
    private String[] excludeResourcePatterns;

    /**
     * 额外的 Servlet Filter 需要处理的 URL Patterns
     */
    private String[] additionalFilterUrlPatterns;

    public StaticReferenceIndicator(String[] requestPathPatterns, String[] resourceSearchPathPatterns) {
        this(requestPathPatterns, resourceSearchPathPatterns, new String[0]);
    }
    public StaticReferenceIndicator(String[] requestPathPatterns, String[] resourceSearchPathPatterns, String[] excludeResourcePatterns) {
        this.requestPathPatterns = requestPathPatterns;
        this.resourceSearchPathPatterns = resourceSearchPathPatterns;
        this.excludeResourcePatterns = excludeResourcePatterns;
    }

    /**
     * 在标准的 Filter 需要处理的 URL Patterns 的基础上, 附加需要的 URL Pattern
     * @param patterns
     * @return
     */
    public StaticReferenceIndicator appendFilterUrlPattern(String... patterns){
        List<String> localList = new ArrayList<>();
        if (null!=this.additionalFilterUrlPatterns){
            localList.addAll(Arrays.asList(this.additionalFilterUrlPatterns));
        }
        localList.addAll(Arrays.asList(patterns));

        this.additionalFilterUrlPatterns = localList.toArray(new String[0]);

        return this;
    }

    public String[] getRequestPathPatterns() {
        return requestPathPatterns;
    }
    public String[] getResourceSearchPathPatterns() {
        return resourceSearchPathPatterns;
    }
    public String[] getExcludeResourcePatterns() {
        return excludeResourcePatterns;
    }

    public String[] getAdditionalFilterUrlPatterns() {
        return additionalFilterUrlPatterns;
    }

}
