import { G as YesUI } from "./yes-ui-0d74d048.js";
class webFormRender extends HTMLElement {
  constructor() {
    super();
  }
  // static count = 0;
  static get observedAttributes() {
    return ["data-oid", "data-formkey"];
  }
  async connectedCallback() {
  }
  async attributeChangedCallback(name, oldValue, newValue) {
    if (!newValue || newValue === oldValue)
      return;
    await this.render();
  }
  set parameters(val) {
    this._parameters = val;
    this.render();
  }
  get parameters() {
    return this._parameters;
  }
  async render() {
    if (this._form) {
      this._form.close();
    }
    let ct = this.children[0];
    const OID = Number(this.getAttribute("data-oid"));
    const formKey = this.getAttribute("data-formkey");
    if (!formKey) {
      return;
    }
    if (!ct) {
      ct = document.createElement("div");
      ct.id = "formContainer";
      ct.style.height = "100%";
      this.appendChild(ct);
    } else {
      while (ct.firstChild) {
        ct.removeChild(ct.firstChild);
      }
    }
    try {
      let options = { OID, formKey };
      if (this.parameters) {
        options = Object.assign(options, { parameters: this.parameters });
      }
      if (options.formKey === "DictEdit" && !this.parameters) {
        return;
      }
      this._form = await YesUI.Forms.buildForm(options, ct);
    } catch (e) {
      throw new Error(`${formKey}表单嵌入失败: ${e}`);
    }
  }
}
export {
  webFormRender as w
};
//# sourceMappingURL=web-form-render-04bbfe7c.js.map
