import Control from "./control.js";
const slideToggle = function (node) {
    let isShow = getComputedStyle(node).display !== "none",
        fn = () => {
            node.style.display = "none";
        };

    if (isShow) {
        node.style.display = "none";
        document.removeEventListener("click", fn);
    } else {
        document.querySelectorAll(".login-loginbox .login_locale_vw").forEach((el) => {
            el.style.display = "none";
        })
        node.style.display = "block";
        document.addEventListener("click", fn);
    }
}
/**
 * 扩展字段，下拉框
 */
export default class Combobox extends Control {
    constructor(options) {
        super(options);
        this.items = [];
        if (options.comboboxSetting) {
            this.items = options.comboboxSetting.items;
        }
    }
    createHtml() {
        this.el = document.createElement("div");
        this.el.classList.add('login_locale', 'login-combox', 'login-' + this.key + '-rows');
        this.el.setAttribute("sortkey", this.key);

        this.$combobox = document.createElement("div");
        this.$combobox.classList.add('login-strip');
        this.$combobox.setAttribute("key", this.key);
        this.el.appendChild(this.$combobox)

        this.$items = document.createElement("div");
        this.$items.classList.add('login_locale_vw');
        this.$list = document.createElement("ul");
        this.$list.classList.add('locale-combox-list');
        this.$items.appendChild(this.$list);
        this.el.appendChild(this.$items);
        this.createText();
        this.createItems();
    }
    createText() {
        this.$label = document.createElement("div");
        this.$label.classList.add('login-label', 'login-combox-name');
        this.caption && (this.$label.innerHTML = this.caption);
        this.$combobox.appendChild(this.$label);

        this.$content = document.createElement("div");
        this.$content.classList.add('locale_paras', 'locale-combox-content');
        this.$combobox.appendChild(this.$content)

        this.$div = document.createElement("div");
        this.$comvalue = document.createElement("div");
        this.$comvalue.classList.add('locale-combox-value');
        this.$comvalue.innerHTML = '请选择';
        this.$div.appendChild(this.$comvalue);
        this.$dropDown = document.createElement("div");
        this.$dropDown.classList.add('dropDown-locale');
        this.$div.appendChild(this.$dropDown);
        this.$content.appendChild(this.$div);
    }

    createItems() {
        var self = this;
        this.items.forEach((item) => {
            self.addItem(item);
        });
    };

    addItem(item) {
        const { value, caption } = item,
            oLi = document.createElement("li");
        oLi.setAttribute("value", value);
        oLi.classList.add("login-combox-item");
        oLi.innerHTML = caption;
        this.$list.appendChild(oLi);
    }
    setDefaultValue() {
        this.items.forEach((item) => {
            const { value, caption } = item;
            if (this.defaultValue == value) {
                this.$comvalue.setAttribute("value", value);
                this.$comvalue.innerHTML = caption;
                this.commitValue(this.key, value);
            }
        });
    }
    setPlaceholder() {
        this.placeholder && (this.$comvalue.innerHTML = this.placeholder);
    }
    install() {
        var self = this;
        this.$content.addEventListener("click", (e) => {
            slideToggle(self.$items);
            e.stopPropagation();
        });
        this.$items.addEventListener("click", function (e) {
            e.stopPropagation();
            var selui = self.$items.querySelector(".sel")
            selui && selui.classList.remove("sel");
            var target = e.target.closest("li");
            if (!target) return;
            if (target.classList.contains("sel")) {
                return;
            }
            target.classList.add("sel");
            const caption = target.innerHTML,
                value = target.getAttribute("value");
            self.$comvalue.setAttribute("value", value);
            self.$comvalue.innerHTML = caption;
            slideToggle(self.$items);
            self.commitValue(self.key, value);
        });
    }
}