(function (mod) {
	if (typeof exports == "object" && typeof module == "object") // CommonJS
		mod(require("../../lib/codemirror"));
	else if (typeof define == "function" && define.amd) // AMD
		define(["../../lib/codemirror"], mod);
	else // Plain browser env
		mod(CodeMirror);
})(function (cm) {
	"use strict";

	var HOVER_CLASS = " CodeMirror-hover";
	var tooltip = "";

	let funcList = [];
	let funcDescList = [];
	let paramDescList = [];
	let returnValueDescList = [];
	let componentIdList = [];
	let componentDescList = [];
	let macroIdList = [];
	let macroDescList = [];
	let yigoFnKw = [];
	let db;

	/***
	 * 打开
	 * @returns {Promise<unknown>}
	 */
	function openDB(dbName) {
		return new Promise((resolve, reject) => {
			resolve(db);
		})
	}

	async function getDB() {
		db = ERPDESIGNER.DesignerFormulaCacheDB;
	}

	getDB();

	/***
	 * 获取所有数据
	 * @param name
	 * @returns {Promise<unknown>}
	 */
	async function getAllData() {
		if (!db) {
			db = await openDB();
		}
		return new Promise((resolve, reject) => {
			let tx = db.transaction("DesignerFormulaCache");
			tx.objectStore("DesignerFormulaCache").openCursor().onsuccess = function (event) {
				let cursor = event.target.result;
				if (cursor) {
					let name = cursor.value.key;
					let value = cursor.value.value;
					switch (name) {
						case "funcList":
							funcList = value ? value.split("@~@") : null;
							break;
						case "funcDescList":
							funcDescList = value ? value.split("@~@") : null;
							break;
						case "paramDescList":
							paramDescList = value ? value.split("@~@") : null;
							break;
						case "returnValueDescList":
							returnValueDescList = value ? value.split("@~@") : null;
							break;
						case "macroIdList":
							macroIdList = value ? value.split("@~@") : null;
							break;
						case "macroDescList":
							macroDescList = value ? value.split("@~@") : null;
							break;
						case "componentIdList":
							componentIdList = value ? value.split("@~@") : null;
							break;
						case "componentDescList":
							componentDescList = value ? value.split("@~@") : null;
							break;
						case "yigoFnKw":
							yigoFnKw = value ? value.split("@~@") : null;
							break;
					}
					cursor.continue();
				}
			};
			tx.oncomplete = function (event) {
				resolve("获取全部数据成功");
			}
			tx.onerror = function (event) {
				reject(e);
			}
		});
	}

	/***
	 * 关闭提示窗口
	 */
	function closeHintWin() {
		$("div.CodeMirror-hover-tooltip").each(function () {
			$(this).remove();
		})
		return false;
	}

	function showTooltip(e, content) {
		closeHintWin();
		var tt = document.createElement("div");
		tt.className = "CodeMirror-hover-tooltip";
		$(tt).attr("contenteditable", true);
		// div放到最顶层
		$(tt).css("z-index", 999);
		$(tt).append(content);
		document.body.appendChild(tt);
		$("div.CodeMirror-hover-tooltip").mouseleave(function () {
			closeHintWin();
		});

		function position(e) {
			var target_rect = e.target.getBoundingClientRect(),
				tt_rect = tt.getBoundingClientRect();
			// 设置top
			let designPanelContainer = $('#DesignPanelContainer');
			try {
				if (designPanelContainer.offset().top < 150) {
					tt.style.top = designPanelContainer.offset().top + "px";
					// 设置right
					let id = ERPDESIGNER.UI.propertyForm.getParentForm().formID;
						// textArea = $('#' + id + "_FormulaEditorFooter").children('textArea')[0];
					tt.style.right = rightDesignPanelContainer.outerWidth() + "px";
				} else {
					tt.style.top = designPanelContainer.offset().top - 100 + "px";
					tt.style.right = "20px";
				}
			} catch (e) {
				let rightDesignPanelContainer = $('.RightDesignPanelContainer');
				if (rightDesignPanelContainer.offset().top < 150) {
					tt.style.top = rightDesignPanelContainer.outerHeight() - 150 + "px";
					// 设置right
					let id = ERPDESIGNER.UI.propertyForm.getParentForm().formID;
					tt.style.right = rightDesignPanelContainer.outerWidth() + "px";
				} else {
					tt.style.top = rightDesignPanelContainer.offset().top - 100 + "px";
					tt.style.right = "20px";
				}
			}

		}

		//CodeMirror.on(document, "mousemove", position);
		position(e);
		if (tt.style.opacity != null)
			tt.style.opacity = 1;
		return tt;
	}

	function rm(elt) {
		if (elt.parentNode)
			elt.parentNode.removeChild(elt);
	}

	function hideTooltip(tt) {
		if (!tt)
			return;
		if (!tt.parentNode)
			return;
		if (tt.style.opacity == null)
			rm(tt);
		tt.style.opacity = 0;
		setTimeout(function () {
			rm(tt);
		}, 600);
	}

	function showTooltipFor(e, content, node, state, cm) {
		tooltip = showTooltip(e, content);

		function hide() {
			node.className = node.className.replace(HOVER_CLASS, "");
			if (tooltip) {
				hideTooltip(tooltip);
				tooltip = null;
			}
			cm.removeKeyMap(state.keyMap);
		}

		var poll = setInterval(function () {
			if (tooltip)
				for (var n = node; ; n = n.parentNode) {
					if (n == document.body)
						return;
					if (!n) {
						hide();
						break;
					}
				}
			if (!tooltip)
				return clearInterval(poll);
		}, 400);
		state.keyMap = {Esc: hide};
		cm.addKeyMap(state.keyMap);
	}

	function TextHoverState(cm, options) {
		this.options = options;
		this.timeout = null;
		if (options.delay) {
			this.onMouseOver = function (e) {
				onMouseOverWithDelay(cm, e);
			};
		} else {
			this.onMouseOver = function (e) {
				onMouseOver(cm, e);
			};
		}
		this.keyMap = null;
	}

	function parseOptions(cm, options) {
		if (options instanceof Function)
			return {
				getTextHover: options
			};
		if (!options || options === true)
			options = {};
		if (!options.getTextHover)
			options.getTextHover = cm.getHelper(CodeMirror.Pos(0, 0), "textHover");
		if (!options.getTextHover)
			throw new Error(
				"Required option 'getTextHover' missing (text-hover addon)");
		return options;
	}

	function onMouseOverWithDelay(cm, e) {
		var state = cm.state.textHover, delay = state.options.delay;
		clearTimeout(state.timeout);
		if (e.srcElement) {
			// hack for IE, because e.srcElement failed when it is used in the tiemout function
			var newE = {srcElement: e.srcElement, clientX: e.clientX, clientY: e.clientY};
			e = newE;
		}
		state.timeout = setTimeout(function () {
			onMouseOver(cm, e);
		}, delay);
	}

	async function onMouseOver(cm, e) {
		var node = e.target || e.srcElement;
		if (node) {
			// hack if lint addon is used to give it a higher priority
			if (/\bCodeMirror-lint-mark-/.test(node.className)) return;
				var state = cm.state.textHover, data =  await getTokenAndPosAt(cm, e);
				var content = await state.options.getTextHover(cm, data, e);
				if (content) {
					node.className += HOVER_CLASS;
					if (typeof content == 'function') {
						content(showTooltipFor, data, e, node, state, cm);
					} else {
						if ($("iframe").contents().find("#description")
							&& $("iframe").contents().find("#description").is(":visible")) {
							$("iframe").contents().find("#description").html(content);
						} else {
							showTooltipFor(e, content, node, state, cm);
						}
					}
				}
		}
	}

	function optionHandler(cm, val, old) {
		if (old && old != CodeMirror.Init && cm.state.textHover) {
			CodeMirror.off(cm.getWrapperElement(), "click", cm.state.textHover.onMouseOver);
			delete cm.state.textHover;
		}

		if (val) {
			var state = cm.state.textHover = new TextHoverState(cm, parseOptions(cm, val));
			CodeMirror.on(cm.getWrapperElement(), "click", state.onMouseOver);
		}
	}

	// When the mouseover fires, the cursor might not actually be over
	// the character itself yet. These pairs of x,y offsets are used to
	// probe a few nearby points when no suitable marked range is found.
	let nearby = [0, 0, 0, 5, 0, -5, 5, 0, -5, 0];

	function getTokenAndPosAt(cm, e) {
		let node = e.target || e.srcElement, text = node.innerText || node.textContent;
		for (let i = 0; i < nearby.length; i += 2) {
			let pos = cm.coordsChar({
				left: e.clientX + nearby[i],
				top: e.clientY + nearby[i + 1]
			});
			let token = cm.getTokenAt(pos);
			if (token && token.string) {
				return {
					token: token,
					pos: pos,
					funcList: ERPDESIGNER.Funs.funcList,
					funcDescList: ERPDESIGNER.Funs.funcDescList,
					paramDescList: ERPDESIGNER.Funs.paramDescList,
					returnValueDescList: ERPDESIGNER.Funs.returnValueDescList,
					componentIdList: ERPDESIGNER.Funs.componentIdList,
					componentDescList: ERPDESIGNER.Funs.componentDescList,
					macroIdList: ERPDESIGNER.Funs.macroIdList,
					macroDescList: ERPDESIGNER.Funs.macroDescList
				};
			}
		}
	}

	CodeMirror.defineOption("textHover", false, optionHandler); // deprecated
});
