/**
 * smart.tree.js扩展
 */
(function (smartMenu, smartTree) {
    // 重写内部方法
    smartMenu.prototype._createItemHTMLStructure = function (e, t, n, o) {
        const i = this,
            r = "smart-" + i._element + "-item-label-container",
            a = "smart-" + i._element + "-item-label-element",
            s = document.createDocumentFragment(),
            l = e.children;
        let d, m, c, u;
        for (let e = 0; e < l.length; e++) {
            const t = l[e];
            if (
                t.classList &&
                (t.classList && t.classList.contains(r)
                    ? (d = t)
                    : t.classList && t.classList.contains(a) && (m = t),
                d && m)
            )
                break;
        }
        if (d) {
            const t = d.querySelector("." + a);
            if (null !== t) {
                e.insertBefore(t.firstElementChild, e.children[0]);
                const n = "smart-" + i._element + "-drop-down",
                    o = "smart-" + i._element + "-item-container",
                    r = e.querySelector("." + n);
                if (r) {
                    const t = e.querySelector("." + o);
                    for (; t.childNodes.length; ) e.appendChild(t.firstChild);
                    r.remove();
                }
            }
            d.remove();
        }
        m && m.remove(),
            (d = document.createElement("div")),
            (m = document.createElement("div"));
        let p = document.createElement("span");
        (e.menu = i),
            t > 1
                ? ((e.originalIndex = o),
                  (c = n.path + "." + e.originalIndex),
                  (e.parentItem = n),
                  (u = n))
                : ((e.originalIndex = o), (c = "" + o), (u = i)),
            i.checkboxes &&
                u.checkable &&
                ("checkbox" === u.checkMode
                    ? e.setAttribute("role", "menuitemcheckbox")
                    : "radioButton" === u.checkMode &&
                      e.setAttribute("role", "menuitemradio")),
            (e.path = c),
            (i._menuItems[c] = e),
            (d.className = r),
            (m.className = a),
            "tree" === i._element &&
                i._setIndentation(
                    d,
                    t,
                    i.rightToLeft ? "paddingRight" : "paddingLeft"
                );
        const h = Array.from(e.childNodes);
        for (let e = 0; e < h.length; e++) {
            const t = h[e];
            if (
                t instanceof Smart.MenuItem ||
                t instanceof Smart.MenuItemsGroup
            )
                break;
            p.appendChild(t);
        }
        if ("" === p.innerHTML.trim()) {
            const t = e.label || e.getAttribute("label");
            p.classList.add("icon");
            if (e instanceof Smart.MenuItem) {
                p.classList.add("icon-doc");
            } else if (e instanceof Smart.MenuItemsGroup) {
                if (e.getAttribute("aria-expanded") === "true") {
                    p.classList.add("icon-expanded");
                } else {
                    p.classList.add("icon-collapse");
                }
            }
            t && "" !== t
                ? i._setLabel(t, p, e, !0)
                : (e.set("label", "Item " + o), (p.innerHTML = "Item " + o));
        } else e.set("label", p.innerHTML.trim());
        if (
            (e.setAttribute("aria-label", e.label),
            e instanceof Smart.MenuItemsGroup &&
                void 0 === e.titleLabel &&
                (e.titleLabel = e.label),
            m.appendChild(p),
            s.appendChild(m),
            e.set("level", t),
            e.set("shortcut", e.shortcut || e.getAttribute("shortcut") || ""),
            e.shortcut && e instanceof Smart.MenuItem)
        ) {
            const t = document.createElement("div");
            (t.id = e.id + "Shortcut"),
                (t.className = "smart-" + i._element + "-item-shortcut"),
                (t.innerHTML = e.shortcut),
                s.appendChild(t),
                e.setAttribute("aria-describedby", t.id);
        }
        d.appendChild(s),
            e.insertBefore(d, e.children[0]),
            e.id ||
                (e.id =
                    i.id +
                    "ItemP" +
                    e.path.replace(/\./g, "_") +
                    "L" +
                    e.label.replace(/[^a-zA-Z0-9\-\_]/g, ""));
        const curNode =
            d.closest("smart-tree-item") || d.closest("smart-tree-items-group");
        const actionBox = document.createElement("div");
        actionBox.classList.add(`smart-${i._element}-item-label-actions`);
        if (curNode instanceof Smart.MenuItemsGroup) {
            const addElm = document.createElement("i");
            addElm.title = "添加文件夹";
            addElm.classList.add(
                `smart-${i._element}-item-actions-add`,
                `icon`,
                `icon-plus`
            );
            actionBox.appendChild(addElm);
        }
        if (curNode && curNode.getAttribute("value") !== "BKVirtualMenu/PFC1") {
            const editElm = document.createElement("i");
            editElm.title = "编辑";
            editElm.classList.add(
                `smart-${i._element}-item-actions-edit`,
                `icon`,
                `icon-edit`
            );
            editElm.addEventListener("click", (event) => {
                const curEdit =
                    event.target.closest("smart-tree-item") ||
                    event.target.closest("smart-tree-items-group");
                this._startEditing(curEdit);
            });
            const delElm = document.createElement("i");
            delElm.title = "删除";
            delElm.classList.add(
                `smart-${i._element}-item-label-delete`,
                `icon`,
                `icon-del`
            );
            actionBox.appendChild(editElm);
            actionBox.appendChild(delElm);
        }
        d.appendChild(actionBox);
    };
    smartMenu.prototype._mouseoutMouseoverHandler = function (e) {
        const t = this;
        if (t.disabled || t.displayLoadingIndicator) return;
        let n =
            e.target.closest("smart-menu-item") ||
            e.target.closest("smart-menu-items-group");
        if (
            (t.enableShadowDOM &&
                (n =
                    e.composedPath()[0].closest("smart-menu-item") ||
                    e.composedPath()[0].closest("smart-menu-items-group") ||
                    n),
            "mouseover" === e.type && (t._isElementHovered = !0),
            null !== n &&
                undefined !== n &&
                !n.disabled &&
                !n.templateApplied &&
                (("tree" !== t.mode && !t._minimized) ||
                    !n.hasAttribute("focus") ||
                    !e.relatedTarget ||
                    (e.target.parentElement !== e.relatedTarget &&
                        e.relatedTarget.parentElement !== e.target)))
        )
            if ((t._discardKeyboardHover(!1), "mouseover" === e.type)) {
                "mouseenter" !== t.selectionMode ||
                    "tree" === t.mode ||
                    t._minimized ||
                    (n instanceof Smart.MenuItemsGroup &&
                    !n.hasAttribute("hover")
                        ? t._selectionHandler(e, n)
                        : n instanceof Smart.MenuItem &&
                          t._closeSubContainers(n.level + 1));
                const o = e.target.closest(".smart-menu-drop-down");
                (!o || (o && !n.contains(o))) &&
                    (n.$.addClass("hover"),
                    n.setAttribute("hover", ""),
                    t._discardKeyboardHover(!0));
            } else {
                if (
                    "tree" !== t.mode &&
                    !t._minimized &&
                    ("mouseenter" === t.selectionMode &&
                        e.relatedTarget === t.$.mainContainer &&
                        t._close(),
                    n instanceof Smart.MenuItemsGroup &&
                        n.container &&
                        !n.container.$.hasClass("smart-visibility-hidden"))
                )
                    return;
                n.$.removeClass("hover"), n.removeAttribute("hover");
            }
    };
    smartMenu.prototype._processDataSource = function () {
        const e = this,
            t = e.dataSource,
            n = e.displayMember,
            o = e.itemsMember,
            i = e.valueMember,
            r = e.$.mainContainer,
            a = document.createDocumentFragment();
        function s(t, r) {
            let a;
            if (Array.isArray(t[o])) {
                (a = document.createElement(
                    "smart-" + e._element + "-items-group"
                )),
                    !0 === t.checkable && a.set("checkable", !0),
                    "string" == typeof t.checkMode &&
                        a.set("checkMode", t.checkMode),
                    t.dropDownHeight &&
                        a.set("dropDownHeight", t.dropDownHeight),
                    !0 === t.expanded &&
                        "tree" === e.mode &&
                        (a.set("expanded", !0),
                        a.setAttribute("aria-expanded", !0));
                for (let e = 0; e < t[o].length; e++) s(t[o][e], a);
            } else
                (a = document.createElement("smart-" + e._element + "-item")),
                    void 0 !== t.shortcut && a.set("shortcut", t.shortcut),
                    t.customAttribute && a.setAttribute(t.customAttribute, "");
            (a.isDirty = !1),
                void 0 !== t.id &&
                    /^[A-Za-z]+[\w\-\:\.]*$/.test(t.id) &&
                    (a.id = t.id),
                !0 === t.checked &&
                    (a.set("checked", !0), a.setAttribute("aria-checked", !0)),
                !0 === t.disabled && a.set("disabled", !0),
                void 0 !== t[n]
                    ? a.set("label", t[n])
                    : "string" == typeof t[o] && a.set("label", t[o]),
                !0 === t.selected && a.set("selected", !0),
                !0 === t.separator && a.set("separator", !0),
                void 0 !== t[i] && a.set("value", t[i]),
                r.appendChild(a);
        }
        (r.innerHTML = ""), r instanceof Smart.ScrollViewer && r.removeAll();
        for (let e = 0; e < t.length; e++) s(t[e], a);
        e.$.mainContainer.appendChild(a), e._processHTML(e.$.mainContainer, 1);
    };
    smartTree.prototype.removeItem = function (e) {
        const t = this;
        if (void 0 === (e = t.getItem(e))) return;
        if (e instanceof Smart.TreeItemsGroup) {
            const r = e.container;
            t._isContainerOpened(r.level, r) &&
                t._closeSubContainersTreeMode(r.level, r);
        }
        const r = t.sorted && t.autoSort;
        r && t._unsortItems(t.$.mainContainer);
        const n = e.closest("smart-tree-items-group");
        e.parentElement.removeChild(e),
            (t._menuItems = {}),
            t._refreshItemPaths(
                t.$.mainContainer,
                !0,
                void 0,
                t.sorted && !t.autoSort
            ),
            r && t._applyGrouping(t.$.mainContainer);
        const l = t._state.filter,
            a = t.selectedIndexes.slice(0);
        if (
            (l && t._applyFilter(l),
            t._checkOverflow(),
            (t.selectedIndexes = []),
            t._applySelection(!0, a),
            delete t._treeAnimationInProgress,
            n && !n.querySelector("smart-tree-item"))
        ) {
        }
    };
    smartTree.prototype._getFilterByLabel = function (label) {
        const t = this._getDataSource();
        let item = null;
        const recursion = (treeData) => {
            treeData.forEach((node) => {
                if (node.label === label) {
                    item = node;
                }
                node.items && recursion(node.items, label);
            });
        };
        recursion(t);
        return item;
    };
    smartTree.prototype._endEditing = function (e) {
        const t = this,
            r = t._editedItem;
        if (!r) return;
        if (
            (delete t._editedItem,
            t.$editInput.addClass("smart-hidden"),
            t.focus(),
            e)
        )
            return;
        let n = t.$.editInput.value,
            l = t.sorted && t.autoSort,
            a = t._state.filter;
        if (new RegExp(/^\s*$/g).test(n)) return;
        if (t._getFilterByLabel(n) && n !== r.label) {
            alert(`"节点--${n}"已存在,请重新编辑!`);
            return;
        }
        n !== r.label &&
            (r.set("label", n),
            r.setAttribute("aria-label", n),
            (r.firstElementChild.firstElementChild.firstElementChild.innerHTML =
                n),
            l &&
                (t._unsortItems(t.$.mainContainer),
                t._applyGrouping(t.$.mainContainer)),
            a && t._applyFilter(a));
    };
    smartTree.prototype._startDragging = function (e, t) {
        // 我的收藏夹禁止拖拽
        if (e.value === "BKVirtualMenu/PFC1") return;
        const r = this,
            n = r.selectionMode;
        if (!r.allowDrag || r._editedItem || "none" === n) return;
        const l = [],
            a = [];
        let o;
        if (
            -1 !==
            [
                "one",
                "zeroAndOne",
                "zeroOrOne",
                "checkBox",
                "radioButton",
            ].indexOf(n)
        )
            (o = !1), l.push(e), a.push(e);
        else {
            o = !0;
            for (let e = 0; e < r.selectedIndexes.length; e++)
                l.push(r._menuItems[r.selectedIndexes[e]]), a.push(l[e]);
            for (let e = 0; e < l.length; e++) {
                const t = l[e];
                if (-1 !== a.indexOf(t))
                    for (let e = a.length - 1; e >= 0; e--) {
                        const r = a[e];
                        if (r === t) break;
                        t.contains(r) && a.splice(e, 1);
                    }
            }
        }
        (r._dragDetails = {
            StartPosition: { left: t.pageX, top: t.pageY },
            Items: l,
            ValidItems: a,
            Item: e,
            FeedbackShown: !1,
            ValidateOnDrop: o,
            OriginalEvent: t,
            StartTime: new Date(),
            Dragging: !0,
        }),
            (Smart.Tree.treeItemDragged = !0),
            (r.$.scrollViewer._scrollView.disableSwipeScroll = !0),
            r.allowDrop &&
                ((Smart.Tree.hoveredTree = r), (Smart.Tree.hoveredItem = e));
    };
    smartTree.prototype._startEditing = function (e) {
        // 我的收藏夹禁止编辑
        if (e.value === "BKVirtualMenu/PFC1") return;
        const t = this,
            r = t.$.editInput;
        let n, l;
        if (!t._canItemBeSelected(e, !0)) return;
        const a = e.firstElementChild,
            o = a.firstElementChild;
        t.rightToLeft
            ? ((n = function () {
                  return a.offsetWidth - o.offsetLeft - o.offsetWidth;
              }),
              (l = "paddingRight"))
            : ((n = function () {
                  return (
                      o.offsetLeft +
                      parseFloat(window.getComputedStyle(a).borderLeftWidth)
                  );
              }),
              (l = "paddingLeft")),
            e instanceof Smart.TreeItemsGroup
                ? ((r.style[l] =
                      n() +
                      (t.showLines
                          ? parseFloat(
                                window.getComputedStyle(o.firstElementChild)
                                    .paddingLeft
                            )
                          : 0) -
                      1 +
                      "px"),
                  (r.style.height = a.offsetHeight + "px"))
                : ((r.style[l] =
                      e.offsetWidth +
                      parseInt(a.style[l], 10) -
                      a.offsetWidth +
                      parseFloat(
                          window.getComputedStyle(o.firstElementChild)
                              .paddingLeft
                      ) -
                      2 +
                      "px"),
                  (r.style.height = e.offsetHeight + "px")),
            (r.style.top = t._getOffsetTop(e) + "px"),
            t.$editInput.removeClass("smart-hidden"),
            (r.value = e.label),
            (t._editedItem = e),
            r.setAttribute("aria-label", "Edit item " + e.label),
            setTimeout(function () {
                r.focus();
            }, 0);
    };
})(smartMenu, smartTree);
