/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.init;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.init.MidSystemInit;
import com.bokesoft.yes.init.SystemPropertiesInit;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.base.ISystemConfigProvider;
import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yes.mid.base.SolutionSettingProvider;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.event.BaseEvent;
import com.bokesoft.yes.mid.event.EventUtil;
import com.bokesoft.yes.mid.hotdeploy.MidEnvManager;
import com.bokesoft.yes.mid.hotdeploy.MidPluginManager;
import com.bokesoft.yes.mid.init.a;
import com.bokesoft.yes.mid.module.ServiceModuleManager;
import com.bokesoft.yes.mid.module.YigoBootPluginManager;
import com.bokesoft.yes.mid.serverevent.ServerEventCollector;
import com.bokesoft.yes.mid.servlet.provider.ServiceProvider;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.event.types.PreDestroyEvent;
import com.bokesoft.yigo.mid.event.types.boot.BootErrorEvent;
import com.bokesoft.yigo.mid.event.types.boot.PostBootEvent;
import com.bokesoft.yigo.mid.event.types.boot.PreBootEvent;
import com.bokesoft.yigo.mid.init.IInitProcess;
import com.bokesoft.yigo.mid.init.IInitializer;
import com.bokesoft.yigo.mid.init.YigoAppState;
import com.bokesoft.yigo.mid.scheduler.QuartzManager;
import com.bokesoft.yigo.mid.service.provider.ServiceProviderFactory;
import com.bokesoft.yigo.mid.util.MD5Generator;
import com.bokesoft.yigo.mid.util.resource.icon.IconSourceUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class DefaultInitializer
implements IInitializer {
    private String applicationID = "";
    private String envID = "";
    private Map<String, String> settingFiles = new HashMap<String, String>();
    private IInitProcess process = null;

    public DefaultInitializer(String string) {
        SvrInfo.setAppPath((String)string);
    }

    public void init() {
        YigoBootPluginManager.preBoot();
        this.doInit(false);
    }

    private void doInit(boolean bl) {
        try {
            int n = YigoAppState.getState();
            YigoAppState.setIniting();
            EventUtil.postEvent((BaseEvent)new PreBootEvent(bl));
            if (this.process != null) {
                this.process.doPreInit(bl);
            }
            new SystemPropertiesInit().init();
            if (bl) {
                new MidEnvManager().reload();
            }
            new MidSystemInit().init();
            if (!CoreSetting.getInstance().getSolutionPath().equals("jar")) {
                MD5Generator.generateServerAppMD5((String)SvrInfo.getWebappPath());
            }
            if (n != 200) {
                this.registerServiceProvider();
            }
            this.registerModule();
            try {
                IconSourceUtil.generateCssSource((IMetaFactory)MidGlobalEnv.getInstance().getMetaFactory());
            }
            catch (Exception exception) {
                LogSvr.getInstance().error("generate icon source css file failed", (Throwable)exception);
            }
            LogSvr.getInstance().info("System initialize sucessfully.");
            YigoAppState.setSuccess();
            if (this.process != null) {
                this.process.doPostInit(bl);
            }
            EventUtil.postEvent((BaseEvent)new PostBootEvent(bl));
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            YigoAppState.setFail((Throwable)throwable);
            BootErrorEvent bootErrorEvent = new BootErrorEvent(throwable2, bl);
            EventUtil.postEvent((BaseEvent)bootErrorEvent);
            if (this.process != null) {
                this.process.initErrProcess(throwable2);
                return;
            }
            if (!bootErrorEvent.isProcessed()) {
                throw new RuntimeException(throwable2);
            }
            return;
        }
    }

    protected void registerServiceProvider() {
        ServiceProviderFactory.registerProvider((Object[][])ServiceProvider.getServices());
    }

    protected void registerModule() {
        new ServiceModuleManager().init();
    }

    public void destroy() {
        try {
            YigoAppState.reset();
            if (this.process != null) {
                this.process.doPreDestroy();
            }
            EventUtil.postEvent((BaseEvent)new PreDestroyEvent());
            this.applicationID = "";
            this.envID = "";
            this.settingFiles.clear();
            QuartzManager quartzManager = QuartzManager.getInstance();
            quartzManager.shutdown();
            quartzManager.clear();
            MidPluginManager.deleteTmp();
            if (this.process != null) {
                this.process.doPostDestroy();
            }
            return;
        }
        catch (Throwable throwable) {
            if (this.process != null) {
                this.process.destroyErrProcess(throwable);
                return;
            }
            LogSvr.getInstance().error("destroy error.", throwable);
            return;
        }
    }

    private void doLog(String string) {
        LogSvr.getInstance().debug(string);
    }

    private void initConfig(Map<String, Object> object) {
        this.applicationID = TypeConvertor.toString((Object)object.get("applicationID"));
        this.envID = TypeConvertor.toString((Object)object.get("envID"));
        object = TypeConvertor.toString((Object)object.get("files"));
        object = new JSONObject((String)object);
        this.settingFiles.clear();
        Iterator iterator = object.keys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = object.getString(string);
            this.settingFiles.put(string, string2);
        }
        SolutionSettingProvider.setProvider((ISystemConfigProvider)new a(this));
    }

    public boolean restart(Map<String, Object> map) {
        try {
            this.destroy();
            this.initConfig(map);
            this.doInit(true);
            ServerEventCollector.putEvent((String)"reload");
            return true;
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("restart error.", throwable);
            YigoAppState.setFail((Throwable)throwable);
            return false;
        }
    }

    public Map<String, Object> getHealth() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("state", YigoAppState.getState());
        hashMap.put("applicationID", this.applicationID);
        hashMap.put("envID", this.envID);
        if (YigoAppState.getState() == -1) {
            Throwable throwable = YigoAppState.getError();
            hashMap.put("message", throwable.getMessage());
        }
        return hashMap;
    }

    public void setProcess(IInitProcess iInitProcess) {
        this.process = iInitProcess;
    }

    static /* synthetic */ Map access$000(DefaultInitializer defaultInitializer) {
        return defaultInitializer.settingFiles;
    }

    static /* synthetic */ void access$100(DefaultInitializer defaultInitializer, String string) {
        defaultInitializer.doLog(string);
    }
}

